/*
 * Decompiled with CFR 0.152.
 */
package net.soggymustache.bookworm.client.model;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Scanner;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.soggymustache.bookworm.BookwormMain;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.CMFAnimator;
import net.soggymustache.bookworm.client.model.CMFRig;
import net.soggymustache.bookworm.client.model.ModelPart;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.FileUtils;

public class ModelCMF
extends BookwormModelBase {
    protected final List<ModelPart> parts = Lists.newArrayList();
    protected final List<ModelPart> renderedParts = Lists.newArrayList();
    private CMFAnimator animator;
    private CMFRig rig;
    protected ModelPart NO_PART = new ModelPart();
    private ResourceLocation loaded = null;

    public CMFAnimator getAnimator() {
        return this.animator;
    }

    private ModelCMF(ModelCMF use) {
        this(use.loaded);
    }

    public ModelCMF(ResourceLocation resource) {
        boolean flag = true;
        if (resource.func_110623_a().endsWith(".tbl")) {
            this.initTBL(resource);
        } else if (resource.func_110623_a().endsWith(".bkm")) {
            this.initBKM(resource);
        } else {
            if (BookwormMain.CMF_INFO.containsKey(resource.func_110624_b())) {
                if (BookwormMain.CMF_INFO.get(resource.func_110624_b()) != null && !BookwormMain.CMF_INFO.get((Object)resource.func_110624_b()).cmfOTBL) {
                    try {
                        Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(resource.toString().replace(".cmf", ".tbl")));
                        this.initTBL(new ResourceLocation(resource.toString().replace(".cmf", ".tbl")));
                    }
                    catch (IOException e) {
                        flag = false;
                    }
                } else {
                    flag = false;
                }
            } else {
                flag = false;
            }
            if (!flag) {
                this.init(resource);
            }
        }
        for (ModelPart a : this.parts) {
            if (!a.topLevel) continue;
            this.renderedParts.add(a);
        }
        this.NO_PART.topLevel = false;
        this.NO_PART.part = new BookwormModelRenderer(this, "NO_PART");
        this.parts.add(this.NO_PART);
        this.save();
    }

    public ModelCMF(InputStream stream, ModelMarker marker) {
        boolean flag = true;
        if (marker.equals((Object)ModelMarker.TBL)) {
            this.initTBL(stream);
        } else if (marker.equals((Object)ModelMarker.BKM)) {
            this.initBKM(stream);
        } else if (marker.equals((Object)ModelMarker.CMF)) {
            this.init(stream);
        }
        for (ModelPart a : this.parts) {
            if (!a.topLevel) continue;
            this.renderedParts.add(a);
        }
        this.NO_PART.topLevel = false;
        this.NO_PART.part = new BookwormModelRenderer(this, "NO_PART");
        this.parts.add(this.NO_PART);
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initTBL(InputStream stream) {
        try {
            JsonObject jo;
            String information = "";
            byte[] buffer = new byte[1024];
            try (ZipArchiveInputStream zip2 = new ZipArchiveInputStream(stream);){
                ZipArchiveEntry entry = zip2.getNextZipEntry();
                while (entry != null) {
                    if (entry.getName().endsWith(".json")) {
                        int len;
                        File a = new File("temp.json");
                        FileOutputStream fos = new FileOutputStream(a);
                        while ((len = zip2.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        fos.close();
                        information = FileUtils.readFileToString((File)a, (Charset)Charsets.UTF_8);
                        a.delete();
                        break;
                    }
                    entry = zip2.getNextZipEntry();
                }
            }
            if ((jo = (JsonObject)new JsonParser().parse(information)).has("cubeGroups") && jo.get("cubeGroups").getAsJsonArray().size() >= 1) {
                System.err.printf("There was an error loading %s! The model cannot have cubeGroups", stream);
            }
            stream.close();
            this.field_78089_u = jo.get("textureHeight").getAsInt();
            this.field_78090_t = jo.get("textureWidth").getAsInt();
            JsonArray cubes = jo.get("cubes").getAsJsonArray();
            for (int i = 0; i < cubes.size(); ++i) {
                JsonObject ob = cubes.get(i).getAsJsonObject();
                String name = ob.get("name").getAsString();
                JsonArray txOffset = ob.get("txOffset").getAsJsonArray();
                JsonArray rotation = ob.get("rotation").getAsJsonArray();
                JsonArray offset = ob.get("offset").getAsJsonArray();
                JsonArray position = ob.get("position").getAsJsonArray();
                JsonArray dimensions = ob.get("dimensions").getAsJsonArray();
                ModelPart part = new ModelPart();
                part.part = new BookwormModelRenderer(this, txOffset.get(0).getAsInt(), txOffset.get(1).getAsInt(), name);
                part.part.field_78809_i = ob.get("txMirror").getAsBoolean();
                part.part.func_78793_a((float)position.get(0).getAsDouble(), (float)position.get(1).getAsDouble(), (float)position.get(2).getAsDouble());
                part.part.func_78790_a((float)offset.get(0).getAsDouble(), (float)offset.get(1).getAsDouble(), (float)offset.get(2).getAsDouble(), dimensions.get(0).getAsInt(), dimensions.get(1).getAsInt(), dimensions.get(2).getAsInt(), 0.0f);
                part.part.field_78795_f = (float)Math.toRadians(rotation.get(0).getAsDouble());
                part.part.field_78796_g = (float)Math.toRadians(rotation.get(1).getAsDouble());
                part.part.field_78808_h = (float)Math.toRadians(rotation.get(2).getAsDouble());
                part.topLevel = true;
                this.parts.add(part);
                this.recurse(part, ob.get("children").getAsJsonArray(), name);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private final void initTBL(ResourceLocation resource) {
        try {
            this.initTBL(Minecraft.func_71410_x().func_110442_L().func_110536_a(resource).func_110527_b());
            this.loaded = resource;
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private final void recurse(ModelPart parentPart, JsonArray chil, String parent) {
        for (int i = 0; i < chil.size(); ++i) {
            JsonObject ob = chil.get(i).getAsJsonObject();
            String name = ob.get("name").getAsString();
            JsonArray txOffset = ob.get("txOffset").getAsJsonArray();
            JsonArray rotation = ob.get("rotation").getAsJsonArray();
            JsonArray offset = ob.get("offset").getAsJsonArray();
            JsonArray position = ob.get("position").getAsJsonArray();
            JsonArray dimensions = ob.get("dimensions").getAsJsonArray();
            ModelPart part = new ModelPart();
            part.part = new BookwormModelRenderer(this, txOffset.get(0).getAsInt(), txOffset.get(1).getAsInt(), name);
            part.part.field_78809_i = ob.get("txMirror").getAsBoolean();
            part.part.func_78793_a((float)position.get(0).getAsDouble(), (float)position.get(1).getAsDouble(), (float)position.get(2).getAsDouble());
            part.part.func_78790_a((float)offset.get(0).getAsDouble(), (float)offset.get(1).getAsDouble(), (float)offset.get(2).getAsDouble(), dimensions.get(0).getAsInt(), dimensions.get(1).getAsInt(), dimensions.get(2).getAsInt(), 0.0f);
            part.part.field_78795_f = (float)Math.toRadians(rotation.get(0).getAsDouble());
            part.part.field_78796_g = (float)Math.toRadians(rotation.get(1).getAsDouble());
            part.part.field_78808_h = (float)Math.toRadians(rotation.get(2).getAsDouble());
            part.topLevel = false;
            this.parts.add(part);
            parentPart.part.func_78792_a(part.part);
            this.recurse(part, ob.get("children").getAsJsonArray(), name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initBKM(InputStream stream) {
        try {
            String information = "";
            byte[] buffer = new byte[1024];
            ZipArchiveInputStream zip2 = new ZipArchiveInputStream(stream);
            try {
                ZipArchiveEntry entry = zip2.getNextZipEntry();
                while (entry != null) {
                    if (entry.getName().endsWith(".bkm")) {
                        int len;
                        File a = new File("temp.json");
                        FileOutputStream fos = new FileOutputStream(a);
                        while ((len = zip2.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        fos.close();
                        information = FileUtils.readFileToString((File)a, (Charset)Charsets.UTF_8);
                        a.delete();
                        break;
                    }
                    entry = zip2.getNextZipEntry();
                }
            }
            finally {
                zip2.close();
                stream.close();
            }
            JsonObject jo = (JsonObject)new JsonParser().parse(information);
            this.field_78089_u = jo.get("th").getAsInt();
            this.field_78090_t = jo.get("tw").getAsInt();
            JsonArray cubes = jo.get("cubes").getAsJsonArray();
            for (int i = 0; i < cubes.size(); ++i) {
                JsonObject ob = cubes.get(i).getAsJsonObject();
                String name = ob.get("name").getAsString();
                JsonArray rotation = ob.get("rot").getAsJsonArray();
                JsonArray offset = ob.get("off").getAsJsonArray();
                JsonArray position = ob.get("pos").getAsJsonArray();
                JsonArray dimensions = ob.get("box").getAsJsonArray();
                JsonArray txOffset = ob.get("txo").getAsJsonArray();
                ModelPart part = new ModelPart();
                part.part = new BookwormModelRenderer(this, txOffset.get(0).getAsInt(), txOffset.get(1).getAsInt(), name);
                part.part.field_78809_i = ob.get("txm").getAsBoolean();
                part.part.func_78793_a(position.get(0).getAsFloat(), position.get(1).getAsFloat(), position.get(2).getAsFloat());
                part.part.func_78790_a((float)offset.get(0).getAsDouble(), (float)offset.get(1).getAsDouble(), (float)offset.get(2).getAsDouble(), dimensions.get(0).getAsInt(), dimensions.get(1).getAsInt(), dimensions.get(2).getAsInt(), 0.0f);
                part.part.field_78795_f = (float)Math.toRadians(rotation.get(0).getAsDouble());
                part.part.field_78796_g = (float)Math.toRadians(rotation.get(1).getAsDouble());
                part.part.field_78808_h = (float)Math.toRadians(rotation.get(2).getAsDouble());
                if (ob.get("par").getAsString().equals("null")) {
                    part.topLevel = true;
                } else {
                    this.getPartFromName((String)ob.get((String)"par").getAsString()).part.func_78792_a(part.part);
                    part.topLevel = false;
                }
                this.parts.add(part);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private final void initBKM(ResourceLocation resource) {
        try {
            this.initBKM(Minecraft.func_71410_x().func_110442_L().func_110536_a(resource).func_110527_b());
            this.loaded = resource;
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void init(InputStream stream) {
        try {
            byte[] buffer = new byte[1024];
            ZipArchiveInputStream zip2 = new ZipArchiveInputStream(stream);
            String information = "";
            try {
                ZipArchiveEntry entry = zip2.getNextZipEntry();
                while (entry != null) {
                    int len;
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    while ((len = zip2.read(buffer)) > 0) {
                        outputStream.write(buffer, 0, len);
                    }
                    byte[] ba = new byte[outputStream.toByteArray().length];
                    int a = 0;
                    for (byte b : outputStream.toByteArray()) {
                        ba[a] = (byte)(b - 7);
                        ++a;
                    }
                    ByteArrayOutputStream beag = new ByteArrayOutputStream();
                    beag.write(ba);
                    information = beag.toString(String.valueOf(Charsets.UTF_8));
                    entry = zip2.getNextZipEntry();
                    outputStream.close();
                }
            }
            finally {
                zip2.close();
                stream.close();
            }
            Scanner in = new Scanner(information);
            int textureWidth = Integer.parseInt(in.nextLine().split("=")[1]);
            int textureHeight = Integer.parseInt(in.nextLine().split("=")[1]);
            this.field_78090_t = textureWidth;
            this.field_78089_u = textureHeight;
            while (in.hasNextLine()) {
                String line = in.nextLine();
                if (!line.startsWith("p")) continue;
                int[] txo = new int[2];
                double[] r = new double[3];
                double[] o = new double[3];
                double[] p = new double[3];
                int[] d = new int[3];
                String name = line.split(";")[1].split(";")[0];
                line = line.substring(name.length() + 3);
                d[0] = Integer.valueOf(line.substring(0, line.indexOf(",")));
                line = line.substring((d[0] + "").length() + 1);
                d[1] = Integer.valueOf(line.substring(0, line.indexOf(",")));
                line = line.substring((d[1] + "").length() + 1);
                d[2] = Integer.valueOf(line.substring(0, line.indexOf(";")));
                line = line.substring((d[2] + "").length() + 1);
                p[0] = Double.valueOf(line.substring(0, line.indexOf(",")));
                line = line.substring((p[0] + "").length() + 1);
                p[1] = Double.valueOf(line.substring(0, line.indexOf(",")));
                line = line.substring((p[1] + "").length() + 1);
                p[2] = Double.valueOf(line.substring(0, line.indexOf(";")));
                line = line.substring((p[2] + "").length() + 1);
                o[0] = Double.valueOf(line.substring(0, line.indexOf(",")));
                line = line.substring((o[0] + "").length() + 1);
                o[1] = Double.valueOf(line.substring(0, line.indexOf(",")));
                line = line.substring((o[1] + "").length() + 1);
                o[2] = Double.valueOf(line.substring(0, line.indexOf(";")));
                line = line.substring((o[2] + "").length() + 1);
                r[0] = Double.valueOf(line.substring(0, line.indexOf(",")));
                line = line.substring((r[0] + "").length() + 1);
                r[1] = Double.valueOf(line.substring(0, line.indexOf(",")));
                line = line.substring((r[1] + "").length() + 1);
                r[2] = Double.valueOf(line.substring(0, line.indexOf(";")));
                line = line.substring((r[2] + "").length() + 1);
                txo[0] = Integer.valueOf(line.substring(0, line.indexOf(",")));
                line = line.substring((txo[0] + "").length() + 1);
                txo[1] = Integer.valueOf(line.substring(0, line.indexOf(";")));
                line = line.substring((txo[1] + "").length() + 1);
                boolean txMirror = Boolean.valueOf(line.substring(0, line.indexOf(";")));
                String parent = line = line.substring((txMirror + "").length() + 1);
                ModelPart part = new ModelPart();
                part.part = new BookwormModelRenderer(this, txo[0], txo[1], name);
                part.part.field_78809_i = txMirror;
                part.part.func_78793_a((float)p[0], (float)p[1], (float)p[2]);
                part.part.func_78790_a((float)o[0], (float)o[1], (float)o[2], d[0], d[1], d[2], 0.0f);
                part.part.field_78795_f = (float)Math.toRadians(r[0]);
                part.part.field_78796_g = (float)Math.toRadians(r[1]);
                part.part.field_78808_h = (float)Math.toRadians(r[2]);
                if (parent.equals("null")) {
                    part.topLevel = true;
                    this.parts.add(part);
                    continue;
                }
                part.topLevel = false;
                this.getPartFromName((String)parent).part.func_78792_a(part.part);
                this.parts.add(part);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private final void init(ResourceLocation resource) {
        try {
            this.init(Minecraft.func_71410_x().func_110442_L().func_110536_a(resource).func_110527_b());
            this.loaded = resource;
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public BookwormModelBase setAnimator(Function<ModelCMF, CMFAnimator> func) {
        this.animator = func.apply(this);
        return this;
    }

    public BookwormModelBase setRig(Function<ModelCMF, CMFRig> func) {
        this.rig = func.apply(this);
        return this;
    }

    public BookwormModelBase setRig(CMFRig rig) {
        this.rig = rig;
        return this;
    }

    public CMFRig getRig() {
        return this.rig;
    }

    @Nonnull
    public BookwormModelRenderer getPartFromRig(String rigName) {
        if (this.rig == null) {
            for (ModelRenderer part : this.field_78092_r) {
                if (!((BookwormModelRenderer)part).field_78802_n.equals(rigName)) continue;
                return (BookwormModelRenderer)part;
            }
            return this.NO_PART.part;
        }
        BookwormModelRenderer part = this.rig.getPartByRig(rigName);
        return part == null ? this.NO_PART.part : part;
    }

    public ModelCMF clone() {
        return new ModelCMF(this);
    }

    @Nonnull
    public ModelPart getPartFromName(String name) {
        for (ModelPart a : this.parts) {
            if (!a.part.field_78802_n.equals(name)) continue;
            return a;
        }
        return this.NO_PART;
    }

    @Override
    public BookwormModelRenderer getPartByName(String name) {
        return this.getPartFromRig(name);
    }

    public BookwormModelRenderer getPartByNoRigName(String name) {
        for (ModelRenderer part : this.field_78092_r) {
            if (!((BookwormModelRenderer)part).field_78802_n.equals(name)) continue;
            return (BookwormModelRenderer)part;
        }
        return this.NO_PART.part;
    }

    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        super.func_78088_a(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        this.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, entityIn);
        this.renderedParts.forEach(a -> a.part.func_78785_a(scale));
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        super.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entityIn);
        if (this.animator != null) {
            this.animator.setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entityIn);
        }
    }

    public static enum ModelMarker {
        TBL,
        CMF,
        BKM;

    }
}

