/*
 * Decompiled with CFR 0.152.
 */
package net.soggymustache.bookworm.client.animation.lerp;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.Entity;
import net.soggymustache.bookworm.client.animation.lerp.Animation;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;

public class AnimationHandler {
    private int frame;
    private float timer;
    private List<Animation> animations = Lists.newArrayList();
    private Animation playing;
    private boolean stopping = false;
    public boolean abruptStopping = false;

    public List<Animation> getAnimations() {
        return this.animations;
    }

    public void addAnimation(int i, Animation anim) {
        this.animations.add(i, anim);
    }

    public boolean isPlaying(int i) {
        return this.playing == this.animations.get(i);
    }

    public void play(int i) {
        if (this.playing == null) {
            this.playing = this.animations.get(i);
        }
    }

    public void forcePlay(int i) {
        this.playing = this.animations.get(i);
    }

    public void stopAnimation() {
        if (this.abruptStopping) {
            this.playing = null;
        } else {
            this.stopping = true;
        }
    }

    public Animation getPlayingAnimation() {
        return this.playing;
    }

    public void updateModel(BookwormModelBase model) {
        if (this.playing != null) {
            if (this.frame + 1 < this.playing.getFrames()) {
                model.loadPosedModel(this.playing.models.get(this.frame), this.playing.playedParts);
                if (this.playing.returnToOriginalPose) {
                    if (this.timer > 0.7f) {
                        model.interpolateToPose(this.playing.models.get(0), this.timer, this.playing.playedParts);
                    } else {
                        model.interpolateToPose(this.playing.models.get(this.frame + 1), this.timer, this.playing.playedParts);
                    }
                } else {
                    model.interpolateToPose(this.playing.models.get(this.frame + 1), this.timer, this.playing.playedParts);
                }
            } else if (this.playing.hasLoop) {
                model.loadPosedModel(this.playing.models.get(0), this.playing.playedParts);
                model.interpolateToPose(this.playing.models.get(0), this.timer, this.playing.playedParts);
            }
        }
    }

    public void onEntityUpdate(Entity e) {
        if (this.playing != null) {
            this.timer += this.playing.getSpeedForFrame(this.frame);
            if (this.timer >= 1.0f) {
                ++this.frame;
                this.timer = 0.0f;
            }
            if (this.playing.hasLoop && this.frame >= this.playing.getFrames() - 1 || this.frame >= this.playing.getFrames()) {
                this.frame = 0;
                if (!this.playing.hasLoop) {
                    this.playing = null;
                }
                if (this.stopping) {
                    this.playing = null;
                    this.stopping = false;
                }
            }
        }
    }

    public int getFrame() {
        return this.frame;
    }

    public float getTime() {
        return this.timer;
    }
}

