/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.voicerange.server.voice;

import fr.zeevoker2vex.voicerange.common.utils.MessageBuilder;
import fr.zeevoker2vex.voicerange.server.ServerProxy;
import fr.zeevoker2vex.voicerange.server.voice.SpeakMode;
import java.util.HashMap;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;

public class VoiceManager {
    public static HashMap<EntityPlayer, String> playersSpeakMode = new HashMap();

    public static void connectPlayer(EntityPlayer player) {
        if (ServerProxy.getConfig().hasNoneSpeakMode()) {
            new MessageBuilder.ComponentMessage("\u00a7c").addTranslation("voicerange.nospeakmode.connect", new Object[0]).sendTo((ICommandSender)player);
        } else {
            playersSpeakMode.putIfAbsent(player, ServerProxy.getConfig().getDefaultSpeakMode());
        }
    }

    public static void disconnectPlayer(EntityPlayer player) {
        playersSpeakMode.remove(player);
    }

    public static SpeakMode setNextSpeakMode(EntityPlayer player) {
        SpeakMode current = VoiceManager.getPlayerSpeakMode(player);
        List<String> keys = ServerProxy.getConfig().getSpeakModeKeys();
        int currentIndex = keys.indexOf(current.getKey());
        int nextIndex = keys.size() == currentIndex + 1 ? 0 : currentIndex + 1;
        String nextKey = keys.get(nextIndex);
        VoiceManager.setPlayerSpeakMode(player, nextKey);
        return ServerProxy.getConfig().getSpeakMode(nextKey);
    }

    public static void setPlayerSpeakMode(EntityPlayer player, SpeakMode speakMode) {
        VoiceManager.setPlayerSpeakMode(player, speakMode.getKey());
    }

    public static void setPlayerSpeakMode(EntityPlayer player, String speakModeKey) {
        playersSpeakMode.replace(player, speakModeKey);
    }

    public static SpeakMode getPlayerSpeakMode(EntityPlayer player) {
        return ServerProxy.getConfig().getSpeakMode(playersSpeakMode.get(player));
    }

    public static String getPlayerSpeakModeKey(EntityPlayer player) {
        return playersSpeakMode.get(player);
    }
}

