/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.voicerange.server.voice;

import java.util.HashMap;

public class SpeakMode {
    private final String KEY;
    private int distance;
    private HashMap<String, String> translations;

    public SpeakMode(String KEY, int distance, HashMap<String, String> translations) {
        this.KEY = KEY;
        this.distance = distance;
        this.translations = translations;
    }

    public String getKey() {
        return this.KEY;
    }

    public int getDistance() {
        return this.distance;
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }

    public HashMap<String, String> getTranslations() {
        return this.translations;
    }

    public String getTranslation(String langCode) {
        return this.getTranslations().getOrDefault(langCode, "\u00a7cCannot get translation for langCode " + langCode + " in speak mode " + this.getKey());
    }

    public boolean hasTranslation(String langCode) {
        return this.getTranslations().containsKey(langCode);
    }

    public void addTranslation(String langCode, String translation) {
        this.translations.putIfAbsent(langCode, translation);
    }

    public void removeTranslation(String langCode) {
        this.translations.remove(langCode);
    }

    public void editTranslation(String langCode, String newTranslation) {
        if (this.hasTranslation(langCode)) {
            this.translations.replace(langCode, newTranslation);
        } else {
            this.addTranslation(langCode, newTranslation);
        }
    }

    public void setTranslations(HashMap<String, String> translations) {
        this.translations = translations;
    }
}

