/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.voicerange.server.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import fr.nathanael2611.modularvoicechat.util.Helpers;
import fr.zeevoker2vex.voicerange.common.utils.LogUtils;
import fr.zeevoker2vex.voicerange.server.voice.SpeakMode;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class AddonConfig {
    private String translateType;
    private String forcedLang;
    private String defaultSpeakMode;
    private final HashMap<String, SpeakMode> speakModes = new HashMap();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final File configFile;

    public AddonConfig(File configFile) {
        this.configFile = configFile;
        if (!configFile.exists() || configFile.length() == 0L) {
            this.constructConfigFile();
        } else {
            this.readConfigFile();
        }
    }

    public void constructConfigFile() {
        try {
            LogUtils.basicLog("Config file doesn't exist, trying to create it with default values..");
            this.configFile.createNewFile();
            this.translateType = "user";
            this.forcedLang = "en_us";
            this.defaultSpeakMode = "SPEAK";
            HashMap<String, String> translations = new HashMap<String, String>();
            translations.put("fr_fr", "Vous chuchottez");
            translations.put("en_us", "You whisper");
            SpeakMode whisperMode = new SpeakMode("WHISPER", 5, translations);
            translations = new HashMap();
            translations.put("fr_fr", "Vous parlez normalement");
            translations.put("en_us", "You speak");
            SpeakMode speakMode = new SpeakMode("SPEAK", 15, translations);
            translations = new HashMap();
            translations.put("fr_fr", "Vous criez");
            translations.put("en_us", "You shout");
            SpeakMode shoutMode = new SpeakMode("SHOUT", 30, translations);
            this.speakModes.clear();
            this.speakModes.put(whisperMode.getKey(), whisperMode);
            this.speakModes.put(speakMode.getKey(), speakMode);
            this.speakModes.put(shoutMode.getKey(), shoutMode);
            this.saveToConfig();
            LogUtils.successLog("The default config file has been created with default values!");
        }
        catch (IOException e) {
            LogUtils.errorLog("An error occurred on trying to create config file.");
            e.printStackTrace();
        }
    }

    public boolean readConfigFile() {
        this.speakModes.clear();
        LogUtils.basicLog("Starting to read config file..");
        if (!this.isConfigValid()) {
            LogUtils.errorLog("Error when reading file, it appears that isn't valid (not json syntax, empty file, or don't exist)\nTrying to delete & recreate file to default values.");
            this.configFile.delete();
            this.constructConfigFile();
            return false;
        }
        JsonObject configJson = this.getConfigAsJsonObject();
        JsonObject translationConfig = configJson.getAsJsonObject("translationConfig");
        this.translateType = translationConfig.get("translateType").getAsString();
        this.forcedLang = translationConfig.get("forcedLang").getAsString();
        this.defaultSpeakMode = configJson.get("defaultSpeakMode").getAsString();
        JsonObject speakModesObject = configJson.getAsJsonObject("speakModes");
        for (Map.Entry entry : speakModesObject.entrySet()) {
            String KEY = (String)entry.getKey();
            JsonObject speakModeObject = (JsonObject)entry.getValue();
            int distance = speakModeObject.get("distance").getAsInt();
            HashMap<String, String> translations = new HashMap<String, String>();
            JsonObject smTranslations = speakModeObject.getAsJsonObject("translations");
            for (Map.Entry translationsEntry : smTranslations.entrySet()) {
                translations.put((String)translationsEntry.getKey(), ((JsonElement)translationsEntry.getValue()).getAsString());
            }
            SpeakMode speakMode = new SpeakMode(KEY, distance, translations);
            this.speakModes.put(KEY, speakMode);
        }
        LogUtils.successLog("The config file has been successfully read!");
        return true;
    }

    public boolean saveToConfig() {
        LogUtils.basicLog("\u00a77Starting to save values to config file..");
        JsonObject configJson = new JsonObject();
        JsonObject translationConfig = new JsonObject();
        translationConfig.add("translateType", (JsonElement)new JsonPrimitive(this.translateType));
        translationConfig.add("forcedLang", (JsonElement)new JsonPrimitive(this.forcedLang));
        configJson.add("translationConfig", (JsonElement)translationConfig);
        configJson.add("defaultSpeakMode", (JsonElement)new JsonPrimitive(this.defaultSpeakMode));
        JsonObject speakModesObject = new JsonObject();
        for (Map.Entry<String, SpeakMode> entry : this.speakModes.entrySet()) {
            SpeakMode speakMode = entry.getValue();
            JsonObject speakModeObject = new JsonObject();
            speakModeObject.add("distance", (JsonElement)new JsonPrimitive((Number)speakMode.getDistance()));
            JsonObject smTranslations = new JsonObject();
            for (Map.Entry<String, String> translationsEntry : speakMode.getTranslations().entrySet()) {
                smTranslations.add(translationsEntry.getKey(), (JsonElement)new JsonPrimitive(translationsEntry.getValue()));
            }
            speakModeObject.add("translations", (JsonElement)smTranslations);
            speakModesObject.add(entry.getKey(), (JsonElement)speakModeObject);
        }
        configJson.add("speakModes", (JsonElement)speakModesObject);
        try {
            FileUtils.writeStringToFile((File)this.getConfigFile(), (String)GSON.toJson((JsonElement)configJson), (Charset)Charset.defaultCharset(), (boolean)false);
        }
        catch (IOException e) {
            LogUtils.errorLog("An error occurred on saving config in file!");
            e.printStackTrace();
            return false;
        }
        LogUtils.successLog("Values has been saved in config file!");
        return true;
    }

    private boolean isConfigValid() {
        return this.getConfigFile().exists() && this.getConfigFile().length() > 0L && this.getConfigAsJsonObject() != null;
    }

    private JsonObject getConfigAsJsonObject() {
        try {
            return new JsonParser().parse(Helpers.readFileToString((File)this.getConfigFile())).getAsJsonObject();
        }
        catch (JsonParseException exception) {
            return null;
        }
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void setTranslateType(String translateType) {
        this.translateType = translateType;
    }

    public String getTranslateType() {
        return this.translateType;
    }

    public boolean isForcedTranslation() {
        return this.getTranslateType().equals("forced");
    }

    public void setForcedLang(String forcedLang) {
        this.forcedLang = forcedLang;
    }

    public String getForcedLang() {
        return this.forcedLang;
    }

    public void setDefaultSpeakMode(String defaultSpeakMode) {
        this.defaultSpeakMode = defaultSpeakMode;
    }

    public String getDefaultSpeakMode() {
        return this.defaultSpeakMode;
    }

    public HashMap<String, SpeakMode> getSpeakModes() {
        return this.speakModes;
    }

    public List<String> getSpeakModeKeys() {
        return new ArrayList<String>(this.getSpeakModes().keySet());
    }

    public boolean hasNoneSpeakMode() {
        return this.getSpeakModes().size() == 0 || this.getDefaultSpeakMode().equals("");
    }

    public boolean speakModeExist(String KEY) {
        return this.getSpeakModes().containsKey(KEY);
    }

    public SpeakMode getSpeakMode(String KEY) {
        return this.getSpeakModes().get(KEY);
    }

    public void addSpeakMode(String KEY, SpeakMode speakMode) {
        this.speakModes.putIfAbsent(KEY, speakMode);
    }

    public void removeSpeakMode(String KEY) {
        this.speakModes.remove(KEY);
    }

    public void editSpeakMode(String KEY, SpeakMode newSpeakMode) {
        this.speakModes.replace(KEY, newSpeakMode);
    }

    public void editSpeakModeDistance(String KEY, int newDistance) {
        SpeakMode newSpeakMode = this.getSpeakMode(KEY);
        newSpeakMode.setDistance(newDistance);
        this.speakModes.replace(KEY, newSpeakMode);
    }
}

