/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.voicerange.server.commands;

import com.google.common.collect.Maps;
import fr.zeevoker2vex.voicerange.common.utils.CommandHelpBuilder;
import fr.zeevoker2vex.voicerange.common.utils.MessageBuilder;
import fr.zeevoker2vex.voicerange.server.ServerProxy;
import fr.zeevoker2vex.voicerange.server.voice.SpeakMode;
import fr.zeevoker2vex.voicerange.server.voice.VoiceManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class VoiceRangeCommand
extends CommandBase {
    private final HashMap<String, Integer> commandArguments = new HashMap();
    private final List<String> speakModeArguments = new ArrayList<String>();
    private final List<String> configArguments = new ArrayList<String>();

    public VoiceRangeCommand() {
        this.commandArguments.put("rlconfig", 0);
        this.commandArguments.put("save", 0);
        this.commandArguments.put("speakmodes", 0);
        this.commandArguments.put("help", 0);
        this.commandArguments.put("speakmode", 10);
        this.commandArguments.put("config", 7);
        this.speakModeArguments.add("create:");
        this.speakModeArguments.add("delete:");
        this.speakModeArguments.add("edit;distance:");
        this.speakModeArguments.add("edit;translation.langCode:");
        this.speakModeArguments.add("edit;defaultSpeakMode:");
        this.configArguments.add("defaultSpeakMode");
        this.configArguments.add("translateType");
        this.configArguments.add("forcedLang");
    }

    public String func_71517_b() {
        return "voicerange";
    }

    public String func_71518_a(ICommandSender sender) {
        return "\u00a7cUsage: /voicerange <rlconfig/save/help/speakmodes/speakmode/config> [SpeakModeKey/configKey] [key:value/configValue]\n\u00a7cSee /voicerange help for details.";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        MessageBuilder.ComponentMessage message = new MessageBuilder.ComponentMessage("");
        if (args.length == 1) {
            if (args[0].equals("rlconfig")) {
                if (ServerProxy.getConfig().readConfigFile()) {
                    message.reset("\u00a72").addTranslation("cmd.voicerange.rlconfig.success", new Object[0]).sendTo(sender);
                } else {
                    message.reset("\u00a7c").addTranslation("cmd.voicerange.rlconfig.failed", new Object[0]).addString(" (see logs)").sendTo(sender);
                }
                return;
            }
            if (args[0].equals("save")) {
                if (ServerProxy.getConfig().saveToConfig()) {
                    message.reset("\u00a72").addTranslation("cmd.voicerange.save.success", new Object[0]).sendTo(sender);
                } else {
                    message.reset("\u00a7c").addTranslation("cmd.voicerange.save.failed", new Object[0]).addString(" (see logs)").sendTo(sender);
                }
                return;
            }
            if (args[0].equals("speakmodes")) {
                message = message.reset("cmd.voicerange.speakmodes.title", new Object[0]);
                for (Map.Entry<String, SpeakMode> entry : ServerProxy.getConfig().getSpeakModes().entrySet()) {
                    SpeakMode speakMode = entry.getValue();
                    message = message.addTranslationLine("cmd.voicerange.speakmodes.mode", entry.getKey(), speakMode.getDistance());
                    for (Map.Entry<String, String> trEntry : speakMode.getTranslations().entrySet()) {
                        message = message.addLine("    ").addTranslation("cmd.voicerange.speakmodes.translation", trEntry.getKey(), trEntry.getValue());
                    }
                }
                message.sendTo(sender);
                return;
            }
            if (args[0].equals("help")) {
                CommandHelpBuilder commandHelpBuilder = new CommandHelpBuilder(this.func_71517_b(), new ArrayList<String>(this.commandArguments.keySet()));
                commandHelpBuilder.build().sendTo(sender);
                return;
            }
        } else if (args.length == 2) {
            if (args[0].equals("help")) {
                String detailedArg = args[1];
                if (this.commandArguments.containsKey(detailedArg)) {
                    CommandHelpBuilder.ArgumentBuilder argumentBuilder = new CommandHelpBuilder.ArgumentBuilder(this.func_71517_b(), detailedArg, this.commandArguments.get(detailedArg));
                    argumentBuilder.build().sendTo(sender);
                } else {
                    message.reset("\u00a7c").addTranslation("cmd.voicerange.help.details.failed", detailedArg, this.func_71517_b()).sendTo(sender);
                }
                return;
            }
            if (args[0].equals("speakmode")) {
                String speakModeKey = args[1];
                if (ServerProxy.getConfig().speakModeExist(speakModeKey)) {
                    SpeakMode speakMode = ServerProxy.getConfig().getSpeakMode(speakModeKey);
                    message = message.reset("cmd.voicerange.speakmode.title", speakModeKey).addTranslationLine("cmd.voicerange.speakmode.distance", speakMode.getDistance());
                    for (Map.Entry<String, String> trEntry : speakMode.getTranslations().entrySet()) {
                        message = message.addLine("    ").addTranslation("cmd.voicerange.speakmode.translation", trEntry.getKey(), trEntry.getValue());
                    }
                    message.sendTo(sender);
                } else {
                    message.reset("\u00a7c").addTranslation("cmd.voicerange.speakmode.failed", speakModeKey, speakModeKey).sendTo(sender);
                }
                return;
            }
            if (args[0].equals("config")) {
                String configKey = args[1];
                if (this.configArguments.contains(configKey)) {
                    if (configKey.equals("defaultSpeakMode")) {
                        message = message.reset("\u00a77").addTranslation("cmd.voicerange.config.defaultSpeakMode.get", ServerProxy.getConfig().getDefaultSpeakMode());
                        message.sendTo(sender);
                    } else if (configKey.equals("translateType")) {
                        message = message.reset("\u00a77").addTranslation("cmd.voicerange.config.translateType.get", ServerProxy.getConfig().getTranslateType()).addTranslation("voicerange.translateType.infos", new Object[0]);
                        message.sendTo(sender);
                    } else if (configKey.equals("forcedLang")) {
                        message = message.reset("\u00a77").addTranslation("cmd.voicerange.config.forcedLang.get.langCode", ServerProxy.getConfig().getForcedLang());
                        boolean isServerUsed = ServerProxy.getConfig().isForcedTranslation();
                        message = isServerUsed ? message.addTranslationLine("cmd.voicerange.config.forcedLang.langServer", new Object[0]) : message.addTranslationLine("cmd.voicerange.config.forcedLang.langClient", new Object[0]);
                        message.sendTo(sender);
                    }
                } else {
                    message = message.reset("\u00a7c").addTranslation("cmd.voicerange.config.failed", configKey);
                    message.sendTo(sender);
                }
                return;
            }
        } else {
            if (args.length == 3 && args[0].equals("config")) {
                String configKey = args[1];
                if (this.configArguments.contains(configKey)) {
                    String configValue = args[2];
                    if (configKey.equals("defaultSpeakMode")) {
                        if (ServerProxy.getConfig().speakModeExist(configValue)) {
                            ServerProxy.getConfig().setDefaultSpeakMode(configValue);
                            message = message.reset("\u00a72").addTranslation("cmd.voicerange.config.defaultSpeakMode.set", configValue);
                            message.sendTo(sender);
                        } else {
                            message.reset("\u00a7c").addTranslation("cmd.voicerange.speakmode.failed", configValue).sendTo(sender);
                        }
                    } else if (configKey.equals("translateType")) {
                        if (configValue.equals("user") || configValue.equals("forced")) {
                            ServerProxy.getConfig().setTranslateType(configValue);
                            message = message.reset("\u00a72").addTranslation("cmd.voicerange.config.translateType.set", configValue);
                        } else {
                            message = message.reset("\u00a7c").addTranslation("cmd.voicerange.config.translateType.set.failed", configValue).addTranslationLine("voicerange.translateType.infos", new Object[0]);
                        }
                        message.sendTo(sender);
                    } else if (configKey.equals("forcedLang")) {
                        ServerProxy.getConfig().setForcedLang(configValue);
                        message = message.reset("\u00a77").addTranslation("cmd.voicerange.config.forcedLang.set", configValue);
                        boolean isServerUsed = ServerProxy.getConfig().isForcedTranslation();
                        message = isServerUsed ? message.addTranslationLine("cmd.voicerange.config.forcedLang.langServer", new Object[0]) : message.addTranslationLine("cmd.voicerange.config.forcedLang.langClient", new Object[0]);
                        message.sendTo(sender);
                    }
                } else {
                    message = message.reset("\u00a7c").addTranslation("cmd.voicerange.config.failed", configKey);
                    message.sendTo(sender);
                }
                return;
            }
            if (args.length >= 3 && args[0].equals("speakmode")) {
                String speakModeKey = args[1];
                if (ServerProxy.getConfig().speakModeExist(speakModeKey) || args[2].startsWith("create:")) {
                    String input = String.join((CharSequence)" ", args);
                    Pattern pattern = Pattern.compile("([^:]*) ([\\w\\.\\;]+:.+)");
                    Matcher matcher = pattern.matcher(input);
                    if (matcher.matches()) {
                        input = matcher.group(2);
                        pattern = Pattern.compile("([^:]*):(.*)");
                        matcher = pattern.matcher(input);
                        if (matcher.matches()) {
                            String key = matcher.group(1);
                            String value = matcher.group(2);
                            String keyReplacement = "";
                            pattern = Pattern.compile("(.+)\\.(.+)");
                            matcher = pattern.matcher(key);
                            if (matcher.matches()) {
                                String realKey = matcher.group(1);
                                keyReplacement = matcher.group(2);
                                for (String string : this.speakModeArguments) {
                                    String[] keys = string.split("\\.");
                                    if (keys.length != 2) continue;
                                    String argRealKey = keys[0];
                                    String argReplaceKey = keys[1];
                                    if (!realKey.equals(argRealKey)) continue;
                                    key = key.replaceAll(keyReplacement, argReplaceKey.replaceAll(":", ""));
                                    break;
                                }
                            }
                            if (this.speakModeArguments.contains(key + ":")) {
                                if (key.equals("create")) {
                                    if (!ServerProxy.getConfig().speakModeExist(speakModeKey)) {
                                        int distance;
                                        try {
                                            distance = Integer.parseInt(value);
                                        }
                                        catch (NumberFormatException exception) {
                                            message = message.reset("\u00a7c").addTranslation("cmd.voicerange.distance.NaN", new Object[0]);
                                            message.sendTo(sender);
                                            return;
                                        }
                                        if (distance > 0 && distance < 10000) {
                                            SpeakMode speakMode = new SpeakMode(speakModeKey, distance, Maps.newHashMap());
                                            speakMode.addTranslation("fr_fr", "Traduction par d\u00e9faut. Modifiez-la avec /voicerange speakmode " + speakModeKey + " edit;translation.langCode:votre traduction");
                                            speakMode.addTranslation("en_us", "Default translation. Edit with /voicerange speakmode " + speakModeKey + " edit;translation.langCode:your translation");
                                            ServerProxy.getConfig().addSpeakMode(speakModeKey, speakMode);
                                            if (ServerProxy.getConfig().getSpeakModes().size() == 1) {
                                                ServerProxy.getConfig().setDefaultSpeakMode(speakModeKey);
                                                message = message.reset("\u00a7e").addTranslation("cmd.voicerange.speakmode.create.speakModeAvailable", new Object[0]);
                                                for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
                                                    VoiceManager.connectPlayer((EntityPlayer)player);
                                                    message.sendTo((ICommandSender)player);
                                                }
                                            }
                                            message = message.reset("\u00a72").addTranslation("cmd.voicerange.speakmode.create.success1", speakModeKey);
                                        } else {
                                            message = message.reset("\u00a7c").addTranslation("cmd.voicerange.distance.range", new Object[0]);
                                        }
                                    } else {
                                        message = message.reset("\u00a7c").addTranslation("cmd.voicerange.speakmode.create.alreadyexist", speakModeKey);
                                    }
                                    message.sendTo(sender);
                                } else if (key.equals("delete")) {
                                    if (value.equals("confirm")) {
                                        if (ServerProxy.getConfig().getSpeakModes().size() == 1) {
                                            ServerProxy.getConfig().setDefaultSpeakMode("");
                                            message = message.reset("\u00a7e").addTranslation("cmd.voicerange.speakmode.delete.noneSpeakModePlayers", new Object[0]);
                                            for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
                                                VoiceManager.disconnectPlayer((EntityPlayer)player);
                                                message.sendTo((ICommandSender)player);
                                            }
                                            message = message.reset("\u00a74").addTranslation("cmd.voicerange.speakmode.delete.noneSpeakModeSender", speakModeKey).addTranslationLine("cmd.voicerange.speakmode.create.success1", new Object[0]);
                                            message.sendTo(sender);
                                        } else {
                                            String newSpeakMode = "";
                                            if (ServerProxy.getConfig().getDefaultSpeakMode().equals(speakModeKey)) {
                                                int n;
                                                List<String> keys = ServerProxy.getConfig().getSpeakModeKeys();
                                                boolean bl = false;
                                                if (keys.indexOf(speakModeKey) == 0) {
                                                    n = 1;
                                                }
                                                newSpeakMode = keys.get(n);
                                                ServerProxy.getConfig().setDefaultSpeakMode(newSpeakMode);
                                                message = message.reset("\u00a7c").addTranslation("cmd.voicerange.speakmode.delete.defaultSpeakMode", newSpeakMode);
                                                message.sendTo(sender);
                                            }
                                            message = message.reset("\u00a7e").addTranslationLine("cmd.voicerange.speakmode.delete.playerMoveSpeakMode", new Object[0]);
                                            for (EntityPlayerMP entityPlayerMP : server.func_184103_al().func_181057_v()) {
                                                if (!VoiceManager.getPlayerSpeakModeKey((EntityPlayer)entityPlayerMP).equals(speakModeKey)) continue;
                                                VoiceManager.setPlayerSpeakMode((EntityPlayer)entityPlayerMP, newSpeakMode);
                                                message.sendTo((ICommandSender)entityPlayerMP);
                                            }
                                        }
                                        ServerProxy.getConfig().removeSpeakMode(speakModeKey);
                                        message = message.reset("\u00a72").addTranslation("cmd.voicerange.speakmode.delete.success1", speakModeKey);
                                    } else {
                                        message = message.reset("\u00a7c").addTranslation("cmd.voicerange.speakmode.delete.failed", speakModeKey);
                                    }
                                    message.sendTo(sender);
                                } else if (key.equals("edit;distance")) {
                                    int distance;
                                    try {
                                        distance = Integer.parseInt(value);
                                    }
                                    catch (NumberFormatException exception) {
                                        message = message.reset("\u00a7c").addTranslation("cmd.voicerange.distance.NaN", new Object[0]);
                                        message.sendTo(sender);
                                        return;
                                    }
                                    if (distance > 0 && distance < 10000) {
                                        ServerProxy.getConfig().editSpeakModeDistance(speakModeKey, distance);
                                        message = message.reset("\u00a72").addTranslation("cmd.voicerange.speakmode.edit.distance.success", speakModeKey, distance);
                                    } else {
                                        message = message.reset("\u00a7c").addTranslation("cmd.voicerange.distance.range", new Object[0]);
                                    }
                                    message.sendTo(sender);
                                } else if (key.equals("edit;translation.langCode")) {
                                    SpeakMode speakMode = ServerProxy.getConfig().getSpeakMode(speakModeKey);
                                    message = message.reset("\u00a72");
                                    if (value.equals("remove") || value.equals("delete")) {
                                        speakMode.removeTranslation(keyReplacement);
                                        message = message.addTranslation("cmd.voicerange.speakmode.edit.translation.remove", keyReplacement, speakModeKey);
                                    } else if (speakMode.hasTranslation(keyReplacement)) {
                                        speakMode.editTranslation(keyReplacement, value);
                                        message = message.addTranslation("cmd.voicerange.speakmode.edit.translation.edit", keyReplacement, speakModeKey);
                                    } else {
                                        speakMode.addTranslation(keyReplacement, value);
                                        message = message.addTranslation("cmd.voicerange.speakmode.edit.translation.add", keyReplacement, speakModeKey);
                                    }
                                    message.sendTo(sender);
                                } else if (key.equals("edit;defaultSpeakMode")) {
                                    if (value.equals("confirm")) {
                                        ServerProxy.getConfig().setDefaultSpeakMode(speakModeKey);
                                        message = message.reset("\u00a72").addTranslation("cmd.voicerange.config.defaultSpeakMode.set", speakModeKey);
                                    } else {
                                        message = message.reset("\u00a7c").addTranslation("cmd.voicerange.speakmode.edit.defaultSpeakMode.failed", speakModeKey, speakModeKey);
                                    }
                                    message.sendTo(sender);
                                }
                            } else {
                                message = message.reset("\u00a7c").addTranslation("cmd.voicerange.speakmode.keyNoExist", key, speakModeKey);
                                message.sendTo(sender);
                            }
                        } else {
                            message = message.reset("\u00a7c").addTranslation("cmd.voicerange.speakmode.pairNotFound", new Object[0]).addLine("\u00a74IMPOSSIBLE, ALREADY VERIFIED PREVIOUSLY !");
                            message.sendTo(sender);
                        }
                    } else {
                        message = message.reset("\u00a7c").addTranslation("cmd.voicerange.speakmode.pairNotFound", new Object[0]);
                        message.sendTo(sender);
                    }
                } else {
                    message.reset("\u00a7c").addTranslation("cmd.voicerange.speakmode.failed", speakModeKey, speakModeKey).sendTo(sender);
                }
                return;
            }
        }
        this.sendMessage(sender, this.func_71518_a(sender));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return VoiceRangeCommand.func_175762_a((String[])args, this.commandArguments.keySet());
        }
        if (args.length == 2) {
            switch (args[0]) {
                case "speakmode": {
                    return VoiceRangeCommand.func_175762_a((String[])args, ServerProxy.getConfig().getSpeakModeKeys());
                }
                case "config": {
                    return VoiceRangeCommand.func_175762_a((String[])args, this.configArguments);
                }
                case "help": {
                    return VoiceRangeCommand.func_175762_a((String[])args, this.commandArguments.keySet());
                }
            }
        } else if (args.length == 3) {
            if (args[0].equals("speakmode") && ServerProxy.getConfig().speakModeExist(args[1])) {
                return VoiceRangeCommand.func_175762_a((String[])args, this.speakModeArguments);
            }
            if (args[0].equals("config")) {
                if (args[1].equals("translateType")) {
                    return VoiceRangeCommand.func_71530_a((String[])args, (String[])new String[]{"forced", "user"});
                }
                if (args[1].equals("defaultSpeakMode")) {
                    return VoiceRangeCommand.func_175762_a((String[])args, ServerProxy.getConfig().getSpeakModeKeys());
                }
            }
        }
        return new ArrayList<String>();
    }

    public void sendMessage(ICommandSender sender, String message) {
        sender.func_145747_a((ITextComponent)new TextComponentString(message));
    }
}

