/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.voicerange.common.utils;

import fr.zeevoker2vex.voicerange.common.utils.MessageBuilder;
import java.util.List;

public class CommandHelpBuilder {
    public String cmdName;
    public List<String> args;

    public CommandHelpBuilder(String cmdName, List<String> args) {
        this.cmdName = cmdName;
        this.args = args;
    }

    public MessageBuilder.ComponentMessage build() {
        String prefix = "cmd." + this.cmdName + ".help.";
        MessageBuilder.ComponentMessage helpMessage = new MessageBuilder.ComponentMessage(prefix + "title", this.cmdName).addTranslationLine(prefix + "syntax", new Object[0]).addTranslationLine(prefix + "argstitle", new Object[0]);
        for (String arg : this.args) {
            String argKey = prefix + arg;
            helpMessage.addLine("    ").addTranslation(argKey, new Object[0]);
        }
        return helpMessage;
    }

    public static class ArgumentBuilder {
        public String cmdName;
        public String arg;
        public int numberOfDetails;

        public ArgumentBuilder(String cmdName, String arg, int numberOfDetails) {
            this.cmdName = cmdName;
            this.arg = arg;
            this.numberOfDetails = numberOfDetails;
        }

        public MessageBuilder.ComponentMessage build() {
            String prefix = "cmd." + this.cmdName + ".help.";
            String argKey = prefix + this.arg;
            MessageBuilder.ComponentMessage helpMessage = new MessageBuilder.ComponentMessage(prefix + "details.title", this.cmdName, this.arg).addTranslationLine(argKey, new Object[0]);
            if (this.numberOfDetails > 0) {
                for (int i = 1; i < this.numberOfDetails + 1; ++i) {
                    String argDetailKey = argKey + "." + i;
                    helpMessage.addTranslationLine(argDetailKey, new Object[0]);
                }
            }
            return helpMessage;
        }
    }
}

