/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.voicerange.common.network.server;

import fr.zeevoker2vex.voicerange.common.utils.MessageBuilder;
import fr.zeevoker2vex.voicerange.server.ServerProxy;
import fr.zeevoker2vex.voicerange.server.config.AddonConfig;
import fr.zeevoker2vex.voicerange.server.voice.SpeakMode;
import fr.zeevoker2vex.voicerange.server.voice.VoiceManager;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerChangeSpeakModePacket
implements IMessage {
    public String languageCode;

    public PlayerChangeSpeakModePacket(String languageCode) {
        this.languageCode = languageCode;
    }

    public PlayerChangeSpeakModePacket() {
    }

    public void fromBytes(ByteBuf buf) {
        this.languageCode = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.languageCode);
    }

    public static class ServerHandler
    implements IMessageHandler<PlayerChangeSpeakModePacket, IMessage> {
        @SideOnly(value=Side.SERVER)
        public IMessage onMessage(PlayerChangeSpeakModePacket message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (ServerProxy.getConfig().hasNoneSpeakMode()) {
                MessageBuilder.ComponentMessage messageBuilder = new MessageBuilder.ComponentMessage("\u00a7c").addTranslation("voicerange.nospeakmode.change", new Object[0]);
                player.func_146105_b((ITextComponent)messageBuilder.getComponent(), true);
                return null;
            }
            SpeakMode newSpeakMode = VoiceManager.setNextSpeakMode((EntityPlayer)player);
            AddonConfig config = ServerProxy.getConfig();
            String lang = config.isForcedTranslation() ? config.getForcedLang() : message.languageCode;
            player.func_146105_b((ITextComponent)new TextComponentString(newSpeakMode.getTranslation(lang).replaceAll("&", "\u00a7")), true);
            return null;
        }
    }
}

