/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj;

import fr.zeevoker2vex.radio.util.org.apache.commons.math3.complex.Complex;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.LayoutBase;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.PoleZeroPair;

public class LowPassTransform {
    private double f;

    private Complex transform(Complex c) {
        if (c.isInfinite()) {
            return new Complex(-1.0, 0.0);
        }
        c = c.multiply(this.f);
        Complex one = new Complex(1.0, 0.0);
        return one.add(c).divide(one.subtract(c));
    }

    public LowPassTransform(double fc, LayoutBase digital, LayoutBase analog) {
        digital.reset();
        if (fc < 0.0) {
            throw new ArithmeticException("Cutoff frequency cannot be negative.");
        }
        if (!(fc < 0.5)) {
            throw new ArithmeticException("Cutoff frequency must be less than the Nyquist frequency.");
        }
        this.f = Math.tan(Math.PI * fc);
        int numPoles = analog.getNumPoles();
        int pairs = numPoles / 2;
        for (int i = 0; i < pairs; ++i) {
            PoleZeroPair pair = analog.getPair(i);
            digital.addPoleZeroConjugatePairs(this.transform(pair.poles.first), this.transform(pair.zeros.first));
        }
        if ((numPoles & 1) == 1) {
            PoleZeroPair pair = analog.getPair(pairs);
            digital.add(this.transform(pair.poles.first), this.transform(pair.zeros.first));
        }
        digital.setNormal(analog.getNormalW(), analog.getNormalGain());
    }
}

