/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj;

import fr.zeevoker2vex.radio.util.org.apache.commons.math3.complex.Complex;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.ComplexPair;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.PoleZeroPair;

public class LayoutBase {
    private int m_numPoles;
    private PoleZeroPair[] m_pair;
    private double m_normalW;
    private double m_normalGain;

    public LayoutBase(PoleZeroPair[] pairs) {
        this.m_numPoles = pairs.length * 2;
        this.m_pair = pairs;
    }

    public LayoutBase(int numPoles) {
        this.m_numPoles = 0;
        this.m_pair = numPoles % 2 == 1 ? new PoleZeroPair[numPoles / 2 + 1] : new PoleZeroPair[numPoles / 2];
    }

    public void reset() {
        this.m_numPoles = 0;
    }

    public int getNumPoles() {
        return this.m_numPoles;
    }

    public void add(Complex pole, Complex zero) {
        this.m_pair[this.m_numPoles / 2] = new PoleZeroPair(pole, zero);
        ++this.m_numPoles;
    }

    public void addPoleZeroConjugatePairs(Complex pole, Complex zero) {
        if (pole == null) {
            System.out.println("LayoutBase addConj() pole == null");
        }
        if (zero == null) {
            System.out.println("LayoutBase addConj() zero == null");
        }
        if (this.m_pair == null) {
            System.out.println("LayoutBase addConj() m_pair == null");
        }
        this.m_pair[this.m_numPoles / 2] = new PoleZeroPair(pole, zero, pole.conjugate(), zero.conjugate());
        this.m_numPoles += 2;
    }

    public void add(ComplexPair poles, ComplexPair zeros) {
        this.m_pair[this.m_numPoles / 2] = new PoleZeroPair(poles.first, zeros.first, poles.second, zeros.second);
        this.m_numPoles += 2;
    }

    public PoleZeroPair getPair(int pairIndex) {
        return this.m_pair[pairIndex];
    }

    public double getNormalW() {
        return this.m_normalW;
    }

    public double getNormalGain() {
        return this.m_normalGain;
    }

    public void setNormal(double w, double g) {
        this.m_normalW = w;
        this.m_normalGain = g;
    }
}

