/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj;

import fr.zeevoker2vex.radio.util.org.apache.commons.math3.complex.Complex;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.BandPassTransform;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.BandStopTransform;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.Cascade;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.HighPassTransform;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.LayoutBase;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.LowPassTransform;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.MathSupplement;

public class ChebyshevI
extends Cascade {
    private void setupLowPass(int order, double sampleRate, double cutoffFrequency, double rippleDb, int directFormType) {
        AnalogLowPass m_analogProto = new AnalogLowPass(order);
        m_analogProto.design(rippleDb);
        LayoutBase m_digitalProto = new LayoutBase(order);
        new LowPassTransform(cutoffFrequency / sampleRate, m_digitalProto, m_analogProto);
        this.setLayout(m_digitalProto, directFormType);
    }

    public void lowPass(int order, double sampleRate, double cutoffFrequency, double rippleDb) {
        this.setupLowPass(order, sampleRate, cutoffFrequency, rippleDb, 1);
    }

    public void lowPass(int order, double sampleRate, double cutoffFrequency, double rippleDb, int directFormType) {
        this.setupLowPass(order, sampleRate, cutoffFrequency, rippleDb, directFormType);
    }

    private void setupHighPass(int order, double sampleRate, double cutoffFrequency, double rippleDb, int directFormType) {
        AnalogLowPass m_analogProto = new AnalogLowPass(order);
        m_analogProto.design(rippleDb);
        LayoutBase m_digitalProto = new LayoutBase(order);
        new HighPassTransform(cutoffFrequency / sampleRate, m_digitalProto, m_analogProto);
        this.setLayout(m_digitalProto, directFormType);
    }

    public void highPass(int order, double sampleRate, double cutoffFrequency, double rippleDb) {
        this.setupHighPass(order, sampleRate, cutoffFrequency, rippleDb, 1);
    }

    public void highPass(int order, double sampleRate, double cutoffFrequency, double rippleDb, int directFormType) {
        this.setupHighPass(order, sampleRate, cutoffFrequency, rippleDb, directFormType);
    }

    private void setupBandStop(int order, double sampleRate, double centerFrequency, double widthFrequency, double rippleDb, int directFormType) {
        AnalogLowPass m_analogProto = new AnalogLowPass(order);
        m_analogProto.design(rippleDb);
        LayoutBase m_digitalProto = new LayoutBase(order * 2);
        new BandStopTransform(centerFrequency / sampleRate, widthFrequency / sampleRate, m_digitalProto, m_analogProto);
        this.setLayout(m_digitalProto, directFormType);
    }

    public void bandStop(int order, double sampleRate, double centerFrequency, double widthFrequency, double rippleDb) {
        this.setupBandStop(order, sampleRate, centerFrequency, widthFrequency, rippleDb, 1);
    }

    public void bandStop(int order, double sampleRate, double centerFrequency, double widthFrequency, double rippleDb, int directFormType) {
        this.setupBandStop(order, sampleRate, centerFrequency, widthFrequency, rippleDb, directFormType);
    }

    private void setupBandPass(int order, double sampleRate, double centerFrequency, double widthFrequency, double rippleDb, int directFormType) {
        AnalogLowPass m_analogProto = new AnalogLowPass(order);
        m_analogProto.design(rippleDb);
        LayoutBase m_digitalProto = new LayoutBase(order * 2);
        new BandPassTransform(centerFrequency / sampleRate, widthFrequency / sampleRate, m_digitalProto, m_analogProto);
        this.setLayout(m_digitalProto, directFormType);
    }

    public void bandPass(int order, double sampleRate, double centerFrequency, double widthFrequency, double rippleDb) {
        this.setupBandPass(order, sampleRate, centerFrequency, widthFrequency, rippleDb, 1);
    }

    public void bandPass(int order, double sampleRate, double centerFrequency, double widthFrequency, double rippleDb, int directFormType) {
        this.setupBandPass(order, sampleRate, centerFrequency, widthFrequency, rippleDb, directFormType);
    }

    class AnalogLowPass
    extends LayoutBase {
        private int nPoles;

        public AnalogLowPass(int _nPoles) {
            super(_nPoles);
            this.nPoles = _nPoles;
        }

        public void design(double rippleDb) {
            this.reset();
            double eps = Math.sqrt(1.0 / Math.exp(-rippleDb * 0.1 * MathSupplement.doubleLn10) - 1.0);
            double v0 = MathSupplement.asinh(1.0 / eps) / (double)this.nPoles;
            double sinh_v0 = -Math.sinh(v0);
            double cosh_v0 = Math.cosh(v0);
            double n2 = 2 * this.nPoles;
            int pairs = this.nPoles / 2;
            for (int i = 0; i < pairs; ++i) {
                int k = 2 * i + 1 - this.nPoles;
                double a = sinh_v0 * Math.cos((double)k * Math.PI / n2);
                double b = cosh_v0 * Math.sin((double)k * Math.PI / n2);
                this.addPoleZeroConjugatePairs(new Complex(a, b), new Complex(Double.POSITIVE_INFINITY));
            }
            if ((this.nPoles & 1) == 1) {
                this.add(new Complex(sinh_v0, 0.0), new Complex(Double.POSITIVE_INFINITY));
                this.setNormal(0.0, 1.0);
            } else {
                this.setNormal(0.0, Math.pow(10.0, -rippleDb / 20.0));
            }
        }
    }
}

