/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj;

import fr.zeevoker2vex.radio.util.org.apache.commons.math3.complex.Complex;
import fr.zeevoker2vex.radio.util.org.apache.commons.math3.complex.ComplexUtils;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.Biquad;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.DirectFormAbstract;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.DirectFormI;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.DirectFormII;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.LayoutBase;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.MathSupplement;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.PoleZeroPair;

public class Cascade {
    private Biquad[] m_biquads = null;
    private DirectFormAbstract[] m_states = null;
    private int m_numBiquads = 0;
    private int numPoles;

    public int getNumBiquads() {
        return this.m_numBiquads;
    }

    public Biquad getBiquad(int index) {
        return this.m_biquads[index];
    }

    public void reset() {
        for (int i = 0; i < this.m_numBiquads; ++i) {
            this.m_states[i].reset();
        }
    }

    public double filter(double in) {
        double out = in;
        for (int i = 0; i < this.m_numBiquads; ++i) {
            if (this.m_states[i] == null) continue;
            out = this.m_states[i].process1(out, this.m_biquads[i]);
        }
        return out;
    }

    public Complex response(double normalizedFrequency) {
        double w = Math.PI * 2 * normalizedFrequency;
        Complex czn1 = ComplexUtils.polar2Complex(1.0, -w);
        Complex czn2 = ComplexUtils.polar2Complex(1.0, -2.0 * w);
        Complex ch = new Complex(1.0);
        Complex cbot = new Complex(1.0);
        for (int i = 0; i < this.m_numBiquads; ++i) {
            Biquad stage = this.m_biquads[i];
            Complex cb = new Complex(1.0);
            Complex ct = new Complex(stage.getB0() / stage.getA0());
            ct = MathSupplement.addmul(ct, stage.getB1() / stage.getA0(), czn1);
            ct = MathSupplement.addmul(ct, stage.getB2() / stage.getA0(), czn2);
            cb = MathSupplement.addmul(cb, stage.getA1() / stage.getA0(), czn1);
            cb = MathSupplement.addmul(cb, stage.getA2() / stage.getA0(), czn2);
            ch = ch.multiply(ct);
            cbot = cbot.multiply(cb);
        }
        return ch.divide(cbot);
    }

    public void applyScale(double scale) {
        if (this.m_biquads.length > 0) {
            this.m_biquads[0].applyScale(scale);
        }
    }

    public void setLayout(LayoutBase proto, int filterTypes) {
        int i;
        this.numPoles = proto.getNumPoles();
        this.m_numBiquads = (this.numPoles + 1) / 2;
        this.m_biquads = new Biquad[this.m_numBiquads];
        switch (filterTypes) {
            case 0: {
                this.m_states = new DirectFormI[this.m_numBiquads];
                for (i = 0; i < this.m_numBiquads; ++i) {
                    this.m_states[i] = new DirectFormI();
                }
                break;
            }
            default: {
                this.m_states = new DirectFormII[this.m_numBiquads];
                for (i = 0; i < this.m_numBiquads; ++i) {
                    this.m_states[i] = new DirectFormII();
                }
            }
        }
        for (i = 0; i < this.m_numBiquads; ++i) {
            PoleZeroPair p = proto.getPair(i);
            this.m_biquads[i] = new Biquad();
            this.m_biquads[i].setPoleZeroPair(p);
        }
        this.applyScale(proto.getNormalGain() / this.response(proto.getNormalW() / (Math.PI * 2)).abs());
    }
}

