/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj;

import fr.zeevoker2vex.radio.util.org.apache.commons.math3.complex.Complex;
import fr.zeevoker2vex.radio.util.org.apache.commons.math3.complex.ComplexUtils;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.BandPassTransform;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.BandStopTransform;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.Cascade;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.HighPassTransform;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.LayoutBase;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.LowPassTransform;

public class Butterworth
extends Cascade {
    private void setupLowPass(int order, double sampleRate, double cutoffFrequency, int directFormType) {
        AnalogLowPass m_analogProto = new AnalogLowPass(order);
        m_analogProto.design();
        LayoutBase m_digitalProto = new LayoutBase(order);
        new LowPassTransform(cutoffFrequency / sampleRate, m_digitalProto, m_analogProto);
        this.setLayout(m_digitalProto, directFormType);
    }

    public void lowPass(int order, double sampleRate, double cutoffFrequency) {
        this.setupLowPass(order, sampleRate, cutoffFrequency, 1);
    }

    public void lowPass(int order, double sampleRate, double cutoffFrequency, int directFormType) {
        this.setupLowPass(order, sampleRate, cutoffFrequency, directFormType);
    }

    private void setupHighPass(int order, double sampleRate, double cutoffFrequency, int directFormType) {
        AnalogLowPass m_analogProto = new AnalogLowPass(order);
        m_analogProto.design();
        LayoutBase m_digitalProto = new LayoutBase(order);
        new HighPassTransform(cutoffFrequency / sampleRate, m_digitalProto, m_analogProto);
        this.setLayout(m_digitalProto, directFormType);
    }

    public void highPass(int order, double sampleRate, double cutoffFrequency, int directFormType) {
        this.setupHighPass(order, sampleRate, cutoffFrequency, directFormType);
    }

    public void highPass(int order, double sampleRate, double cutoffFrequency) {
        this.setupHighPass(order, sampleRate, cutoffFrequency, 1);
    }

    private void setupBandStop(int order, double sampleRate, double centerFrequency, double widthFrequency, int directFormType) {
        AnalogLowPass m_analogProto = new AnalogLowPass(order);
        m_analogProto.design();
        LayoutBase m_digitalProto = new LayoutBase(order * 2);
        new BandStopTransform(centerFrequency / sampleRate, widthFrequency / sampleRate, m_digitalProto, m_analogProto);
        this.setLayout(m_digitalProto, directFormType);
    }

    public void bandStop(int order, double sampleRate, double centerFrequency, double widthFrequency) {
        this.setupBandStop(order, sampleRate, centerFrequency, widthFrequency, 1);
    }

    public void bandStop(int order, double sampleRate, double centerFrequency, double widthFrequency, int directFormType) {
        this.setupBandStop(order, sampleRate, centerFrequency, widthFrequency, directFormType);
    }

    private void setupBandPass(int order, double sampleRate, double centerFrequency, double widthFrequency, int directFormType) {
        AnalogLowPass m_analogProto = new AnalogLowPass(order);
        m_analogProto.design();
        LayoutBase m_digitalProto = new LayoutBase(order * 2);
        new BandPassTransform(centerFrequency / sampleRate, widthFrequency / sampleRate, m_digitalProto, m_analogProto);
        this.setLayout(m_digitalProto, directFormType);
    }

    public void bandPass(int order, double sampleRate, double centerFrequency, double widthFrequency) {
        this.setupBandPass(order, sampleRate, centerFrequency, widthFrequency, 1);
    }

    public void bandPass(int order, double sampleRate, double centerFrequency, double widthFrequency, int directFormType) {
        this.setupBandPass(order, sampleRate, centerFrequency, widthFrequency, directFormType);
    }

    class AnalogLowPass
    extends LayoutBase {
        private int nPoles;

        public AnalogLowPass(int _nPoles) {
            super(_nPoles);
            this.nPoles = _nPoles;
            this.setNormal(0.0, 1.0);
        }

        public void design() {
            this.reset();
            double n2 = 2 * this.nPoles;
            int pairs = this.nPoles / 2;
            for (int i = 0; i < pairs; ++i) {
                Complex c = ComplexUtils.polar2Complex(1.0, 1.5707963267948966 + (double)(2 * i + 1) * Math.PI / n2);
                this.addPoleZeroConjugatePairs(c, Complex.INF);
            }
            if ((this.nPoles & 1) == 1) {
                this.add(new Complex(-1.0), Complex.INF);
            }
        }
    }
}

