/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj;

import fr.zeevoker2vex.radio.util.org.apache.commons.math3.complex.Complex;
import fr.zeevoker2vex.radio.util.org.apache.commons.math3.complex.ComplexUtils;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.BiquadPoleState;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.MathSupplement;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.PoleZeroPair;

public class Biquad {
    double m_a0;
    double m_a1;
    double m_a2;
    double m_b1;
    double m_b2;
    double m_b0;

    public double getA0() {
        return this.m_a0;
    }

    public double getA1() {
        return this.m_a1 * this.m_a0;
    }

    public double getA2() {
        return this.m_a2 * this.m_a0;
    }

    public double getB0() {
        return this.m_b0 * this.m_a0;
    }

    public double getB1() {
        return this.m_b1 * this.m_a0;
    }

    public double getB2() {
        return this.m_b2 * this.m_a0;
    }

    public Complex response(double normalizedFrequency) {
        double a0 = this.getA0();
        double a1 = this.getA1();
        double a2 = this.getA2();
        double b0 = this.getB0();
        double b1 = this.getB1();
        double b2 = this.getB2();
        double w = Math.PI * 2 * normalizedFrequency;
        Complex czn1 = ComplexUtils.polar2Complex(1.0, -w);
        Complex czn2 = ComplexUtils.polar2Complex(1.0, -2.0 * w);
        Complex ch = new Complex(1.0);
        Complex cbot = new Complex(1.0);
        Complex ct = new Complex(b0 / a0);
        Complex cb = new Complex(1.0);
        ct = MathSupplement.addmul(ct, b1 / a0, czn1);
        ct = MathSupplement.addmul(ct, b2 / a0, czn2);
        cb = MathSupplement.addmul(cb, a1 / a0, czn1);
        cb = MathSupplement.addmul(cb, a2 / a0, czn2);
        ch = ch.multiply(ct);
        cbot = cbot.multiply(cb);
        return ch.divide(cbot);
    }

    public void setCoefficients(double a0, double a1, double a2, double b0, double b1, double b2) {
        this.m_a0 = a0;
        this.m_a1 = a1 / a0;
        this.m_a2 = a2 / a0;
        this.m_b0 = b0 / a0;
        this.m_b1 = b1 / a0;
        this.m_b2 = b2 / a0;
    }

    public void setOnePole(Complex pole, Complex zero) {
        double a0 = 1.0;
        double a1 = -pole.getReal();
        double a2 = 0.0;
        double b0 = -zero.getReal();
        double b1 = 1.0;
        double b2 = 0.0;
        this.setCoefficients(a0, a1, a2, b0, b1, b2);
    }

    public void setTwoPole(Complex pole1, Complex zero1, Complex pole2, Complex zero2) {
        double b2;
        double b1;
        double a2;
        double a1;
        double a0 = 1.0;
        if (pole1.getImaginary() != 0.0) {
            a1 = -2.0 * pole1.getReal();
            a2 = pole1.abs() * pole1.abs();
        } else {
            a1 = -(pole1.getReal() + pole2.getReal());
            a2 = pole1.getReal() * pole2.getReal();
        }
        double b0 = 1.0;
        if (zero1.getImaginary() != 0.0) {
            b1 = -2.0 * zero1.getReal();
            b2 = zero1.abs() * zero1.abs();
        } else {
            b1 = -(zero1.getReal() + zero2.getReal());
            b2 = zero1.getReal() * zero2.getReal();
        }
        this.setCoefficients(a0, a1, a2, b0, b1, b2);
    }

    public void setPoleZeroForm(BiquadPoleState bps) {
        this.setPoleZeroPair(bps);
        this.applyScale(bps.gain);
    }

    public void setIdentity() {
        this.setCoefficients(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }

    public void applyScale(double scale) {
        this.m_b0 *= scale;
        this.m_b1 *= scale;
        this.m_b2 *= scale;
    }

    public void setPoleZeroPair(PoleZeroPair pair) {
        if (pair.isSinglePole()) {
            this.setOnePole(pair.poles.first, pair.zeros.first);
        } else {
            this.setTwoPole(pair.poles.first, pair.zeros.first, pair.poles.second, pair.zeros.second);
        }
    }
}

