/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj;

import fr.zeevoker2vex.radio.util.org.apache.commons.math3.analysis.solvers.LaguerreSolver;
import fr.zeevoker2vex.radio.util.org.apache.commons.math3.complex.Complex;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.BandPassTransform;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.BandStopTransform;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.Cascade;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.HighPassTransform;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.LayoutBase;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.LowPassTransform;

public class Bessel
extends Cascade {
    private double fact(int n) {
        if (n == 0) {
            return 1.0;
        }
        double y = n;
        for (double m = (double)(n - 1); m > 0.0; m -= 1.0) {
            y *= m;
        }
        return y;
    }

    private void setupLowPass(int order, double sampleRate, double cutoffFrequency, int directFormType) {
        AnalogLowPass m_analogProto = new AnalogLowPass(order);
        m_analogProto.design();
        LayoutBase m_digitalProto = new LayoutBase(order);
        new LowPassTransform(cutoffFrequency / sampleRate, m_digitalProto, m_analogProto);
        this.setLayout(m_digitalProto, directFormType);
    }

    public void lowPass(int order, double sampleRate, double cutoffFrequency) {
        this.setupLowPass(order, sampleRate, cutoffFrequency, 1);
    }

    public void lowPass(int order, double sampleRate, double cutoffFrequency, int directFormType) {
        this.setupLowPass(order, sampleRate, cutoffFrequency, directFormType);
    }

    private void setupHighPass(int order, double sampleRate, double cutoffFrequency, int directFormType) {
        AnalogLowPass m_analogProto = new AnalogLowPass(order);
        m_analogProto.design();
        LayoutBase m_digitalProto = new LayoutBase(order);
        new HighPassTransform(cutoffFrequency / sampleRate, m_digitalProto, m_analogProto);
        this.setLayout(m_digitalProto, directFormType);
    }

    public void highPass(int order, double sampleRate, double cutoffFrequency, int directFormType) {
        this.setupHighPass(order, sampleRate, cutoffFrequency, directFormType);
    }

    public void highPass(int order, double sampleRate, double cutoffFrequency) {
        this.setupHighPass(order, sampleRate, cutoffFrequency, 1);
    }

    private void setupBandStop(int order, double sampleRate, double centerFrequency, double widthFrequency, int directFormType) {
        AnalogLowPass m_analogProto = new AnalogLowPass(order);
        m_analogProto.design();
        LayoutBase m_digitalProto = new LayoutBase(order * 2);
        new BandStopTransform(centerFrequency / sampleRate, widthFrequency / sampleRate, m_digitalProto, m_analogProto);
        this.setLayout(m_digitalProto, directFormType);
    }

    public void bandStop(int order, double sampleRate, double centerFrequency, double widthFrequency) {
        this.setupBandStop(order, sampleRate, centerFrequency, widthFrequency, 1);
    }

    public void bandStop(int order, double sampleRate, double centerFrequency, double widthFrequency, int directFormType) {
        this.setupBandStop(order, sampleRate, centerFrequency, widthFrequency, directFormType);
    }

    private void setupBandPass(int order, double sampleRate, double centerFrequency, double widthFrequency, int directFormType) {
        AnalogLowPass m_analogProto = new AnalogLowPass(order);
        m_analogProto.design();
        LayoutBase m_digitalProto = new LayoutBase(order * 2);
        new BandPassTransform(centerFrequency / sampleRate, widthFrequency / sampleRate, m_digitalProto, m_analogProto);
        this.setLayout(m_digitalProto, directFormType);
    }

    public void bandPass(int order, double sampleRate, double centerFrequency, double widthFrequency) {
        this.setupBandPass(order, sampleRate, centerFrequency, widthFrequency, 1);
    }

    public void bandPass(int order, double sampleRate, double centerFrequency, double widthFrequency, int directFormType) {
        this.setupBandPass(order, sampleRate, centerFrequency, widthFrequency, directFormType);
    }

    class AnalogLowPass
    extends LayoutBase {
        int degree;
        double[] m_a;
        Complex[] m_root;

        private double reversebessel(int k, int n) {
            double result = Bessel.this.fact(2 * n - k) / (Bessel.this.fact(n - k) * Bessel.this.fact(k) * Math.pow(2.0, n - k));
            return result;
        }

        public AnalogLowPass(int _degree) {
            super(_degree);
            this.degree = _degree;
            this.m_a = new double[this.degree + 1];
            this.m_root = new Complex[this.degree];
            this.setNormal(0.0, 1.0);
        }

        public void design() {
            this.reset();
            for (int i = 0; i < this.degree + 1; ++i) {
                this.m_a[i] = this.reversebessel(i, this.degree);
            }
            LaguerreSolver laguerreSolver = new LaguerreSolver();
            this.m_root = laguerreSolver.solveAllComplex(this.m_a, 0.0);
            Complex inf = Complex.INF;
            int pairs = this.degree / 2;
            for (int i = 0; i < pairs; ++i) {
                Complex c = this.m_root[i];
                this.addPoleZeroConjugatePairs(c, inf);
            }
            if ((this.degree & 1) == 1) {
                this.add(new Complex(this.m_root[pairs].getReal()), inf);
            }
        }
    }
}

