/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj;

import fr.zeevoker2vex.radio.util.org.apache.commons.math3.complex.Complex;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.ComplexPair;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.LayoutBase;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.MathSupplement;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.PoleZeroPair;

public class BandStopTransform {
    private double wc;
    private double wc2;
    private double a;
    private double b;
    private double a2;
    private double b2;

    public BandStopTransform(double fc, double fw, LayoutBase digital, LayoutBase analog) {
        digital.reset();
        if (fc < 0.0) {
            throw new ArithmeticException("Cutoff frequency cannot be negative.");
        }
        if (!(fc < 0.5)) {
            throw new ArithmeticException("Cutoff frequency must be less than the Nyquist frequency.");
        }
        double ww = Math.PI * 2 * fw;
        this.wc2 = Math.PI * 2 * fc - ww / 2.0;
        this.wc = this.wc2 + ww;
        if (this.wc2 < 1.0E-8) {
            this.wc2 = 1.0E-8;
        }
        if (this.wc > 3.141592643589793) {
            this.wc = 3.141592643589793;
        }
        this.a = Math.cos((this.wc + this.wc2) * 0.5) / Math.cos((this.wc - this.wc2) * 0.5);
        this.b = Math.tan((this.wc - this.wc2) * 0.5);
        this.a2 = this.a * this.a;
        this.b2 = this.b * this.b;
        int numPoles = analog.getNumPoles();
        int pairs = numPoles / 2;
        for (int i = 0; i < pairs; ++i) {
            PoleZeroPair pair = analog.getPair(i);
            ComplexPair p = this.transform(pair.poles.first);
            ComplexPair z = this.transform(pair.zeros.first);
            digital.addPoleZeroConjugatePairs(p.first, z.first);
            digital.addPoleZeroConjugatePairs(p.second, z.second);
        }
        if ((numPoles & 1) == 1) {
            ComplexPair poles = this.transform(analog.getPair((int)pairs).poles.first);
            ComplexPair zeros = this.transform(analog.getPair((int)pairs).zeros.first);
            digital.add(poles, zeros);
        }
        if (fc < 0.25) {
            digital.setNormal(Math.PI, analog.getNormalGain());
        } else {
            digital.setNormal(0.0, analog.getNormalGain());
        }
    }

    private ComplexPair transform(Complex c) {
        c = c.isInfinite() ? new Complex(-1.0) : new Complex(1.0).add(c).divide(new Complex(1.0).subtract(c));
        Complex u = new Complex(0.0);
        u = MathSupplement.addmul(u, 4.0 * (this.b2 + this.a2 - 1.0), c);
        u = u.add(8.0 * (this.b2 - this.a2 + 1.0));
        u = u.multiply(c);
        u = u.add(4.0 * (this.a2 + this.b2 - 1.0));
        u = u.sqrt();
        Complex v = u.multiply(-0.5);
        v = v.add(this.a);
        v = MathSupplement.addmul(v, -this.a, c);
        u = u.multiply(0.5);
        u = u.add(this.a);
        u = MathSupplement.addmul(u, -this.a, c);
        Complex d = new Complex(this.b + 1.0);
        d = MathSupplement.addmul(d, this.b - 1.0, c);
        return new ComplexPair(u.divide(d), v.divide(d));
    }
}

