/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.radio.util.org.apache.commons.math3.optim.linear;

import fr.zeevoker2vex.radio.util.org.apache.commons.math3.exception.TooManyIterationsException;
import fr.zeevoker2vex.radio.util.org.apache.commons.math3.optim.ConvergenceChecker;
import fr.zeevoker2vex.radio.util.org.apache.commons.math3.optim.OptimizationData;
import fr.zeevoker2vex.radio.util.org.apache.commons.math3.optim.PointValuePair;
import fr.zeevoker2vex.radio.util.org.apache.commons.math3.optim.linear.LinearConstraint;
import fr.zeevoker2vex.radio.util.org.apache.commons.math3.optim.linear.LinearConstraintSet;
import fr.zeevoker2vex.radio.util.org.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import fr.zeevoker2vex.radio.util.org.apache.commons.math3.optim.linear.NonNegativeConstraint;
import fr.zeevoker2vex.radio.util.org.apache.commons.math3.optim.nonlinear.scalar.MultivariateOptimizer;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LinearOptimizer
extends MultivariateOptimizer {
    private LinearObjectiveFunction function;
    private Collection<LinearConstraint> linearConstraints;
    private boolean nonNegative;

    protected LinearOptimizer() {
        super((ConvergenceChecker<PointValuePair>)null);
    }

    protected boolean isRestrictedToNonNegative() {
        return this.nonNegative;
    }

    protected LinearObjectiveFunction getFunction() {
        return this.function;
    }

    protected Collection<LinearConstraint> getConstraints() {
        return Collections.unmodifiableCollection(this.linearConstraints);
    }

    @Override
    public PointValuePair optimize(OptimizationData ... optData) throws TooManyIterationsException {
        return super.optimize(optData);
    }

    @Override
    protected void parseOptimizationData(OptimizationData ... optData) {
        super.parseOptimizationData(optData);
        for (OptimizationData data : optData) {
            if (data instanceof LinearObjectiveFunction) {
                this.function = (LinearObjectiveFunction)data;
                continue;
            }
            if (data instanceof LinearConstraintSet) {
                this.linearConstraints = ((LinearConstraintSet)data).getConstraints();
                continue;
            }
            if (!(data instanceof NonNegativeConstraint)) continue;
            this.nonNegative = ((NonNegativeConstraint)data).isRestrictedToNonNegative();
        }
    }
}

