/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.radio.util.org.apache.commons.io.input;

import fr.zeevoker2vex.radio.util.org.apache.commons.io.output.QueueOutputStream;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class QueueInputStream
extends InputStream {
    private final BlockingQueue<Integer> blockingQueue;

    public QueueInputStream() {
        this(new LinkedBlockingQueue<Integer>());
    }

    public QueueInputStream(BlockingQueue<Integer> blockingQueue) {
        this.blockingQueue = Objects.requireNonNull(blockingQueue, "blockingQueue");
    }

    public QueueOutputStream newQueueOutputStream() {
        return new QueueOutputStream(this.blockingQueue);
    }

    @Override
    public int read() {
        Integer value = (Integer)this.blockingQueue.poll();
        return value == null ? -1 : 0xFF & value;
    }
}

