/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.radio.server.radio;

import fr.zeevoker2vex.radio.common.items.RadioItem;
import fr.zeevoker2vex.radio.common.network.NetworkHandler;
import fr.zeevoker2vex.radio.common.network.client.PlayRadioSoundPacket;
import fr.zeevoker2vex.radio.server.config.AddonConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.SERVER)
public class RadioManager {
    public static HashMap<EntityPlayer, HashMap<UUID, Short>> playersFrequencies = new HashMap();
    public static HashMap<EntityPlayer, Short> playersSpeaking = new HashMap();

    public static boolean isConnectOnAnyFrequency(EntityPlayer player) {
        return playersFrequencies.containsKey(player);
    }

    public static boolean isConnectOnFrequency(EntityPlayer player, short frequency) {
        return RadioManager.isConnectOnAnyFrequency(player) && RadioManager.getFrequencies(player).contains(frequency);
    }

    public static ArrayList<Short> getFrequencies(EntityPlayer player) {
        return new ArrayList<Short>(RadioManager.getFrequenciesWithUUID(player).values());
    }

    public static HashMap<UUID, Short> getFrequenciesWithUUID(EntityPlayer player) {
        return playersFrequencies.getOrDefault(player, new HashMap());
    }

    public static void disconnectPlayerFromFrequency(EntityPlayer player, UUID radioUUID) {
        HashMap<UUID, Short> currentFrequencies = RadioManager.getFrequenciesWithUUID(player);
        if (currentFrequencies.isEmpty() || !currentFrequencies.containsKey(radioUUID)) {
            return;
        }
        currentFrequencies.remove(radioUUID);
        playersFrequencies.put(player, currentFrequencies);
    }

    public static void disconnectPlayerFromAll(EntityPlayer player) {
        playersFrequencies.remove(player);
    }

    public static void connectToFrequency(EntityPlayer player, short frequency, UUID radioUUID) {
        if (frequency >= 1 && frequency <= 1000) {
            HashMap<UUID, Short> currentFrequencies = RadioManager.getFrequenciesWithUUID(player);
            if (!AddonConfig.generalConfig.canHearAllRadios) {
                currentFrequencies.clear();
                RadioItem.turnOffAllRadios(player);
                RadioItem.setRadioState(player.func_184614_ca(), true);
            }
            currentFrequencies.put(radioUUID, frequency);
            playersFrequencies.put(player, currentFrequencies);
        }
    }

    public static List<EntityPlayer> getPlayersConnectedOnFrequency(short frequency) {
        return playersFrequencies.entrySet().stream().filter(entry -> ((HashMap)entry.getValue()).containsValue(frequency)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static UUID getPlayerRadioUUIDFromFrequency(EntityPlayer player, short frequency) {
        Optional<UUID> uuid = RadioManager.getFrequenciesWithUUID(player).entrySet().stream().filter(entry -> (Short)entry.getValue() == frequency).map(Map.Entry::getKey).findFirst();
        return uuid.orElse(null);
    }

    public static void updatePlayerSpeaking(EntityPlayer player, boolean speaking, short frequency) {
        if (speaking && !RadioManager.isSpeakingOn(player) && RadioManager.isConnectOnFrequency(player, frequency) || !speaking && RadioManager.isSpeakingOn(player)) {
            short usedFrequency = !speaking ? RadioManager.getFrequencySpeaking(player) : frequency;
            RadioManager.playRadioSoundToFrequency(speaking, usedFrequency);
            if (speaking) {
                playersSpeaking.put(player, frequency);
            } else {
                playersSpeaking.remove(player);
            }
        }
    }

    public static boolean isSpeakingOn(EntityPlayer player) {
        return playersSpeaking.containsKey(player);
    }

    public static short getFrequencySpeaking(EntityPlayer player) {
        return playersSpeaking.getOrDefault(player, (short)0);
    }

    public static void playRadioSoundToFrequency(boolean speaking, short frequency) {
        RadioManager.getPlayersConnectedOnFrequency(frequency).forEach(playerEntity -> NetworkHandler.getInstance().getNetwork().sendTo((IMessage)new PlayRadioSoundPacket(speaking), (EntityPlayerMP)playerEntity));
    }
}

