/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.radio.server.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import fr.nathanael2611.modularvoicechat.util.Helpers;
import fr.zeevoker2vex.radio.common.utils.LogUtils;
import fr.zeevoker2vex.radio.server.config.AddonConfig;
import fr.zeevoker2vex.radio.util.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.SERVER)
public class FrequenciesConfig {
    private final List<Short> blacklistedFrequencies = new ArrayList<Short>();
    private final HashMap<Short, List<String[]>> restrictedFrequencies = new HashMap();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final File configFile;

    public FrequenciesConfig(File configFile) {
        this.configFile = configFile;
        if (!configFile.exists() || configFile.length() == 0L) {
            this.writeDefaultFile();
        } else {
            this.readConfigFile();
        }
    }

    public void writeDefaultFile() {
        try {
            LogUtils.basicLog("Config file doesn't exist, trying to create it..");
            this.configFile.createNewFile();
            JsonObject configJson = new JsonObject();
            configJson.add("blacklisted", (JsonElement)new JsonArray());
            configJson.add("restricted", (JsonElement)new JsonObject());
            if (this.writeJson(configJson)) {
                LogUtils.successLog("The default config file has been created and written!");
            } else {
                LogUtils.errorLog("An error occurred on writing default json in config file !");
            }
        }
        catch (IOException e) {
            LogUtils.errorLog("An error occurred on trying to create config file.");
            e.printStackTrace();
        }
    }

    public void readConfigFile() {
        LogUtils.basicLog("Starting to read config file..");
        if (!this.checkConfig()) {
            return;
        }
        JsonObject configJson = this.getConfigAsJsonObject();
        JsonArray blacklisted = configJson.getAsJsonArray("blacklisted");
        for (JsonElement jsonElement : blacklisted) {
            this.blacklistedFrequencies.add(jsonElement.getAsShort());
        }
        LogUtils.basicLog("End of reading all blacklisted frequencies : " + this.getBlacklistedFrequencies());
        JsonObject restricted = configJson.getAsJsonObject("restricted");
        for (Map.Entry entry : restricted.entrySet()) {
            String KEY = (String)entry.getKey();
            LogUtils.basicLog("Reading " + KEY + " as restricted frequencies");
            JsonArray whitelistedPlayers = ((JsonElement)entry.getValue()).getAsJsonArray();
            ArrayList<String[]> players = new ArrayList<String[]>();
            for (JsonElement playerElement : whitelistedPlayers) {
                JsonObject playerObject = playerElement.getAsJsonObject();
                String uuid = playerObject.get("uuid").getAsString();
                String name = playerObject.get("name").getAsString();
                String[] playerInfo = new String[]{uuid, name};
                players.add(playerInfo);
            }
            this.restrictedFrequencies.put(Short.parseShort(KEY), players);
        }
        LogUtils.basicLog("End of reading all restricted frequencies.");
        LogUtils.successLog("The config file has been successfully read !");
    }

    public boolean writeJson(JsonObject jsonObject) {
        try {
            FileUtils.writeStringToFile(this.getConfigFile(), GSON.toJson((JsonElement)jsonObject), Charset.defaultCharset(), false);
            return true;
        }
        catch (IOException e) {
            LogUtils.errorLog("An error occurred on writing json in config file!");
            e.printStackTrace();
            return false;
        }
    }

    private boolean isConfigValid() {
        return this.getConfigFile().exists() && this.getConfigFile().length() > 0L && this.getConfigAsJsonObject() != null;
    }

    private JsonObject getConfigAsJsonObject() {
        try {
            return new JsonParser().parse(Helpers.readFileToString((File)this.getConfigFile())).getAsJsonObject();
        }
        catch (JsonParseException exception) {
            return null;
        }
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public boolean checkConfig() {
        if (!this.isConfigValid()) {
            LogUtils.errorLog("Error when checking config, it appears that config isn't valid (not json syntax, empty file, or don't exist)\nTrying to delete & recreate default file.");
            this.configFile.delete();
            this.writeDefaultFile();
            return false;
        }
        return true;
    }

    public List<Short> getBlacklistedFrequencies() {
        return this.blacklistedFrequencies;
    }

    public boolean isBlacklisted(short frequency) {
        return this.getBlacklistedFrequencies().contains(frequency);
    }

    public HashMap<Short, List<String[]>> getRestrictedFrequencies() {
        return this.restrictedFrequencies;
    }

    public boolean isRestricted(short frequency) {
        return this.getRestrictedFrequencies().containsKey(frequency);
    }

    public byte canPlayerConnect(EntityPlayer player, short frequency) {
        boolean bypass;
        boolean isOp = Arrays.stream(FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152606_n()).anyMatch(name -> name.equals(player.func_70005_c_()));
        boolean bl = bypass = isOp && AddonConfig.generalConfig.opBypassRestrictions;
        if (bypass) {
            return 0;
        }
        if (this.isBlacklisted(frequency)) {
            return 1;
        }
        if (this.isRestricted(frequency)) {
            if (this.isWhitelisted(player, frequency)) {
                return 0;
            }
            return 2;
        }
        return 0;
    }

    public List<String[]> getPlayers(short frequency) {
        return this.getRestrictedFrequencies().getOrDefault(frequency, new ArrayList());
    }

    public List<String> getPlayerNames(short frequency) {
        return this.getPlayers(frequency).stream().map(info -> info[1]).collect(Collectors.toList());
    }

    public boolean isWhitelisted(EntityPlayer player, short frequency) {
        String playerUUID = player.func_110124_au().toString();
        String playerName = player.func_70005_c_();
        List<String[]> players = this.getPlayers(frequency);
        for (String[] playerInfo : players) {
            String uuid = playerInfo[0];
            String name = playerInfo[1];
            if (!playerUUID.equals(uuid) && !playerName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean addToBlacklist(short frequency) {
        if (!this.checkConfig()) {
            return false;
        }
        JsonObject configJson = this.getConfigAsJsonObject();
        JsonArray blacklisted = configJson.getAsJsonArray("blacklisted");
        blacklisted.add((Number)frequency);
        configJson.add("blacklisted", (JsonElement)blacklisted);
        if (this.writeJson(configJson)) {
            this.blacklistedFrequencies.add(frequency);
            return true;
        }
        LogUtils.errorLog("An error occurred on adding a frequency to blacklist!");
        return false;
    }

    public boolean removeFromBlacklist(short frequency) {
        if (!this.checkConfig()) {
            return false;
        }
        JsonObject configJson = this.getConfigAsJsonObject();
        JsonArray blacklisted = configJson.getAsJsonArray("blacklisted");
        blacklisted.remove((JsonElement)new JsonPrimitive((Number)frequency));
        configJson.add("blacklisted", (JsonElement)blacklisted);
        if (this.writeJson(configJson)) {
            this.blacklistedFrequencies.removeIf(freq -> freq == frequency);
            return true;
        }
        LogUtils.errorLog("An error occurred on removing a frequency from blacklist!");
        return false;
    }

    public boolean addToRestricted(short frequency) {
        if (!this.checkConfig()) {
            return false;
        }
        JsonObject configJson = this.getConfigAsJsonObject();
        JsonObject restricted = configJson.getAsJsonObject("restricted");
        restricted.add(String.valueOf(frequency), (JsonElement)new JsonArray());
        configJson.add("restricted", (JsonElement)restricted);
        if (this.writeJson(configJson)) {
            this.restrictedFrequencies.put(frequency, new ArrayList());
            return true;
        }
        LogUtils.errorLog("An error occurred on adding a frequency to restricted!");
        return false;
    }

    public boolean removeFromRestricted(short frequency) {
        if (!this.checkConfig()) {
            return false;
        }
        JsonObject configJson = this.getConfigAsJsonObject();
        JsonObject restricted = configJson.getAsJsonObject("restricted");
        restricted.remove(String.valueOf(frequency));
        configJson.add("restricted", (JsonElement)restricted);
        if (this.writeJson(configJson)) {
            this.restrictedFrequencies.remove(frequency);
            return true;
        }
        LogUtils.errorLog("An error occurred on removing a frequency from restricted!");
        return false;
    }

    public boolean addToRestricted(short frequency, String uuid, String name) {
        if (!this.checkConfig()) {
            return false;
        }
        JsonObject configJson = this.getConfigAsJsonObject();
        JsonObject restricted = configJson.getAsJsonObject("restricted");
        JsonArray freqArray = restricted.getAsJsonArray(String.valueOf(frequency));
        JsonObject playerObject = new JsonObject();
        playerObject.add("uuid", (JsonElement)new JsonPrimitive(uuid));
        playerObject.add("name", (JsonElement)new JsonPrimitive(name));
        freqArray.add((JsonElement)playerObject);
        restricted.add(String.valueOf(frequency), (JsonElement)freqArray);
        configJson.add("restricted", (JsonElement)restricted);
        if (this.writeJson(configJson)) {
            List<String[]> players = this.getPlayers(frequency);
            players.add(new String[]{uuid, name});
            this.restrictedFrequencies.put(frequency, players);
            return true;
        }
        LogUtils.errorLog("An error occurred on adding a frequency to restricted!");
        return false;
    }

    public boolean removeFromRestricted(short frequency, String uuid, String name) {
        int i;
        if (!this.checkConfig()) {
            return false;
        }
        JsonObject configJson = this.getConfigAsJsonObject();
        JsonObject restricted = configJson.getAsJsonObject("restricted");
        JsonArray freqArray = restricted.getAsJsonArray(String.valueOf(frequency));
        for (i = 0; i < freqArray.size(); ++i) {
            JsonObject playerInfo = freqArray.get(i).getAsJsonObject();
            String uuidInfo = playerInfo.get("uuid").getAsString();
            String nameInfo = playerInfo.get("name").getAsString();
            if (uuidInfo.equals(uuid) || nameInfo.equals(name)) break;
        }
        freqArray.remove(i);
        restricted.add(String.valueOf(frequency), (JsonElement)freqArray);
        configJson.add("restricted", (JsonElement)restricted);
        if (this.writeJson(configJson)) {
            List<String[]> players = this.getPlayers(frequency);
            players.removeIf(info -> info[0].equals(uuid) || info[1].equals(name));
            this.restrictedFrequencies.put(frequency, players);
            return true;
        }
        LogUtils.errorLog("An error occurred on adding a frequency to restricted!");
        return false;
    }
}

