/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.radio.server.commands;

import fr.zeevoker2vex.radio.common.utils.CommandHelpBuilder;
import fr.zeevoker2vex.radio.common.utils.MessageBuilder;
import fr.zeevoker2vex.radio.server.ServerProxy;
import fr.zeevoker2vex.radio.server.radio.RadioManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class FrequenciesCommand
extends CommandBase {
    private final HashMap<String, Integer> commandArguments = new HashMap();
    private final List<String> frequenciesArguments = new ArrayList<String>();

    public FrequenciesCommand() {
        this.commandArguments.put("view", 0);
        this.commandArguments.put("blacklisted", 3);
        this.commandArguments.put("restricted", 7);
        this.commandArguments.put("help", 0);
        this.frequenciesArguments.add("add");
        this.frequenciesArguments.add("remove");
        this.frequenciesArguments.add("view");
    }

    public String func_71517_b() {
        return "frequencies";
    }

    public String func_71518_a(ICommandSender sender) {
        return "\u00a7cUsage: /frequencies <view/blacklisted/restricted/help> [add/remove/view] [frequency] [player]\n\u00a7cSee /frequencies help for details.";
    }

    /*
     * WARNING - void declaration
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        MessageBuilder.ComponentMessage message = new MessageBuilder.ComponentMessage("");
        if (args.length == 1) {
            if (args[0].equals("view")) {
                HashMap<Short, List> frequencies = new HashMap<Short, List>();
                for (Map.Entry<EntityPlayer, HashMap<UUID, Short>> entry : RadioManager.playersFrequencies.entrySet()) {
                    for (short frequency : entry.getValue().values()) {
                        List players = frequencies.getOrDefault(frequency, new ArrayList());
                        players.add(entry.getKey().func_70005_c_());
                        frequencies.put(frequency, players);
                    }
                }
                if (!frequencies.isEmpty()) {
                    message = message.reset("\u00a7e").addTranslation("cmd.frequencies.view.title", new Object[0]);
                    for (Map.Entry<Object, HashMap<UUID, Short>> entry : frequencies.entrySet()) {
                        short frequency = (Short)entry.getKey();
                        message = message.addLine("\u00a76=> " + frequency + " Mhz");
                        if (ServerProxy.getConfig().isRestricted(frequency)) {
                            message = message.addString("\u00a7c").addTranslation("cmd.frequencies.view.restricted", new Object[0]);
                        } else if (ServerProxy.getConfig().isBlacklisted(frequency)) {
                            message = message.addString("\u00a7c").addTranslation("cmd.frequencies.view.blacklisted", new Object[0]);
                        }
                        message = message.addString(" \u00a7f:");
                        List playerNames = (List)((Object)entry.getValue());
                        int listSize = playerNames.size();
                        for (int i = 0; i < listSize; ++i) {
                            String playerName = (String)playerNames.get(i);
                            String suffix = i + 1 == listSize ? "\u00a7f." : "\u00a7f,";
                            message = message.addString(" \u00a77" + playerName + suffix);
                        }
                    }
                } else {
                    message = message.reset("\u00a7e").addTranslation("cmd.frequencies.view.none", new Object[0]);
                }
                message.sendTo(sender);
                return;
            }
            if (args[0].equals("help")) {
                CommandHelpBuilder commandHelpBuilder = new CommandHelpBuilder(this.func_71517_b(), new ArrayList<String>(this.commandArguments.keySet()));
                commandHelpBuilder.build().sendTo(sender);
                return;
            }
        } else if (args.length == 2) {
            if (args[0].equals("help")) {
                String detailedArg = args[1];
                if (this.commandArguments.containsKey(detailedArg)) {
                    CommandHelpBuilder.ArgumentBuilder argumentBuilder = new CommandHelpBuilder.ArgumentBuilder(this.func_71517_b(), detailedArg, this.commandArguments.get(detailedArg));
                    argumentBuilder.build().sendTo(sender);
                } else {
                    message.reset("\u00a7c").addTranslation("cmd.frequencies.help.details.failed", detailedArg, this.func_71517_b()).sendTo(sender);
                }
                return;
            }
            if (args[0].equals("blacklisted")) {
                if (args[1].equals("view")) {
                    List<Short> blacklistedFrequencies = ServerProxy.getConfig().getBlacklistedFrequencies();
                    if (!blacklistedFrequencies.isEmpty()) {
                        void var7_24;
                        message = message.reset("\u00a7e").addTranslation("cmd.frequencies.blacklisted.view.title", new Object[0]);
                        int listSize = blacklistedFrequencies.size();
                        boolean bl = false;
                        while (var7_24 < listSize) {
                            short blacklistedFrequency = blacklistedFrequencies.get((int)var7_24);
                            String suffix = var7_24 + true == listSize ? "\u00a7f." : "\u00a7f,";
                            message = message.addString(" \u00a76" + blacklistedFrequency + suffix);
                            ++var7_24;
                        }
                    } else {
                        message = message.reset("\u00a7e").addTranslation("cmd.frequencies.blacklisted.view.none", new Object[0]);
                    }
                    message.sendTo(sender);
                    return;
                }
            } else if (args[0].equals("restricted") && args[1].equals("view")) {
                ArrayList<Short> restrictedFrequencies = new ArrayList<Short>(ServerProxy.getConfig().getRestrictedFrequencies().keySet());
                if (!restrictedFrequencies.isEmpty()) {
                    void var7_26;
                    message = message.reset("\u00a7e").addTranslation("cmd.frequencies.restricted.view.title", new Object[0]);
                    int listSize = restrictedFrequencies.size();
                    boolean bl = false;
                    while (var7_26 < listSize) {
                        short blacklistedFrequency = (Short)restrictedFrequencies.get((int)var7_26);
                        String suffix = var7_26 + true == listSize ? "\u00a7f." : "\u00a7f,";
                        message = message.addString(" \u00a76" + blacklistedFrequency + suffix);
                        ++var7_26;
                    }
                } else {
                    message = message.reset("\u00a7e").addTranslation("cmd.frequencies.restricted.view.none", new Object[0]);
                }
                message.sendTo(sender);
                return;
            }
        } else if (args.length == 3) {
            short frequency;
            try {
                frequency = Short.parseShort(args[2]);
            }
            catch (NumberFormatException exception) {
                message.reset("\u00a7c").addTranslation("cmd.frequencies.invalidFrequency", new Object[0]);
                message.sendTo(sender);
                return;
            }
            if (args[0].equals("blacklisted")) {
                if (args[1].equals("add")) {
                    if (ServerProxy.getConfig().isBlacklisted(frequency)) {
                        message.reset("\u00a7c").addTranslation("cmd.frequencies.blacklisted.add.already", new Object[0]);
                    } else if (ServerProxy.getConfig().isRestricted(frequency)) {
                        message.reset("\u00a7c").addTranslation("cmd.frequencies.blacklisted.add.restricted", new Object[0]);
                    } else if (ServerProxy.getConfig().addToBlacklist(frequency)) {
                        message.reset("\u00a72").addTranslation("cmd.frequencies.blacklisted.add.success", frequency);
                    } else {
                        message.reset("\u00a7c").addTranslation("cmd.frequencies.blacklisted.add.failed", frequency);
                    }
                    message.sendTo(sender);
                    return;
                }
                if (args[1].equals("remove")) {
                    if (!ServerProxy.getConfig().isBlacklisted(frequency)) {
                        message.reset("\u00a7c").addTranslation("cmd.frequencies.blacklisted.remove.none", new Object[0]);
                    } else if (ServerProxy.getConfig().removeFromBlacklist(frequency)) {
                        message.reset("\u00a72").addTranslation("cmd.frequencies.blacklisted.remove.success", frequency);
                    } else {
                        message.reset("\u00a7c").addTranslation("cmd.frequencies.blacklisted.remove.failed", frequency);
                    }
                    message.sendTo(sender);
                    return;
                }
            } else if (args[0].equals("restricted")) {
                if (args[1].equals("add")) {
                    if (ServerProxy.getConfig().isRestricted(frequency)) {
                        message.reset("\u00a7c").addTranslation("cmd.frequencies.restricted.add.already", new Object[0]);
                    } else if (ServerProxy.getConfig().isBlacklisted(frequency)) {
                        message.reset("\u00a7c").addTranslation("cmd.frequencies.restricted.add.blacklisted", new Object[0]);
                    } else if (ServerProxy.getConfig().addToRestricted(frequency)) {
                        message.reset("\u00a72").addTranslation("cmd.frequencies.restricted.add.success", frequency);
                    } else {
                        message.reset("\u00a7c").addTranslation("cmd.frequencies.restricted.add.failed", frequency);
                    }
                    message.sendTo(sender);
                    return;
                }
                if (args[1].equals("remove")) {
                    if (!ServerProxy.getConfig().isRestricted(frequency)) {
                        message.reset("\u00a7c").addTranslation("cmd.frequencies.restricted.none", new Object[0]);
                    } else if (ServerProxy.getConfig().removeFromRestricted(frequency)) {
                        message.reset("\u00a72").addTranslation("cmd.frequencies.restricted.remove.success", frequency);
                    } else {
                        message.reset("\u00a7c").addTranslation("cmd.frequencies.restricted.remove.failed", frequency);
                    }
                    message.sendTo(sender);
                    return;
                }
                if (args[1].equals("view")) {
                    if (!ServerProxy.getConfig().isRestricted(frequency)) {
                        message.reset("\u00a7c").addTranslation("cmd.frequencies.restricted.none", new Object[0]);
                    } else {
                        List<String> playersName = ServerProxy.getConfig().getPlayerNames(frequency);
                        if (!playersName.isEmpty()) {
                            message = message.reset("\u00a7e").addTranslation("cmd.frequencies.restricted.view.freq.title", frequency);
                            int n = playersName.size();
                            for (int i = 0; i < n; ++i) {
                                String playerName = playersName.get(i);
                                String suffix = i + 1 == n ? "\u00a7f." : "\u00a7f,";
                                message = message.addString(" \u00a77" + playerName + suffix);
                            }
                        } else {
                            message = message.reset("\u00a7e").addTranslation("cmd.frequencies.restricted.view.freq.none", new Object[0]);
                        }
                    }
                    message.sendTo(sender);
                    return;
                }
            }
        } else if (args.length == 4) {
            short frequency;
            try {
                frequency = Short.parseShort(args[2]);
            }
            catch (NumberFormatException exception) {
                message.reset("\u00a7c").addTranslation("cmd.frequencies.invalidFrequency", new Object[0]);
                message.sendTo(sender);
                return;
            }
            if (!ServerProxy.getConfig().isRestricted(frequency)) {
                message.reset("\u00a7c").addTranslation("cmd.frequencies.restricted.none", new Object[0]);
                message.sendTo(sender);
                return;
            }
            EntityPlayer target = sender.func_130014_f_().func_72924_a(args[3]);
            if (target == null) {
                message.reset("\u00a7c").addTranslation("cmd.frequencies.invalidPlayer", args[3]);
                message.sendTo(sender);
                return;
            }
            String string = target.func_110124_au().toString();
            String name = target.func_70005_c_();
            if (args[1].equals("add")) {
                if (ServerProxy.getConfig().isWhitelisted(target, frequency)) {
                    message.reset("\u00a7c").addTranslation("cmd.frequencies.restricted.add.player.already", name, frequency);
                } else if (ServerProxy.getConfig().addToRestricted(frequency, string, name)) {
                    message.reset("\u00a72").addTranslation("cmd.frequencies.restricted.add.player.success", name, frequency);
                } else {
                    message.reset("\u00a7c").addTranslation("cmd.frequencies.restricted.add.player.failed", name, frequency);
                }
                message.sendTo(sender);
                return;
            }
            if (args[1].equals("remove")) {
                if (!ServerProxy.getConfig().isWhitelisted(target, frequency)) {
                    message.reset("\u00a7c").addTranslation("cmd.frequencies.restricted.remove.player.none", name, frequency);
                } else if (ServerProxy.getConfig().removeFromRestricted(frequency, string, name)) {
                    message.reset("\u00a72").addTranslation("cmd.frequencies.restricted.remove.player.success", name, frequency);
                } else {
                    message.reset("\u00a7c").addTranslation("cmd.frequencies.restricted.remove.player.failed", name, frequency);
                }
                message.sendTo(sender);
                return;
            }
        }
        this.sendMessage(sender, this.func_71518_a(sender));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        short f;
        String arg2;
        if (args.length == 1) {
            return FrequenciesCommand.func_175762_a((String[])args, this.commandArguments.keySet());
        }
        if (args.length == 2) {
            switch (args[0]) {
                case "blacklisted": 
                case "restricted": {
                    return FrequenciesCommand.func_175762_a((String[])args, this.frequenciesArguments);
                }
                case "help": {
                    return FrequenciesCommand.func_175762_a((String[])args, this.commandArguments.keySet());
                }
            }
        } else if (args.length == 4 && args[0].equals("restricted") && (args[1].equals("add") || args[1].equals("remove")) && (arg2 = args[2]).matches("(\\d)*") && arg2.length() >= 1 && arg2.length() <= 4 && (f = Short.parseShort(arg2)) >= 1 && f <= 1000) {
            return FrequenciesCommand.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        return new ArrayList<String>();
    }

    public boolean func_82358_a(String[] args, int index) {
        String arg2;
        if (args.length == 4 && args[0].equals("restricted") && (args[1].equals("add") || args[1].equals("remove")) && (arg2 = args[2]).matches("(\\d)*") && arg2.length() >= 1 && arg2.length() <= 4) {
            short f = Short.parseShort(arg2);
            return f >= 1 && f <= 1000;
        }
        return false;
    }

    public void sendMessage(ICommandSender sender, String message) {
        sender.func_145747_a((ITextComponent)new TextComponentString(message));
    }
}

