/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.radio.server;

import fr.nathanael2611.modularvoicechat.api.VoiceDispatchEvent;
import fr.nathanael2611.modularvoicechat.api.VoiceProperties;
import fr.zeevoker2vex.radio.common.CommonProxy;
import fr.zeevoker2vex.radio.common.items.RadioItem;
import fr.zeevoker2vex.radio.common.network.NetworkHandler;
import fr.zeevoker2vex.radio.common.network.client.RadioStatePacket;
import fr.zeevoker2vex.radio.server.config.AddonConfig;
import fr.zeevoker2vex.radio.server.config.FrequenciesConfig;
import fr.zeevoker2vex.radio.server.radio.RadioManager;
import java.io.File;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ServerProxy
extends CommonProxy {
    private static FrequenciesConfig addonConfig;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        File configFolder = new File(event.getModConfigurationDirectory().getPath(), "Z-MVC-Addons");
        if (!configFolder.exists()) {
            configFolder.mkdirs();
        }
        File configFile = new File(configFolder.getPath(), "RadioFrequencies.json");
        addonConfig = new FrequenciesConfig(configFile);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static FrequenciesConfig getConfig() {
        return addonConfig;
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
    }

    @SubscribeEvent
    public void dispatchVoice(VoiceDispatchEvent event) {
        ItemStack stack;
        EntityPlayerMP player = event.getSpeaker();
        if (RadioManager.isSpeakingOn((EntityPlayer)player) && RadioItem.getRadioState(stack = player.func_184614_ca())) {
            short frequency = RadioItem.getRadioFrequency(stack);
            List<EntityPlayer> connected = RadioManager.getPlayersConnectedOnFrequency(frequency);
            for (EntityPlayer target : connected) {
                if (player == target) continue;
                int targetVolume = 50;
                UUID targetRadioUUID = RadioManager.getPlayerRadioUUIDFromFrequency(target, frequency);
                if (targetRadioUUID != null) {
                    ItemStack targetStack = RadioItem.getRadioFromUUID(target, targetRadioUUID);
                    targetVolume = RadioItem.getRadioVolume(targetStack);
                }
                event.setProperties(VoiceProperties.builder().with("isRadio", true).build());
                event.dispatchTo((EntityPlayerMP)target, targetVolume, VoiceProperties.builder().with("isRadio", true).build());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer player = event.player;
        RadioItem.turnOffAllRadios(player);
        RadioManager.updatePlayerSpeaking(player, false, (short)0);
        RadioManager.disconnectPlayerFromAll(player);
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        RadioItem.turnOffAllRadios(event.player);
    }

    @SubscribeEvent
    public void onPlayerDrops(PlayerDropsEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        RadioManager.updatePlayerSpeaking(player, false, (short)0);
        for (EntityItem drop : event.getDrops()) {
            ItemStack stack = drop.func_92059_d();
            if (!RadioItem.getRadioState(stack)) continue;
            RadioItem.setRadioState(stack, false);
            NetworkHandler.getInstance().getNetwork().sendToAll((IMessage)new RadioStatePacket(false, stack));
            RadioManager.disconnectPlayerFromFrequency(player, RadioItem.getRadioUUID(stack));
        }
    }

    @SubscribeEvent
    public void onEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            ItemStack from = event.getFrom();
            ItemStack to = event.getTo();
            boolean clearItem = RadioItem.isItemRadio(from) && !player.field_71071_by.func_70431_c(from);
            boolean changeRadio = RadioItem.areDifferentRadio(from, to);
            if (clearItem) {
                RadioItem.setRadioState(from, false);
                NetworkHandler.getInstance().getNetwork().sendToAll((IMessage)new RadioStatePacket(false, from));
                RadioManager.disconnectPlayerFromFrequency(player, RadioItem.getRadioUUID(from));
                RadioManager.updatePlayerSpeaking(player, false, (short)0);
            }
            if (changeRadio && RadioItem.isItemRadio(from) && RadioManager.isSpeakingOn(player)) {
                RadioManager.updatePlayerSpeaking(player, false, (short)0);
                if (RadioItem.getRadioState(to)) {
                    RadioManager.updatePlayerSpeaking(player, true, RadioItem.getRadioFrequency(to));
                }
            }
            if (changeRadio && RadioItem.isItemRadio(to)) {
                RadioItem.useRadio(to, AddonConfig.generalConfig.radioUse.heldDamage);
            }
        }
    }
}

