/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.radio.common.network.server;

import fr.zeevoker2vex.radio.common.items.RadioItem;
import fr.zeevoker2vex.radio.common.network.client.RadioResponsePacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RadioChangeVolumePacket
implements IMessage {
    public short volume;

    public RadioChangeVolumePacket(short volume) {
        this.volume = volume;
    }

    public RadioChangeVolumePacket() {
    }

    public void fromBytes(ByteBuf buf) {
        this.volume = buf.readShort();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort((int)this.volume);
    }

    public static class ServerHandler
    implements IMessageHandler<RadioChangeVolumePacket, IMessage> {
        @SideOnly(value=Side.SERVER)
        public IMessage onMessage(RadioChangeVolumePacket message, MessageContext ctx) {
            short volume = message.volume;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ItemStack stack = player.func_184614_ca();
            if (!RadioItem.isItemRadio(stack)) {
                return null;
            }
            if (volume < 0 || volume > 100) {
                volume = (short)(volume < 0 ? 0 : 100);
                return new RadioResponsePacket(-1, volume, RadioResponsePacket.ResponseCode.VOLUME_INVALID, stack);
            }
            RadioItem.setRadioVolume(stack, volume);
            return new RadioResponsePacket(-1, volume, RadioResponsePacket.ResponseCode.VOLUME_SUCCESS, stack);
        }
    }
}

