/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.radio.common.network.server;

import fr.zeevoker2vex.radio.client.ClientProxy;
import fr.zeevoker2vex.radio.common.items.RadioItem;
import fr.zeevoker2vex.radio.server.config.AddonConfig;
import fr.zeevoker2vex.radio.server.radio.RadioManager;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerSpeakingOnRadioPacket
implements IMessage {
    public boolean startSpeaking;

    public PlayerSpeakingOnRadioPacket(boolean startSpeaking) {
        this.startSpeaking = startSpeaking;
    }

    public PlayerSpeakingOnRadioPacket() {
    }

    public void fromBytes(ByteBuf buf) {
        this.startSpeaking = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.startSpeaking);
    }

    public static class ClientHandler
    implements IMessageHandler<PlayerSpeakingOnRadioPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PlayerSpeakingOnRadioPacket message, MessageContext ctx) {
            ClientProxy.speaking = message.startSpeaking;
            return null;
        }
    }

    public static class ServerHandler
    implements IMessageHandler<PlayerSpeakingOnRadioPacket, IMessage> {
        @SideOnly(value=Side.SERVER)
        public IMessage onMessage(PlayerSpeakingOnRadioPacket message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ItemStack stack = player.func_184614_ca();
            short frequency = RadioItem.getRadioFrequency(stack);
            boolean speaking = RadioItem.getRadioState(stack) && message.startSpeaking;
            RadioManager.updatePlayerSpeaking((EntityPlayer)player, speaking, frequency);
            if (speaking) {
                RadioItem.useRadio(stack, AddonConfig.generalConfig.radioUse.speakDamage);
            }
            return new PlayerSpeakingOnRadioPacket(speaking);
        }
    }
}

