/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.radio.common.network.server;

import fr.zeevoker2vex.radio.common.items.RadioItem;
import fr.zeevoker2vex.radio.common.network.client.RadioResponsePacket;
import fr.zeevoker2vex.radio.server.ServerProxy;
import fr.zeevoker2vex.radio.server.radio.RadioManager;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerConnectRadioPacket
implements IMessage {
    public String frequencyText;

    public PlayerConnectRadioPacket(String frequencyText) {
        this.frequencyText = frequencyText;
    }

    public PlayerConnectRadioPacket() {
    }

    public void fromBytes(ByteBuf buf) {
        this.frequencyText = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.frequencyText);
    }

    public static class ServerHandler
    implements IMessageHandler<PlayerConnectRadioPacket, IMessage> {
        @SideOnly(value=Side.SERVER)
        public IMessage onMessage(PlayerConnectRadioPacket message, MessageContext ctx) {
            String frequencyText = message.frequencyText;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ItemStack stack = player.func_184614_ca();
            if (!RadioItem.isItemRadio(stack)) {
                return null;
            }
            boolean state = RadioItem.getRadioState(stack);
            short frequency = 0;
            if (frequencyText.matches("(\\d)*") && frequencyText.length() < 5 && frequencyText.length() > 0) {
                frequency = Short.parseShort(frequencyText);
            }
            if (frequency < 1 || frequency > 1000) {
                return new RadioResponsePacket(-1, -1, RadioResponsePacket.ResponseCode.CONNECT_INVALID_FREQUENCY, stack);
            }
            byte connectResponse = ServerProxy.getConfig().canPlayerConnect((EntityPlayer)player, frequency);
            if (connectResponse == 1) {
                return new RadioResponsePacket(frequency, -1, RadioResponsePacket.ResponseCode.CONNECT_BLACKLISTED, stack);
            }
            if (connectResponse == 2) {
                return new RadioResponsePacket(frequency, -1, RadioResponsePacket.ResponseCode.CONNECT_NO_PERM, stack);
            }
            UUID radioUUID = RadioItem.getRadioUUID(stack);
            if (state) {
                RadioManager.disconnectPlayerFromFrequency((EntityPlayer)player, radioUUID);
            }
            RadioManager.connectToFrequency((EntityPlayer)player, frequency, radioUUID);
            RadioItem.setRadioState(stack, true);
            RadioItem.setRadioFrequency(stack, frequency);
            return new RadioResponsePacket(frequency, -1, RadioResponsePacket.ResponseCode.CONNECT_SUCCESS, stack);
        }
    }
}

