/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.radio.common.network.client;

import fr.zeevoker2vex.radio.client.gui.RadioGui;
import fr.zeevoker2vex.radio.common.items.RadioItem;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RadioResponsePacket
implements IMessage {
    public short frequency;
    public short volume;
    public ResponseCode responseCode;
    public ItemStack stack;

    public RadioResponsePacket(short frequency, short volume, ResponseCode responseCode, ItemStack stack) {
        this.frequency = frequency;
        this.volume = volume;
        this.responseCode = responseCode;
        this.stack = stack;
    }

    public RadioResponsePacket() {
    }

    public void fromBytes(ByteBuf buf) {
        this.frequency = buf.readShort();
        this.volume = buf.readShort();
        this.responseCode = ResponseCode.values()[buf.readInt()];
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort((int)this.frequency);
        buf.writeShort((int)this.volume);
        buf.writeInt(this.responseCode.ordinal());
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
    }

    public static enum ResponseCode {
        CONNECT_SUCCESS("radio.responseCode.connect.success", new Color(40, 119, 11).getRGB()),
        CONNECT_INVALID_FREQUENCY("radio.responseCode.connect.invalidFrequency", new Color(159, 6, 6).getRGB()),
        CONNECT_NO_PERM("radio.responseCode.connect.noPerm", Color.RED.getRGB()),
        CONNECT_BLACKLISTED("radio.responseCode.connect.blacklisted", Color.RED.getRGB()),
        DISCONNECT_SUCCESS("radio.responseCode.disconnect.success", new Color(16, 154, 6).getRGB()),
        DISCONNECT_ALREADY("radio.responseCode.disconnect.already", new Color(227, 127, 13).getRGB()),
        VOLUME_SUCCESS("radio.responseCode.volume.success", new Color(40, 119, 11).getRGB()),
        VOLUME_INVALID("radio.responseCode.volume.invalid", new Color(159, 6, 6).getRGB());

        public String unlocalizedText;
        public int textColor;

        private ResponseCode(String unlocalizedText, int textColor) {
            this.unlocalizedText = unlocalizedText;
            this.textColor = textColor;
        }

        public String getUnlocalizedText() {
            return this.unlocalizedText;
        }

        public int getTextColor() {
            return this.textColor;
        }
    }

    public static class ClientHandler
    implements IMessageHandler<RadioResponsePacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(RadioResponsePacket message, MessageContext ctx) {
            ResponseCode responseCode = message.responseCode;
            short frequency = message.frequency;
            short volume = message.volume;
            ItemStack stack = message.stack;
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            boolean isOwnStack = RadioItem.areDifferentRadio(stack, player.func_184614_ca());
            if (isOwnStack) {
                switch (responseCode) {
                    case CONNECT_SUCCESS: {
                        RadioItem.setRadioFrequency(stack, frequency);
                        RadioItem.setRadioState(stack, true);
                        break;
                    }
                    case CONNECT_NO_PERM: 
                    case CONNECT_BLACKLISTED: {
                        RadioItem.setRadioFrequency(stack, frequency);
                        break;
                    }
                    case DISCONNECT_SUCCESS: {
                        RadioItem.setRadioState(stack, false);
                        break;
                    }
                    case VOLUME_SUCCESS: 
                    case VOLUME_INVALID: {
                        RadioItem.setRadioVolume(stack, volume);
                        break;
                    }
                }
                if (mc.field_71462_r instanceof RadioGui) {
                    RadioGui radioGui = (RadioGui)mc.field_71462_r;
                    if (frequency > 0) {
                        radioGui.frequencyField.func_146180_a(Short.toString(frequency));
                    }
                    radioGui.showResponse(responseCode);
                }
            }
            return null;
        }
    }
}

