/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.radio.common.network;

import fr.zeevoker2vex.radio.common.network.client.PlayRadioSoundPacket;
import fr.zeevoker2vex.radio.common.network.client.RadioResponsePacket;
import fr.zeevoker2vex.radio.common.network.client.RadioStatePacket;
import fr.zeevoker2vex.radio.common.network.client.RadioUUIDPacket;
import fr.zeevoker2vex.radio.common.network.server.PlayerConnectRadioPacket;
import fr.zeevoker2vex.radio.common.network.server.PlayerDisconnectRadioPacket;
import fr.zeevoker2vex.radio.common.network.server.PlayerSpeakingOnRadioPacket;
import fr.zeevoker2vex.radio.common.network.server.RadioChangeVolumePacket;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class NetworkHandler {
    private SimpleNetworkWrapper network;
    private static NetworkHandler instance;
    private int nextID = 0;

    public static NetworkHandler getInstance() {
        if (instance == null) {
            instance = new NetworkHandler();
        }
        return instance;
    }

    public SimpleNetworkWrapper getNetwork() {
        return this.network;
    }

    public void registerPackets() {
        this.network = NetworkRegistry.INSTANCE.newSimpleChannel("z-radio");
        this.registerPacket(PlayRadioSoundPacket.ClientHandler.class, PlayRadioSoundPacket.class, Side.CLIENT);
        this.registerPacket(PlayerSpeakingOnRadioPacket.ClientHandler.class, PlayerSpeakingOnRadioPacket.class, Side.CLIENT);
        this.registerPacket(RadioResponsePacket.ClientHandler.class, RadioResponsePacket.class, Side.CLIENT);
        this.registerPacket(RadioStatePacket.ClientHandler.class, RadioStatePacket.class, Side.CLIENT);
        this.registerPacket(RadioUUIDPacket.ClientHandler.class, RadioUUIDPacket.class, Side.CLIENT);
        this.registerPacket(PlayerConnectRadioPacket.ServerHandler.class, PlayerConnectRadioPacket.class, Side.SERVER);
        this.registerPacket(PlayerDisconnectRadioPacket.ServerHandler.class, PlayerDisconnectRadioPacket.class, Side.SERVER);
        this.registerPacket(PlayerSpeakingOnRadioPacket.ServerHandler.class, PlayerSpeakingOnRadioPacket.class, Side.SERVER);
        this.registerPacket(RadioChangeVolumePacket.ServerHandler.class, RadioChangeVolumePacket.class, Side.SERVER);
    }

    private <REQ extends IMessage, REPLY extends IMessage> void registerPacket(Class<? extends IMessageHandler<REQ, REPLY>> messageHandler, Class<REQ> requestMessageType, Side side) {
        this.network.registerMessage(messageHandler, requestMessageType, this.nextID++, side);
    }
}

