/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.radio.common.items;

import fr.zeevoker2vex.radio.client.ClientProxy;
import fr.zeevoker2vex.radio.client.gui.RadioGui;
import fr.zeevoker2vex.radio.common.network.NetworkHandler;
import fr.zeevoker2vex.radio.common.network.client.RadioUUIDPacket;
import fr.zeevoker2vex.radio.common.registry.ItemRegistry;
import fr.zeevoker2vex.radio.server.config.AddonConfig;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class RadioItem
extends Item {
    public static final String STATE_KEY_TAG = "state";
    public static final String FREQUENCY_KEY_TAG = "frequency";
    public static final String UUID_KEY_TAG = "RadioUUID";
    public static final String VOLUME_KEY_TAG = "volume";

    public RadioItem() {
        this.setRegistryName("z-radio", "radio");
        this.func_77655_b("z-radio.radio");
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77656_e(300);
        this.func_185043_a(new ResourceLocation("z-radio", "radioState"), (stack, worldIn, entityIn) -> {
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(STATE_KEY_TAG)) {
                return stack.func_77978_p().func_74767_n(STATE_KEY_TAG) ? 1.0f : 0.0f;
            }
            return 0.0f;
        });
    }

    @SideOnly(value=Side.CLIENT)
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new RadioGui(stack));
        return super.func_77659_a(world, player, hand);
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(I18n.func_135052_a((String)"radio.tooltip.frequency", (Object[])new Object[]{RadioItem.getRadioFrequency(stack)}));
            tooltip.add(I18n.func_135052_a((String)"radio.tooltip.volume", (Object[])new Object[]{RadioItem.getRadioVolume(stack)}));
            tooltip.add(I18n.func_135052_a((String)"radio.tooltip.state", (Object[])new Object[]{RadioItem.getRadioState(stack) ? "ON" : "OFF"}));
            tooltip.add("");
            tooltip.add(I18n.func_135052_a((String)"radio.tooltip.shift", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"radio.tooltip.info.title", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"radio.tooltip.info.state", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"radio.tooltip.info.frequency", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"radio.tooltip.info.volume", (Object[])new Object[0]));
            tooltip.add("");
            tooltip.add(I18n.func_135052_a((String)"radio.tooltip.info.key", (Object[])new Object[]{ClientProxy.SPEAK_ON_RADIO.getDisplayName()}));
        }
        super.func_77624_a(stack, world, tooltip, flagIn);
    }

    public static NBTTagCompound getTagCompound(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt;
    }

    public static boolean isItemRadio(ItemStack stack) {
        return stack.func_77973_b() == ItemRegistry.RADIO;
    }

    public static boolean isPlayerHeldActiveRadio(EntityPlayer player) {
        return RadioItem.getRadioState(player.func_184614_ca());
    }

    public static void setRadioState(ItemStack stack, boolean state) {
        if (!RadioItem.isItemRadio(stack)) {
            return;
        }
        NBTTagCompound nbt = RadioItem.getTagCompound(stack);
        nbt.func_74757_a(STATE_KEY_TAG, state);
    }

    public static void setRadioFrequency(ItemStack stack, short frequencyText) {
        if (!RadioItem.isItemRadio(stack)) {
            return;
        }
        NBTTagCompound nbt = RadioItem.getTagCompound(stack);
        nbt.func_74777_a(FREQUENCY_KEY_TAG, frequencyText);
    }

    public static void setRadioVolume(ItemStack stack, short volume) {
        if (!RadioItem.isItemRadio(stack)) {
            return;
        }
        NBTTagCompound nbt = RadioItem.getTagCompound(stack);
        nbt.func_74777_a(VOLUME_KEY_TAG, volume);
    }

    public static boolean getRadioState(ItemStack stack) {
        NBTTagCompound nbt;
        if (RadioItem.isItemRadio(stack) && (nbt = RadioItem.getTagCompound(stack)).func_74764_b(STATE_KEY_TAG)) {
            return nbt.func_74767_n(STATE_KEY_TAG);
        }
        return false;
    }

    public static short getRadioFrequency(ItemStack stack) {
        NBTTagCompound nbt;
        if (RadioItem.isItemRadio(stack) && (nbt = RadioItem.getTagCompound(stack)).func_74764_b(FREQUENCY_KEY_TAG)) {
            return nbt.func_74765_d(FREQUENCY_KEY_TAG);
        }
        return 0;
    }

    public static short getRadioVolume(ItemStack stack) {
        NBTTagCompound nbt;
        if (RadioItem.isItemRadio(stack) && (nbt = RadioItem.getTagCompound(stack)).func_74764_b(VOLUME_KEY_TAG)) {
            return nbt.func_74765_d(VOLUME_KEY_TAG);
        }
        return 100;
    }

    public static void turnOffAllRadios(EntityPlayer player) {
        List<ItemStack> stacks = player.field_71071_by.field_70462_a.stream().filter(RadioItem::getRadioState).collect(Collectors.toList());
        stacks.forEach(stack -> RadioItem.setRadioState(stack, false));
    }

    public static void useRadio(ItemStack stack, int damage) {
        if (!AddonConfig.generalConfig.radioUse.damageEnabled || !RadioItem.isItemRadio(stack)) {
            return;
        }
        int currentDamage = stack.func_77952_i();
        stack.func_77964_b(currentDamage + damage);
    }

    public static UUID initRadioUUID(ItemStack stack) {
        if (FMLCommonHandler.instance().getSide().equals((Object)Side.SERVER)) {
            if (!RadioItem.isItemRadio(stack)) {
                return null;
            }
            UUID uuid = UUID.randomUUID();
            RadioItem.setRadioUUID(stack, uuid);
            NetworkHandler.getInstance().getNetwork().sendToAll((IMessage)new RadioUUIDPacket(uuid, stack));
            return uuid;
        }
        return null;
    }

    public static void setRadioUUID(ItemStack stack, UUID uuid) {
        if (!RadioItem.isItemRadio(stack)) {
            return;
        }
        NBTTagCompound nbt = RadioItem.getTagCompound(stack);
        nbt.func_74778_a(UUID_KEY_TAG, uuid.toString());
    }

    public static UUID getRadioUUID(ItemStack stack) {
        if (RadioItem.isItemRadio(stack)) {
            NBTTagCompound nbt = RadioItem.getTagCompound(stack);
            if (nbt.func_74764_b(UUID_KEY_TAG)) {
                return UUID.fromString(nbt.func_74779_i(UUID_KEY_TAG));
            }
            return RadioItem.initRadioUUID(stack);
        }
        return null;
    }

    public static ItemStack getRadioFromUUID(EntityPlayer player, UUID uuid) {
        Optional<ItemStack> radioStack = player.field_71071_by.field_70462_a.stream().filter(stack -> Objects.equals(RadioItem.getRadioUUID(stack), uuid)).findFirst();
        return radioStack.orElse(ItemStack.field_190927_a);
    }

    public static boolean radioHasUUID(ItemStack stack) {
        if (RadioItem.isItemRadio(stack)) {
            NBTTagCompound nbt = RadioItem.getTagCompound(stack);
            return nbt.func_74764_b(UUID_KEY_TAG);
        }
        return false;
    }

    public static boolean areDifferentRadio(ItemStack stack1, ItemStack stack2) {
        if (!RadioItem.isItemRadio(stack1) || !RadioItem.isItemRadio(stack2)) {
            return true;
        }
        if (!RadioItem.radioHasUUID(stack1)) {
            RadioItem.initRadioUUID(stack1);
            return true;
        }
        if (!RadioItem.radioHasUUID(stack2)) {
            RadioItem.initRadioUUID(stack2);
            return true;
        }
        return RadioItem.getRadioUUID(stack1) != RadioItem.getRadioUUID(stack2);
    }
}

