/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.radio.client.gui;

import com.google.common.base.Predicate;
import fr.zeevoker2vex.radio.client.gui.CustomGuiSlider;
import fr.zeevoker2vex.radio.client.gui.GuiUtils;
import fr.zeevoker2vex.radio.common.items.RadioItem;
import fr.zeevoker2vex.radio.common.network.NetworkHandler;
import fr.zeevoker2vex.radio.common.network.client.RadioResponsePacket;
import fr.zeevoker2vex.radio.common.network.server.PlayerConnectRadioPacket;
import fr.zeevoker2vex.radio.common.network.server.PlayerDisconnectRadioPacket;
import java.awt.Color;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class RadioGui
extends GuiScreen {
    public short frequency = 1;
    private final ItemStack stack;
    public GuiTextField frequencyField;
    private GuiButton connectButton;
    private GuiButton disconnectButton;
    private final int MHZ_TEXT_COLOR = new Color(28, 90, 5).getRGB();
    private final float DEFAULT_TEXT_DURATION = 400.0f;
    private List<String> responseCodeText;
    private float textTicks = 0.0f;
    private int responseCodeTextColor;
    private final int MAX_WIDTH = 170;

    public RadioGui(ItemStack stack) {
        NBTTagCompound nbt = RadioItem.getTagCompound(stack);
        if (nbt.func_74764_b("frequency")) {
            this.frequency = nbt.func_74765_d("frequency");
        }
        this.stack = stack;
    }

    public void func_73866_w_() {
        this.disconnectButton = new GuiButton(0, this.field_146294_l - 90, this.field_146295_m - 80, 80, 20, I18n.func_135052_a((String)"radio.gui.disconnectButton", (Object[])new Object[0]));
        this.func_189646_b(this.disconnectButton);
        this.connectButton = new GuiButton(1, this.field_146294_l - 240, this.field_146295_m - 80, 80, 20, I18n.func_135052_a((String)"radio.gui.connectButton", (Object[])new Object[0]));
        this.func_189646_b(this.connectButton);
        this.func_189646_b(new CustomGuiSlider(3, this.field_146294_l - 200, this.field_146295_m - 55, RadioItem.getRadioVolume(this.stack), 0.0f, 100.0f));
        this.frequencyField = new GuiTextField(2, this.field_146289_q, this.field_146294_l - 150, this.field_146295_m - 80, 50, 20);
        Predicate frequencyValidator = string -> {
            if (string.matches("(\\d)*")) {
                if (string.length() == 0) {
                    return true;
                }
                int f = Integer.parseInt(string);
                return f >= 1 && f <= 1000;
            }
            return false;
        };
        this.frequencyField.func_146203_f(4);
        this.frequencyField.func_175205_a(frequencyValidator);
        this.frequencyField.func_146180_a(Short.toString(this.frequency));
        this.frequencyField.func_146193_g(this.MHZ_TEXT_COLOR);
        this.frequencyField.func_146195_b(true);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.frequencyField == null) {
            this.field_146297_k.func_71381_h();
            Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentTranslation("radio.gui.nullInput", new Object[0]), true);
            return;
        }
        this.frequencyField.func_146194_f();
        this.func_73731_b(this.field_146289_q, "Mhz", this.field_146294_l - 120, this.field_146295_m - 83 + this.field_146289_q.field_78288_b, this.MHZ_TEXT_COLOR);
        if (this.textTicks > 0.0f) {
            float f;
            float alpha = Math.max(0.0f, Math.min(1.0f, this.textTicks / 400.0f)) * 255.0f;
            int newAlpha = (int)alpha;
            if (newAlpha > 8) {
                int color = 0xFFFFFF & this.responseCodeTextColor;
                int finalColor = color + (newAlpha << 24 & -color);
                int numberOfLines = this.responseCodeText.size();
                int localY = this.field_146295_m - 80 + numberOfLines * (-5 - this.field_146289_q.field_78288_b);
                int l = 0;
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                for (String line : this.responseCodeText) {
                    GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    this.field_146289_q.func_175063_a(line, (float)(this.field_146294_l - 125 - this.field_146289_q.func_78256_a(line) / 2), (float)localY, finalColor);
                    localY += ++l * (5 + this.field_146289_q.field_78288_b);
                }
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
            this.textTicks -= 1.0f;
            if (f <= 0.0f) {
                this.textTicks = 0.0f;
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void showResponse(RadioResponsePacket.ResponseCode responseCode) {
        String text = I18n.func_135052_a((String)responseCode.getUnlocalizedText(), (Object[])new Object[0]);
        this.responseCodeText = GuiUtils.splitString(text, 170, this.field_146297_k);
        this.responseCodeTextColor = responseCode.getTextColor();
        this.textTicks = 400.0f;
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == this.connectButton.field_146127_k) {
            NetworkHandler.getInstance().getNetwork().sendToServer((IMessage)new PlayerConnectRadioPacket(this.frequencyField.func_146179_b()));
        } else if (button.field_146127_k == this.disconnectButton.field_146127_k) {
            NetworkHandler.getInstance().getNetwork().sendToServer((IMessage)new PlayerDisconnectRadioPacket(0));
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.frequencyField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.frequencyField.func_146201_a(typedChar, keyCode);
        if (keyCode == 15) {
            this.frequencyField.func_146195_b(true);
        }
    }

    public void func_73876_c() {
        this.frequencyField.func_146178_a();
    }
}

