/*
 * Decompiled with CFR 0.152.
 */
package fr.zeevoker2vex.radio.client;

import fr.nathanael2611.modularvoicechat.api.VoiceKeyEvent;
import fr.nathanael2611.modularvoicechat.api.VoicePlayEvent;
import fr.nathanael2611.modularvoicechat.client.gui.GuiConfig;
import fr.nathanael2611.modularvoicechat.client.voice.audio.MicroManager;
import fr.nathanael2611.modularvoicechat.util.AudioUtil;
import fr.zeevoker2vex.radio.common.CommonProxy;
import fr.zeevoker2vex.radio.common.items.RadioItem;
import fr.zeevoker2vex.radio.common.network.NetworkHandler;
import fr.zeevoker2vex.radio.common.network.server.PlayerSpeakingOnRadioPacket;
import fr.zeevoker2vex.radio.util.uk.me.berndporr.iirj.ChebyshevI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ClientProxy
extends CommonProxy {
    public static final KeyBinding SPEAK_ON_RADIO = new KeyBinding("key.z-radio.speakonradio", 45, "key.categories.z-radio");
    public static boolean speaking = false;
    private Minecraft mc;
    public ChebyshevI chebyshevFilter;
    public int gainRadio = 5;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        this.mc = Minecraft.func_71410_x();
        ClientRegistry.registerKeyBinding((KeyBinding)SPEAK_ON_RADIO);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.chebyshevFilter = new ChebyshevI();
        this.chebyshevFilter.bandPass(2, 48000.0, 2000.0, 1200.0, 1.0);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
    }

    @SubscribeEvent
    public void onVoiceKey(VoiceKeyEvent event) {
        if (SPEAK_ON_RADIO.func_151470_d()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onVoicePlayEvent(VoicePlayEvent event) {
        if (event.getProperties().getBooleanValue("isRadio")) {
            short[] samples = AudioUtil.bytesToShorts((byte[])event.getAudioSamples());
            for (int i = 0; i < samples.length; ++i) {
                samples[i] = (short)(this.chebyshevFilter.filter(samples[i]) * (double)this.gainRadio);
            }
            event.setAudioSamples(AudioUtil.shortsToBytes((short[])samples));
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !GuiConfig.audioTesting) {
            if (GameSettings.func_100015_a((KeyBinding)SPEAK_ON_RADIO) && RadioItem.isPlayerHeldActiveRadio((EntityPlayer)this.mc.field_71439_g)) {
                if (MicroManager.isRunning() && !MicroManager.getHandler().isSending()) {
                    if (!speaking) {
                        NetworkHandler.getInstance().getNetwork().sendToServer((IMessage)new PlayerSpeakingOnRadioPacket(true));
                    }
                    MicroManager.getHandler().start();
                }
            } else if (MicroManager.isRunning() && MicroManager.getHandler().isSending() && speaking) {
                NetworkHandler.getInstance().getNetwork().sendToServer((IMessage)new PlayerSpeakingOnRadioPacket(false));
            }
        }
    }
}

