/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.tileentity;

import com.westeroscraft.westerosblocks.blocks.WCSoundBlock;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WCTileEntitySound
extends TileEntity
implements ITickable {
    public byte soundIndex;
    public int playback_period = 0;
    public int random_playback_addition = 0;
    public int startTime = 0;
    public int endTime = 0;
    public boolean previousRedstoneState;
    public int nextPlaybackTimer = 0;
    private boolean initDone = false;
    private static Random rnd = new Random();

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (!this.initDone) {
            this.initBlock();
        }
        int[] val = new int[]{this.playback_period, this.random_playback_addition, this.soundIndex & 0x7F, this.startTime << 16 | this.endTime};
        nbt.func_74783_a("val", val);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int[] val = nbt.func_74759_k("val");
        if (val != null && val.length >= 4) {
            this.playback_period = val[0];
            this.random_playback_addition = val[1];
            this.soundIndex = (byte)(val[2] & 0x7F);
            this.startTime = val[3] >> 16 & 0xFFFF;
            this.endTime = val[3] & 0xFFFF;
        }
        this.initDone = true;
    }

    public void changeSoundSelection(WCSoundBlock sb, int meta) {
        List<String> sndids = sb.getWBDefinition().getSoundIDList(meta);
        this.soundIndex = sndids == null || sndids.isEmpty() ? (byte)-1 : (byte)((this.soundIndex + 1) % sndids.size());
        this.func_70296_d();
    }

    public void triggerSound(WCSoundBlock sb, World world, BlockPos pos) {
        world.func_175641_c(pos, (Block)sb, 0, (int)this.soundIndex);
        this.nextPlaybackTimer = 0;
    }

    public void func_73660_a() {
        if (!this.initDone) {
            this.initBlock();
        }
        if (this.playback_period <= 0) {
            return;
        }
        --this.nextPlaybackTimer;
        if (this.nextPlaybackTimer > 0) {
            return;
        }
        if (this.nextPlaybackTimer == 0) {
            Block b;
            long wt = this.field_145850_b.func_72820_D() % 24000L;
            if (wt < 0L) {
                wt += 24000L;
            }
            boolean trigger = true;
            if (this.startTime >= this.endTime) {
                trigger = wt < (long)this.endTime || wt >= (long)this.startTime;
            } else {
                boolean bl = trigger = wt >= (long)this.startTime && wt < (long)this.endTime;
            }
            if (trigger && (b = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()) instanceof WCSoundBlock) {
                this.triggerSound((WCSoundBlock)b, this.field_145850_b, this.field_174879_c);
            }
        }
        this.nextPlaybackTimer = this.playback_period + rnd.nextInt(this.random_playback_addition + 1);
    }

    private void initBlock() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        WCSoundBlock sb = (WCSoundBlock)state.func_177230_c();
        int meta = sb.func_176201_c(state);
        this.playback_period = sb.def_period_by_meta[meta];
        this.random_playback_addition = sb.def_addition_by_meta[meta];
        this.startTime = sb.def_starttime_by_meta[meta];
        this.endTime = sb.def_endtime_by_meta[meta];
        this.initDone = true;
    }
}

