/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.modelexport;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.modelexport.ModelExport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;

public class WallBlockModelExport
extends ModelExport {
    private WesterosBlockDef def;

    public WallBlockModelExport(Block blk, WesterosBlockDef def, File dest) {
        super(blk, def, dest);
        this.def = def;
        for (WesterosBlockDef.Subblock sb : def.subBlocks) {
            WallBlockModelExport.addNLSString("tile." + def.blockName + "_" + sb.meta + ".name", sb.label);
        }
    }

    @Override
    public void doBlockStateExport() throws IOException {
        StateObject so = new StateObject();
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            SideStates ssn = new SideStates();
            WhenRec wr = new WhenRec();
            wr.variant2 = Integer.toString(sb.meta);
            wr.up = "true";
            ssn.when.OR.add(wr);
            ssn.apply.model = "westerosblocks:" + this.def.blockName + "_post_" + sb.meta;
            so.multipart.add(ssn);
            ssn = new SideStates();
            wr = new WhenRec();
            wr.variant2 = Integer.toString(sb.meta);
            wr.north = "true";
            ssn.when.OR.add(wr);
            ssn.apply.model = "westerosblocks:" + this.def.blockName + "_side_" + sb.meta;
            ssn.apply.uvlock = true;
            so.multipart.add(ssn);
            ssn = new SideStates();
            wr = new WhenRec();
            wr.variant2 = Integer.toString(sb.meta);
            wr.east = "true";
            ssn.when.OR.add(wr);
            ssn.apply.model = "westerosblocks:" + this.def.blockName + "_side_" + sb.meta;
            ssn.apply.uvlock = true;
            ssn.apply.y = 90;
            so.multipart.add(ssn);
            ssn = new SideStates();
            wr = new WhenRec();
            wr.variant2 = Integer.toString(sb.meta);
            wr.south = "true";
            ssn.when.OR.add(wr);
            ssn.apply.model = "westerosblocks:" + this.def.blockName + "_side_" + sb.meta;
            ssn.apply.uvlock = true;
            ssn.apply.y = 180;
            so.multipart.add(ssn);
            ssn = new SideStates();
            wr = new WhenRec();
            wr.variant2 = Integer.toString(sb.meta);
            wr.west = "true";
            ssn.when.OR.add(wr);
            ssn.apply.model = "westerosblocks:" + this.def.blockName + "_side_" + sb.meta;
            ssn.apply.uvlock = true;
            ssn.apply.y = 270;
            so.multipart.add(ssn);
        }
        this.writeBlockStateFile(this.def.blockName, so);
    }

    @Override
    public void doModelExports() throws IOException {
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            String tintres;
            boolean isTinted = sb.isTinted(this.def);
            ModelObjectPost mod = new ModelObjectPost();
            mod.textures.bottom = WallBlockModelExport.getTextureID(sb.getTextureByIndex(0));
            mod.textures.top = WallBlockModelExport.getTextureID(sb.getTextureByIndex(1));
            mod.textures.side = WallBlockModelExport.getTextureID(sb.getTextureByIndex(2));
            if (isTinted) {
                mod.parent = "westerosblocks:block/tinted/wall_post";
            }
            this.writeBlockModelFile(this.def.blockName + "_post_" + sb.meta, mod);
            ModelObjectSide smod = new ModelObjectSide();
            smod.textures.bottom = WallBlockModelExport.getTextureID(sb.getTextureByIndex(0));
            smod.textures.top = WallBlockModelExport.getTextureID(sb.getTextureByIndex(1));
            smod.textures.side = WallBlockModelExport.getTextureID(sb.getTextureByIndex(2));
            if (isTinted) {
                smod.parent = "westerosblocks:block/tinted/wall_side";
            }
            this.writeBlockModelFile(this.def.blockName + "_side_" + sb.meta, smod);
            ModelObject mo = new ModelObject();
            mo.textures.bottom = WallBlockModelExport.getTextureID(sb.getTextureByIndex(0));
            mo.textures.top = WallBlockModelExport.getTextureID(sb.getTextureByIndex(1));
            mo.textures.side = WallBlockModelExport.getTextureID(sb.getTextureByIndex(2));
            if (isTinted) {
                mo.parent = "westerosblocks:block/tinted/wall_inventory";
            }
            this.writeItemModelFile(this.def.blockName + "_" + sb.meta, mo);
            if (!isTinted || (tintres = this.def.getBlockColorMapResource(sb)) == null) continue;
            ModelExport.addTintingOverride(this.def.blockName, String.format("variant2=%s", sb.meta), tintres);
        }
    }

    public static class ModelObject {
        public String parent = "westerosblocks:block/untinted/wall_inventory";
        public Texture textures = new Texture();
    }

    public static class Texture {
        public String bottom;
        public String top;
        public String side;
    }

    public static class ModelObjectSide {
        public String parent = "westerosblocks:block/untinted/wall_side";
        public Texture textures = new Texture();
    }

    public static class ModelObjectPost {
        public String parent = "westerosblocks:block/untinted/wall_post";
        public Texture textures = new Texture();
    }

    public static class Apply {
        String model;
        Integer y;
        Boolean uvlock;
    }

    public static class WhenRec {
        String variant2;
        String up;
        String north;
        String south;
        String west;
        String east;
        public List<WhenRec> OR;
    }

    public static class SideStates
    extends States {
        SideStates() {
            this.when.OR = new ArrayList<WhenRec>();
        }
    }

    public static class States {
        public WhenRec when = new WhenRec();
        public Apply apply = new Apply();
    }

    public static class StateObject {
        public List<States> multipart = new ArrayList<States>();
    }
}

