/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.modelexport;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.modelexport.ModelExport;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;

public class TorchBlockModelExport
extends ModelExport {
    private WesterosBlockDef def;

    public TorchBlockModelExport(Block blk, WesterosBlockDef def, File dest) {
        super(blk, def, dest);
        this.def = def;
        TorchBlockModelExport.addNLSString("tile." + def.blockName + ".name", def.subBlocks.get((int)0).label);
    }

    @Override
    public void doBlockStateExport() throws IOException {
        StateObject so = new StateObject();
        String bn = this.def.blockName;
        so.variants.put("facing=up", new Variant(bn));
        so.variants.put("facing=east", new Variant(bn, "wall", 0));
        so.variants.put("facing=south", new Variant(bn, "wall", 90));
        so.variants.put("facing=west", new Variant(bn, "wall", 180));
        so.variants.put("facing=north", new Variant(bn, "wall", 270));
        this.writeBlockStateFile(this.def.blockName, so);
    }

    @Override
    public void doModelExports() throws IOException {
        WesterosBlockDef.Subblock sb = this.def.subBlocks.get(0);
        String txt = TorchBlockModelExport.getTextureID(sb.getTextureByIndex(0));
        ModelObjectTorch mod = new ModelObjectTorch();
        mod.textures.torch = txt;
        this.writeBlockModelFile(this.def.blockName, mod);
        ModelObjectTorchWall modw = new ModelObjectTorchWall();
        modw.textures.torch = txt;
        this.writeBlockModelFile(this.def.blockName + "_wall", modw);
        ModelObject mo = new ModelObject();
        mo.textures.layer0 = txt;
        this.writeItemModelFile(this.def.blockName, mo);
    }

    public static class Texture0 {
        public String layer0;
    }

    public static class ModelObject {
        public String parent = "item/generated";
        public Texture0 textures = new Texture0();
    }

    public static class Texture {
        public String torch;
    }

    public static class ModelObjectTorchWall {
        public String parent = "block/torch_wall";
        public Texture textures = new Texture();
    }

    public static class ModelObjectTorch {
        public String parent = "block/torch";
        public Texture textures = new Texture();
    }

    public static class Variant {
        public String model;
        public Integer y;

        public Variant(String blkname) {
            this.model = "westerosblocks:" + blkname;
        }

        public Variant(String blkname, String ext, int yrot) {
            this.model = "westerosblocks:" + blkname + "_" + ext;
            if (yrot != 0) {
                this.y = yrot;
            }
        }
    }

    public static class StateObject {
        public Map<String, Variant> variants = new HashMap<String, Variant>();
    }
}

