/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.modelexport;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.WesterosBlocks;
import com.westeroscraft.westerosblocks.modelexport.ModelExport;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;

public class StairsBlockModelExport
extends ModelExport {
    private final WesterosBlockDef def;

    public StairsBlockModelExport(Block blk, WesterosBlockDef def, File dest) {
        super(blk, def, dest);
        this.def = def;
        StairsBlockModelExport.addNLSString("tile." + def.blockName + ".name", def.subBlocks.get((int)0).label);
    }

    @Override
    public void doBlockStateExport() throws IOException {
        StateObject so = new StateObject();
        String bn = this.def.blockName;
        so.variants.put("facing=east,half=bottom,shape=straight", new Variant(bn));
        so.variants.put("facing=west,half=bottom,shape=straight", new Variant(bn, null, 180));
        so.variants.put("facing=south,half=bottom,shape=straight", new Variant(bn, null, 90));
        so.variants.put("facing=north,half=bottom,shape=straight", new Variant(bn, null, 270));
        so.variants.put("facing=east,half=bottom,shape=outer_right", new Variant(bn, "outer", 0));
        so.variants.put("facing=west,half=bottom,shape=outer_right", new Variant(bn, "outer", 180));
        so.variants.put("facing=south,half=bottom,shape=outer_right", new Variant(bn, "outer", 90));
        so.variants.put("facing=north,half=bottom,shape=outer_right", new Variant(bn, "outer", 270));
        so.variants.put("facing=east,half=bottom,shape=outer_left", new Variant(bn, "outer", 270));
        so.variants.put("facing=west,half=bottom,shape=outer_left", new Variant(bn, "outer", 90));
        so.variants.put("facing=south,half=bottom,shape=outer_left", new Variant(bn, "outer", 0));
        so.variants.put("facing=north,half=bottom,shape=outer_left", new Variant(bn, "outer", 180));
        so.variants.put("facing=east,half=bottom,shape=inner_right", new Variant(bn, "inner", 0));
        so.variants.put("facing=west,half=bottom,shape=inner_right", new Variant(bn, "inner", 180));
        so.variants.put("facing=south,half=bottom,shape=inner_right", new Variant(bn, "inner", 90));
        so.variants.put("facing=north,half=bottom,shape=inner_right", new Variant(bn, "inner", 270));
        so.variants.put("facing=east,half=bottom,shape=inner_left", new Variant(bn, "inner", 270));
        so.variants.put("facing=west,half=bottom,shape=inner_left", new Variant(bn, "inner", 90));
        so.variants.put("facing=south,half=bottom,shape=inner_left", new Variant(bn, "inner", 0));
        so.variants.put("facing=north,half=bottom,shape=inner_left", new Variant(bn, "inner", 180));
        so.variants.put("facing=east,half=top,shape=straight", new Variant(bn, null, 180, 0));
        so.variants.put("facing=west,half=top,shape=straight", new Variant(bn, null, 180, 180));
        so.variants.put("facing=south,half=top,shape=straight", new Variant(bn, null, 180, 90));
        so.variants.put("facing=north,half=top,shape=straight", new Variant(bn, null, 180, 270));
        so.variants.put("facing=east,half=top,shape=outer_right", new Variant(bn, "outer", 180, 90));
        so.variants.put("facing=west,half=top,shape=outer_right", new Variant(bn, "outer", 180, 270));
        so.variants.put("facing=south,half=top,shape=outer_right", new Variant(bn, "outer", 180, 180));
        so.variants.put("facing=north,half=top,shape=outer_right", new Variant(bn, "outer", 180, 0));
        so.variants.put("facing=east,half=top,shape=outer_left", new Variant(bn, "outer", 180, 0));
        so.variants.put("facing=west,half=top,shape=outer_left", new Variant(bn, "outer", 180, 180));
        so.variants.put("facing=south,half=top,shape=outer_left", new Variant(bn, "outer", 180, 90));
        so.variants.put("facing=north,half=top,shape=outer_left", new Variant(bn, "outer", 180, 270));
        so.variants.put("facing=east,half=top,shape=inner_right", new Variant(bn, "inner", 180, 90));
        so.variants.put("facing=west,half=top,shape=inner_right", new Variant(bn, "inner", 180, 270));
        so.variants.put("facing=south,half=top,shape=inner_right", new Variant(bn, "inner", 180, 180));
        so.variants.put("facing=north,half=top,shape=inner_right", new Variant(bn, "inner", 180, 0));
        so.variants.put("facing=east,half=top,shape=inner_left", new Variant(bn, "inner", 180, 0));
        so.variants.put("facing=west,half=top,shape=inner_left", new Variant(bn, "inner", 180, 180));
        so.variants.put("facing=south,half=top,shape=inner_left", new Variant(bn, "inner", 180, 90));
        so.variants.put("facing=north,half=top,shape=inner_left", new Variant(bn, "inner", 180, 270));
        this.writeBlockStateFile(this.def.blockName, so);
    }

    @Override
    public void doModelExports() throws IOException {
        String tintres;
        boolean ambientOcclusion;
        boolean isTinted = this.def.subBlocks.get(0).isTinted(this.def);
        Block bblk = WesterosBlocks.findBlockByName(this.def.modelBlockName);
        if (bblk == null) {
            throw new IOException(String.format("modelBlockName '%s' not found for block '%s'", this.def.modelBlockName, this.def.blockName));
        }
        String downtxt = null;
        String uptxt = null;
        String sidetxt = null;
        boolean bl = ambientOcclusion = this.def.subBlocks.get((int)0).ambientOcclusion != null ? this.def.subBlocks.get((int)0).ambientOcclusion : true;
        if (bblk instanceof WesterosBlockLifecycle) {
            Object bbdef = ((WesterosBlockLifecycle)bblk).getWBDefinition();
            if (bbdef == null) {
                throw new IOException(String.format("modelBlockName '%s' not found for block '%s' - no def", this.def.modelBlockName, this.def.blockName));
            }
            WesterosBlockDef.Subblock sb = ((WesterosBlockDef)bbdef).getByMeta(this.def.modelBlockMeta);
            downtxt = StairsBlockModelExport.getTextureID(sb.getTextureByIndex(0));
            uptxt = StairsBlockModelExport.getTextureID(sb.getTextureByIndex(1));
            sidetxt = StairsBlockModelExport.getTextureID(sb.getTextureByIndex(2));
        } else {
            switch (this.def.modelBlockName) {
                case "minecraft:bedrock": {
                    sidetxt = "blocks/bedrock";
                    uptxt = "blocks/bedrock";
                    downtxt = "blocks/bedrock";
                    break;
                }
                case "minecraft:lapis_block": {
                    sidetxt = "blocks/lapis_block";
                    uptxt = "blocks/lapis_block";
                    downtxt = "blocks/lapis_block";
                    break;
                }
                case "minecraft:sandstone": {
                    uptxt = "blocks/sandstone_top";
                    downtxt = "blocks/sandstone_top";
                    sidetxt = "blocks/sandstone_smooth";
                    break;
                }
                case "minecraft:iron_block": {
                    sidetxt = "blocks/iron_block";
                    uptxt = "blocks/iron_block";
                    downtxt = "blocks/iron_block";
                    break;
                }
                case "minecraft:double_stone_slab": {
                    uptxt = "blocks/stone_slab_top";
                    downtxt = "blocks/stone_slab_top";
                    sidetxt = "blocks/stone_slab_side";
                    break;
                }
                case "minecraft:snow": {
                    sidetxt = "blocks/snow";
                    uptxt = "blocks/snow";
                    downtxt = "blocks/snow";
                    break;
                }
                case "minecraft:emerald_block": {
                    sidetxt = "blocks/emerald_block";
                    uptxt = "blocks/emerald_block";
                    downtxt = "blocks/emerald_block";
                    break;
                }
                case "minecraft:obsidian": {
                    sidetxt = "blocks/obsidian";
                    uptxt = "blocks/obsidian";
                    downtxt = "blocks/obsidian";
                    break;
                }
                case "minecraft:hardened_clay": {
                    sidetxt = "blocks/hardened_clay";
                    uptxt = "blocks/hardened_clay";
                    downtxt = "blocks/hardened_clay";
                    break;
                }
                case "minecraft:gold_block": {
                    sidetxt = "blocks/gold_block";
                    uptxt = "blocks/gold_block";
                    downtxt = "blocks/gold_block";
                    break;
                }
                case "minecraft:ice": {
                    sidetxt = "blocks/ice";
                    uptxt = "blocks/ice";
                    downtxt = "blocks/ice";
                    break;
                }
                default: {
                    throw new IOException(String.format("modelBlockName '%s:%d' not found for block '%s' - no vanilla", this.def.modelBlockName, this.def.modelBlockMeta, this.def.blockName));
                }
            }
        }
        ModelObjectStair base = new ModelObjectStair(ambientOcclusion, isTinted);
        base.textures.bottom = downtxt;
        base.textures.top = uptxt;
        base.textures.side = base.textures.particle = sidetxt;
        this.writeBlockModelFile(this.def.blockName, base);
        ModelObjectOuterStair outer = new ModelObjectOuterStair(ambientOcclusion, isTinted);
        outer.textures.bottom = downtxt;
        outer.textures.top = uptxt;
        outer.textures.side = outer.textures.particle = sidetxt;
        this.writeBlockModelFile(this.def.blockName + "_outer", outer);
        ModelObjectInnerStair inner = new ModelObjectInnerStair(ambientOcclusion, isTinted);
        inner.textures.bottom = downtxt;
        inner.textures.top = uptxt;
        inner.textures.side = inner.textures.particle = sidetxt;
        this.writeBlockModelFile(this.def.blockName + "_inner", inner);
        ModelObject mo = new ModelObject();
        mo.parent = "westerosblocks:block/" + this.def.blockName;
        this.writeItemModelFile(this.def.blockName, mo);
        if (isTinted && (tintres = this.def.getBlockColorMapResource(this.def.subBlocks.get(0))) != null) {
            ModelExport.addTintingOverride(this.def.blockName, null, tintres);
        }
    }

    public static class ModelObject {
        public String parent;
    }

    public static class Texture {
        public String bottom;
        public String top;
        public String side;
        public String particle;
    }

    public static class ModelObjectOuterStair {
        public String parent;
        public Texture textures = new Texture();

        public ModelObjectOuterStair(boolean ambientocclusion, boolean tinted) {
            this.parent = ambientocclusion ? (tinted ? "westerosblocks:block/tinted/outer_stairs" : "block/outer_stairs") : (tinted ? "westerosblocks:block/tintednoocclusion/outer_stairs" : "westerosblocks:block/noocclusion/outer_stairs");
        }
    }

    public static class ModelObjectInnerStair {
        public String parent;
        public Texture textures = new Texture();

        public ModelObjectInnerStair(boolean ambientocclusion, boolean tinted) {
            this.parent = ambientocclusion ? (tinted ? "westerosblocks:block/tinted/inner_stairs" : "block/inner_stairs") : (tinted ? "westerosblocks:block/tintednoocclusion/inner_stairs" : "westerosblocks:block/noocclusion/inner_stairs");
        }
    }

    public static class ModelObjectStair {
        public String parent;
        public Texture textures = new Texture();

        public ModelObjectStair(boolean ambientocclusion, boolean tinted) {
            this.parent = ambientocclusion ? (tinted ? "westerosblocks:block/tinted/stairs" : "block/stairs") : (tinted ? "westerosblocks:block/tintednoocclusion/stairs" : "westerosblocks:block/noocclusion/stairs");
        }
    }

    public static class Variant {
        public String model = "";
        public Integer x;
        public Integer y;
        public Boolean uvlock;

        public Variant(String blkname) {
            this(blkname, null, 0, 0);
        }

        public Variant(String blkname, String ext, int yrot) {
            this(blkname, ext, 0, yrot);
        }

        public Variant(String blkname, String ext, int xrot, int yrot) {
            this.model = ext != null ? "westerosblocks:" + blkname + "_" + ext : "westerosblocks:" + blkname;
            if (xrot != 0) {
                this.x = xrot;
            }
            if (yrot != 0) {
                this.y = yrot;
            }
            if (xrot != 0 || yrot != 0) {
                this.uvlock = true;
            }
        }
    }

    public static class StateObject {
        public Map<String, Variant> variants = new HashMap<String, Variant>();
    }
}

