/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.modelexport;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.modelexport.ModelExport;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;

public class LogBlockModelExport
extends ModelExport {
    private WesterosBlockDef def;

    public LogBlockModelExport(Block blk, WesterosBlockDef def, File dest) {
        super(blk, def, dest);
        this.def = def;
        for (WesterosBlockDef.Subblock sb : def.subBlocks) {
            LogBlockModelExport.addNLSString("tile." + def.blockName + "_" + sb.meta + ".name", sb.label);
        }
    }

    @Override
    public void doBlockStateExport() throws IOException {
        StateObject so = new StateObject();
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            String mod;
            Variant varx = new Variant();
            Variant vary = new Variant();
            Variant varz = new Variant();
            Variant varn = new Variant();
            vary.model = varz.model = (mod = "westerosblocks:" + this.def.blockName + "_" + sb.meta);
            varx.model = varz.model;
            so.variants.put(String.format("axis=y,variant=%d", sb.meta), vary);
            varz.x = 90;
            so.variants.put(String.format("axis=z,variant=%d", sb.meta), varz);
            varx.x = 90;
            varx.y = 90;
            so.variants.put(String.format("axis=x,variant=%d", sb.meta), varx);
            varn.model = "westerosblocks:" + this.def.blockName + "_bark_" + sb.meta;
            so.variants.put(String.format("axis=none,variant=%d", sb.meta), varn);
        }
        this.writeBlockStateFile(this.def.blockName, so);
    }

    @Override
    public void doModelExports() throws IOException {
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            ModelObjectColumn mod = new ModelObjectColumn();
            mod.textures.end = LogBlockModelExport.getTextureID(sb.getTextureByIndex(0));
            mod.textures.side = LogBlockModelExport.getTextureID(sb.getTextureByIndex(1));
            this.writeBlockModelFile(this.def.blockName + "_" + sb.meta, mod);
            ModelObjectCubeAll mod2 = new ModelObjectCubeAll();
            mod2.textures.all = LogBlockModelExport.getTextureID(sb.getTextureByIndex(1));
            this.writeBlockModelFile(this.def.blockName + "_bark_" + sb.meta, mod2);
            ModelObject mo = new ModelObject();
            mo.parent = "westerosblocks:block/" + this.def.blockName + "_" + sb.meta;
            this.writeItemModelFile(this.def.blockName + "_" + sb.meta, mo);
        }
    }

    public static class ModelObject {
        public String parent;
    }

    public static class Texture {
        public String end;
        public String side;
    }

    public static class ModelObjectColumn {
        public String parent = "westerosblocks:block/untinted/cube_log";
        public Texture textures = new Texture();
    }

    public static class TextureAll {
        public String all;
    }

    public static class ModelObjectCubeAll {
        public String parent = "block/cube_all";
        public TextureAll textures = new TextureAll();
    }

    public static class Variant {
        public String model;
        public Integer x;
        public Integer y;
    }

    public static class StateObject {
        public Map<String, Variant> variants = new HashMap<String, Variant>();
    }
}

