/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.modelexport;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.blocks.WCLayerBlock;
import com.westeroscraft.westerosblocks.modelexport.ModelExport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;

public class LayerBlockModelExport
extends ModelExport {
    protected WesterosBlockDef def;
    protected WCLayerBlock blk;

    public LayerBlockModelExport(Block blk, WesterosBlockDef def, File dest) {
        super(blk, def, dest);
        this.def = def;
        this.blk = (WCLayerBlock)blk;
        LayerBlockModelExport.addNLSString("tile." + def.blockName + ".name", def.subBlocks.get((int)0).label);
    }

    @Override
    public void doBlockStateExport() throws IOException {
        StateObject so = new StateObject();
        for (int i = 0; i < this.blk.layerCount; ++i) {
            Variant var = new Variant();
            var.model = "westerosblocks:" + this.def.blockName + "_" + (i + 1);
            so.variants.put(String.format("layers=%d", i + 1), var);
        }
        this.writeBlockStateFile(this.def.blockName, so);
    }

    @Override
    public void doModelExports() throws IOException {
        String tintres;
        WesterosBlockDef.Subblock sb = this.def.subBlocks.get(0);
        boolean is_tinted = sb.isTinted(this.def);
        for (int i = 0; i < this.blk.layerCount; ++i) {
            ModelObjectCuboid mod = new ModelObjectCuboid();
            mod.textures.put("particle", LayerBlockModelExport.getTextureID(sb.getTextureByIndex(0)));
            int cnt = Math.max(6, sb.textures.size());
            for (int j = 0; j < cnt; ++j) {
                mod.textures.put("txt" + j, LayerBlockModelExport.getTextureID(sb.getTextureByIndex(j)));
            }
            float ymax = (float)(16.0 / (double)this.blk.layerCount * (double)(i + 1));
            Element elem = new Element();
            elem.from[0] = 0.0f;
            elem.from[1] = 0.0f;
            elem.from[2] = 0.0f;
            elem.to[0] = 16.0f;
            elem.to[1] = ymax;
            elem.to[2] = 16.0f;
            Face f = new Face();
            f.uv[0] = 0.0f;
            f.uv[2] = 16.0f;
            f.uv[1] = 0.0f;
            f.uv[3] = 16.0f;
            f.texture = "#txt0";
            f.cullface = "down";
            if (is_tinted) {
                f.tintindex = 0;
            }
            elem.faces.put("down", f);
            f = new Face();
            f.uv[0] = 0.0f;
            f.uv[2] = 16.0f;
            f.uv[1] = 0.0f;
            f.uv[3] = 16.0f;
            f.texture = "#txt1";
            if (elem.to[1] >= 16.0f) {
                f.cullface = "up";
            }
            if (is_tinted) {
                f.tintindex = 0;
            }
            elem.faces.put("up", f);
            f = new Face();
            f.uv[0] = 0.0f;
            f.uv[2] = 16.0f;
            f.uv[1] = 16.0f - ymax;
            f.uv[3] = 16.0f;
            f.texture = "#txt2";
            f.cullface = "north";
            if (is_tinted) {
                f.tintindex = 0;
            }
            elem.faces.put("north", f);
            f = new Face();
            f.uv[0] = 0.0f;
            f.uv[2] = 16.0f;
            f.uv[1] = 16.0f - ymax;
            f.uv[3] = 16.0f;
            f.texture = "#txt3";
            f.cullface = "south";
            if (is_tinted) {
                f.tintindex = 0;
            }
            elem.faces.put("south", f);
            f = new Face();
            f.uv[0] = 0.0f;
            f.uv[2] = 16.0f;
            f.uv[1] = 16.0f - ymax;
            f.uv[3] = 16.0f;
            f.texture = "#txt4";
            f.cullface = "west";
            if (is_tinted) {
                f.tintindex = 0;
            }
            elem.faces.put("west", f);
            f = new Face();
            f.uv[0] = 0.0f;
            f.uv[2] = 16.0f;
            f.uv[1] = 16.0f - ymax;
            f.uv[3] = 16.0f;
            f.texture = "#txt5";
            f.cullface = "east";
            if (is_tinted) {
                f.tintindex = 0;
            }
            elem.faces.put("east", f);
            mod.elements.add(elem);
            this.writeBlockModelFile(this.def.blockName + "_" + (i + 1), mod);
        }
        ModelObject mo = new ModelObject();
        mo.parent = "westerosblocks:block/" + this.def.blockName + "_1";
        this.writeItemModelFile(this.def.blockName, mo);
        if (is_tinted && (tintres = this.def.getBlockColorMapResource(sb)) != null) {
            ModelExport.addTintingOverride(this.def.blockName, null, tintres);
        }
    }

    public static class ModelObject {
        public String parent;
    }

    public static class Face {
        public float[] uv = new float[]{0.0f, 0.0f, 16.0f, 16.0f};
        public String texture;
        public Integer rotation;
        public String cullface;
        public Integer tintindex;
    }

    public static class Rotation {
        public float[] origin = new float[]{8.0f, 8.0f, 8.0f};
        public String axis = "y";
        public float angle = 45.0f;
        public Boolean rescale = true;
    }

    public static class Element {
        public float[] from = new float[]{0.0f, 0.0f, 0.0f};
        public float[] to = new float[]{16.0f, 16.0f, 16.0f};
        public Rotation rotation;
        public Boolean shade;
        public Map<String, Face> faces = new HashMap<String, Face>();
    }

    public static class ModelObjectCuboid {
        public String parent = "block/thin_block";
        public Map<String, String> textures = new HashMap<String, String>();
        public List<Element> elements = new ArrayList<Element>();
    }

    public static class Variant {
        public String model;
        public Integer x;
        public Integer y;
        public Boolean uvlock;
    }

    public static class StateObject {
        public Map<String, Variant> variants = new HashMap<String, Variant>();
    }
}

