/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.modelexport;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.modelexport.ModelExport;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;

public class LadderBlockModelExport
extends ModelExport {
    private WesterosBlockDef def;

    public LadderBlockModelExport(Block blk, WesterosBlockDef def, File dest) {
        super(blk, def, dest);
        this.def = def;
        for (WesterosBlockDef.Subblock sb : def.subBlocks) {
            LadderBlockModelExport.addNLSString("tile." + def.blockName + "_" + sb.meta + ".name", sb.label);
        }
    }

    @Override
    public void doBlockStateExport() throws IOException {
        StateObject so = new StateObject();
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            String mod;
            Variant varn = new Variant();
            Variant vars = new Variant();
            Variant vare = new Variant();
            Variant varw = new Variant();
            vare.model = varw.model = (mod = "westerosblocks:" + this.def.blockName + "_" + sb.meta);
            vars.model = varw.model;
            varn.model = varw.model;
            vare.y = 90;
            vars.y = 180;
            varw.y = 270;
            so.variants.put(String.format("facing=north,variant=%d", sb.meta), varn);
            so.variants.put(String.format("facing=east,variant=%d", sb.meta), vare);
            so.variants.put(String.format("facing=south,variant=%d", sb.meta), vars);
            so.variants.put(String.format("facing=west,variant=%d", sb.meta), varw);
        }
        this.writeBlockStateFile(this.def.blockName, so);
    }

    @Override
    public void doModelExports() throws IOException {
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            ModelObjectLadder mod = new ModelObjectLadder();
            mod.textures.ladder = LadderBlockModelExport.getTextureID(sb.getTextureByIndex(0));
            if (!sb.isCustomModel()) {
                this.writeBlockModelFile(this.def.blockName + "_" + sb.meta, mod);
            }
            ModelObject mo = new ModelObject();
            mo.parent = "westerosblocks:block/" + this.def.blockName + "_" + sb.meta;
            this.writeItemModelFile(this.def.blockName + "_" + sb.meta, mo);
        }
    }

    public static class ModelObject {
        public String parent;
    }

    public static class Texture {
        public String ladder;
    }

    public static class ModelObjectLadder {
        public String parent = "westerosblocks:block/ladder";
        public Texture textures = new Texture();
    }

    public static class Variant {
        public String model;
        public Integer x;
        public Integer y;
    }

    public static class StateObject {
        public Map<String, Variant> variants = new HashMap<String, Variant>();
    }
}

