/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.modelexport;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.modelexport.ModelExport;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;

public class HalfDoorBlockModelExport
extends ModelExport {
    private WesterosBlockDef def;

    public HalfDoorBlockModelExport(Block blk, WesterosBlockDef def, File dest) {
        super(blk, def, dest);
        this.def = def;
        HalfDoorBlockModelExport.addNLSString("tile." + def.blockName + ".name", def.subBlocks.get((int)0).label);
    }

    @Override
    public void doBlockStateExport() throws IOException {
        StateObject so = new StateObject();
        String bn = this.def.blockName;
        so.variants.put("facing=east,hinge=left,open=false", new Variant(bn));
        so.variants.put("facing=south,hinge=left,open=false", new Variant(bn, null, 90));
        so.variants.put("facing=west,hinge=left,open=false", new Variant(bn, null, 180));
        so.variants.put("facing=north,hinge=left,open=false", new Variant(bn, null, 270));
        so.variants.put("facing=east,hinge=right,open=false", new Variant(bn, "rh", 0));
        so.variants.put("facing=south,hinge=right,open=false", new Variant(bn, "rh", 90));
        so.variants.put("facing=west,hinge=right,open=false", new Variant(bn, "rh", 180));
        so.variants.put("facing=north,hinge=right,open=false", new Variant(bn, "rh", 270));
        so.variants.put("facing=east,hinge=left,open=true", new Variant(bn, "rh", 90));
        so.variants.put("facing=south,hinge=left,open=true", new Variant(bn, "rh", 180));
        so.variants.put("facing=west,hinge=left,open=true", new Variant(bn, "rh", 270));
        so.variants.put("facing=north,hinge=left,open=true", new Variant(bn, "rh", 0));
        so.variants.put("facing=east,hinge=right,open=true", new Variant(bn, null, 270));
        so.variants.put("facing=south,hinge=right,open=true", new Variant(bn));
        so.variants.put("facing=west,hinge=right,open=true", new Variant(bn, null, 90));
        so.variants.put("facing=north,hinge=right,open=true", new Variant(bn, null, 180));
        this.writeBlockStateFile(this.def.blockName, so);
    }

    @Override
    public void doModelExports() throws IOException {
        WesterosBlockDef.Subblock sb = this.def.subBlocks.get(0);
        String uptxt = HalfDoorBlockModelExport.getTextureID(sb.getTextureByIndex(0));
        ModelObjectTop top = new ModelObjectTop();
        top.textures.top = uptxt;
        top.textures.bottom = uptxt;
        this.writeBlockModelFile(this.def.blockName, top);
        ModelObjectTopRH trh = new ModelObjectTopRH();
        trh.textures.top = uptxt;
        trh.textures.bottom = uptxt;
        this.writeBlockModelFile(this.def.blockName + "_rh", trh);
        ModelObject mo = new ModelObject();
        mo.parent = "westerosblocks:block/" + this.def.blockName;
        this.writeItemModelFile(this.def.blockName, mo);
    }

    public static class ModelObject {
        public String parent;
    }

    public static class Texture {
        public String top;
        public String bottom;
    }

    public static class DisplayInst {
        public int[] rotation;
        public double[] translation;
        public double[] scale;

        public DisplayInst(int rotx, int roty, int rotz, double transy, double scale) {
            this.rotation = new int[]{rotx, roty, rotz};
            this.translation = new double[]{0.0, transy, 0.0};
            this.scale = new double[]{scale, scale, scale};
        }
    }

    public static class Display {
        public DisplayInst gui = new DisplayInst(30, 225, 0, 0.0, 0.625);
        public DisplayInst ground = new DisplayInst(0, 0, 0, 3.0, 0.25);
        public DisplayInst fixed = new DisplayInst(0, 0, 0, 0.0, 0.5);
        public DisplayInst thirdperson_righthand = new DisplayInst(75, 45, 0, 2.5, 0.375);
        public DisplayInst firstperson_righthand = new DisplayInst(0, 45, 0, 0.0, 0.4);
        public DisplayInst firstperson_lefthand = new DisplayInst(0, 225, 0, 0.0, 0.4);
    }

    public static class ModelObjectTopRH {
        public String parent = "westerosblocks:block/untinted/half_door_rh";
        public Texture textures = new Texture();
    }

    public static class ModelObjectTop {
        public String parent = "westerosblocks:block/untinted/half_door";
        public Texture textures = new Texture();
        public Display display = new Display();
    }

    public static class Variant {
        public String model = "";
        public Integer x;
        public Integer y;

        public Variant(String blkname) {
            this(blkname, null, 0);
        }

        public Variant(String blkname, String ext, int yrot) {
            this.model = ext != null ? "westerosblocks:" + blkname + "_" + ext : "westerosblocks:" + blkname;
            if (yrot != 0) {
                this.y = yrot;
            }
        }
    }

    public static class StateObject {
        public Map<String, Variant> variants = new HashMap<String, Variant>();
    }
}

