/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.modelexport;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.modelexport.ModelExport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;

public class FireBlockModelExport
extends ModelExport {
    private WesterosBlockDef def;

    public FireBlockModelExport(Block blk, WesterosBlockDef def, File dest) {
        super(blk, def, dest);
        this.def = def;
        FireBlockModelExport.addNLSString("tile." + def.blockName + ".name", def.subBlocks.get((int)0).label);
    }

    @Override
    public void doBlockStateExport() throws IOException {
        StateObject so = new StateObject();
        String bn = "westerosblocks:" + this.def.blockName;
        WhenRec whennone = new WhenRec();
        whennone.north = false;
        whennone.south = false;
        whennone.east = false;
        whennone.west = false;
        States ps = new States();
        ps.when = whennone;
        ps.apply.add(new Apply(bn, "floor0"));
        ps.apply.add(new Apply(bn, "floor1"));
        so.multipart.add(ps);
        ps = new SideStates();
        WhenRec wrec = new WhenRec();
        wrec.north = true;
        ps.when.OR.add(wrec);
        ps.apply.add(new Apply(bn, "side0"));
        ps.apply.add(new Apply(bn, "side1"));
        ps.apply.add(new Apply(bn, "side_alt0"));
        ps.apply.add(new Apply(bn, "side_alt1"));
        so.multipart.add(ps);
        ps = new SideStates();
        wrec = new WhenRec();
        wrec.east = true;
        ps.when.OR.add(wrec);
        ps.apply.add(new Apply(bn, "side0", 90));
        ps.apply.add(new Apply(bn, "side1", 90));
        ps.apply.add(new Apply(bn, "side_alt0", 90));
        ps.apply.add(new Apply(bn, "side_alt1", 90));
        so.multipart.add(ps);
        ps = new SideStates();
        wrec = new WhenRec();
        wrec.south = true;
        ps.when.OR.add(wrec);
        ps.apply.add(new Apply(bn, "side0", 180));
        ps.apply.add(new Apply(bn, "side1", 180));
        ps.apply.add(new Apply(bn, "side_alt0", 180));
        ps.apply.add(new Apply(bn, "side_alt1", 180));
        so.multipart.add(ps);
        ps = new SideStates();
        wrec = new WhenRec();
        wrec.west = true;
        ps.when.OR.add(wrec);
        ps.apply.add(new Apply(bn, "side0", 270));
        ps.apply.add(new Apply(bn, "side1", 270));
        ps.apply.add(new Apply(bn, "side_alt0", 270));
        ps.apply.add(new Apply(bn, "side_alt1", 270));
        so.multipart.add(ps);
        ps = new States();
        ps.when.up = true;
        ps.apply.add(new Apply(bn, "up0"));
        ps.apply.add(new Apply(bn, "up1"));
        ps.apply.add(new Apply(bn, "up_alt0"));
        ps.apply.add(new Apply(bn, "up_alt1"));
        so.multipart.add(ps);
        this.writeBlockStateFile(this.def.blockName, so);
    }

    @Override
    public void doModelExports() throws IOException {
        WesterosBlockDef.Subblock sb = this.def.subBlocks.get(0);
        String txt0 = FireBlockModelExport.getTextureID(sb.getTextureByIndex(0));
        String txt1 = FireBlockModelExport.getTextureID(sb.getTextureByIndex(1));
        ModelObjectFloor modf = new ModelObjectFloor();
        modf.textures.particle = modf.textures.fire = txt0;
        this.writeBlockModelFile(this.def.blockName + "_floor0", modf);
        modf = new ModelObjectFloor();
        modf.textures.particle = modf.textures.fire = txt1;
        this.writeBlockModelFile(this.def.blockName + "_floor1", modf);
        ModelObjectSide mods = new ModelObjectSide();
        mods.textures.particle = mods.textures.fire = txt0;
        this.writeBlockModelFile(this.def.blockName + "_side0", mods);
        mods = new ModelObjectSide();
        mods.textures.particle = mods.textures.fire = txt1;
        this.writeBlockModelFile(this.def.blockName + "_side1", mods);
        ModelObjectSideAlt modsa = new ModelObjectSideAlt();
        modsa.textures.particle = modsa.textures.fire = txt0;
        this.writeBlockModelFile(this.def.blockName + "_side_alt0", modsa);
        modsa = new ModelObjectSideAlt();
        modsa.textures.particle = modsa.textures.fire = txt1;
        this.writeBlockModelFile(this.def.blockName + "_side_alt1", modsa);
        ModelObjectUp modu = new ModelObjectUp();
        modu.textures.particle = modu.textures.fire = txt0;
        this.writeBlockModelFile(this.def.blockName + "_up0", modu);
        modu = new ModelObjectUp();
        modu.textures.particle = modu.textures.fire = txt1;
        this.writeBlockModelFile(this.def.blockName + "_up1", modu);
        ModelObjectUpAlt modua = new ModelObjectUpAlt();
        modua.textures.particle = modua.textures.fire = txt0;
        this.writeBlockModelFile(this.def.blockName + "_up_alt0", modsa);
        modua = new ModelObjectUpAlt();
        modua.textures.particle = modua.textures.fire = txt1;
        this.writeBlockModelFile(this.def.blockName + "_up_alt1", modsa);
        ModelObject mo = new ModelObject();
        mo.textures.layer0 = txt0;
        this.writeItemModelFile(this.def.blockName, mo);
    }

    public static class ModelObject {
        public String parent = "item/generated";
        public TextureLayer0 textures = new TextureLayer0();
    }

    public static class TextureLayer0 {
        public String layer0;
    }

    public static class Texture {
        public String particle;
        public String fire;
    }

    public static class ModelObjectUpAlt {
        public String parent = "block/fire_up_alt";
        public Texture textures = new Texture();
    }

    public static class ModelObjectUp {
        public String parent = "block/fire_up";
        public Texture textures = new Texture();
    }

    public static class ModelObjectSideAlt {
        public String parent = "block/fire_side_alt";
        public Texture textures = new Texture();
    }

    public static class ModelObjectSide {
        public String parent = "block/fire_side";
        public Texture textures = new Texture();
    }

    public static class ModelObjectFloor {
        public String parent = "block/fire_floor";
        public Texture textures = new Texture();
    }

    public static class Apply {
        String model;
        Integer y;

        public Apply(String bn, String ext) {
            this(bn, ext, 0);
        }

        public Apply(String bn, String ext, int y) {
            this.model = bn;
            if (ext != null) {
                this.model = this.model + "_" + ext;
            }
            if (y != 0) {
                this.y = y;
            }
        }
    }

    public static class WhenRec {
        Boolean north;
        Boolean south;
        Boolean west;
        Boolean east;
        Boolean up;
        public List<WhenRec> OR;
    }

    public static class SideStates
    extends States {
        SideStates() {
            this.when.OR = new ArrayList<WhenRec>();
            WhenRec wr = new WhenRec();
            wr.east = wr.west = Boolean.FALSE;
            wr.south = wr.west;
            wr.north = wr.west;
            this.when.OR.add(wr);
        }
    }

    public static class States {
        public WhenRec when = new WhenRec();
        public List<Apply> apply = new ArrayList<Apply>();
    }

    public static class StateObject {
        public List<States> multipart = new ArrayList<States>();
    }
}

