/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.modelexport;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.modelexport.ModelExport;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;

public class DoorBlockModelExport
extends ModelExport {
    private WesterosBlockDef def;

    public DoorBlockModelExport(Block blk, WesterosBlockDef def, File dest) {
        super(blk, def, dest);
        this.def = def;
        DoorBlockModelExport.addNLSString("tile." + def.blockName + ".name", def.subBlocks.get((int)0).label);
    }

    @Override
    public void doBlockStateExport() throws IOException {
        StateObject so = new StateObject();
        String bn = this.def.blockName;
        so.variants.put("facing=east,half=lower,hinge=left,open=false", new Variant(bn, "bottom"));
        so.variants.put("facing=south,half=lower,hinge=left,open=false", new Variant(bn, "bottom", 90));
        so.variants.put("facing=west,half=lower,hinge=left,open=false", new Variant(bn, "bottom", 180));
        so.variants.put("facing=north,half=lower,hinge=left,open=false", new Variant(bn, "bottom", 270));
        so.variants.put("facing=east,half=lower,hinge=right,open=false", new Variant(bn, "bottom_rh"));
        so.variants.put("facing=south,half=lower,hinge=right,open=false", new Variant(bn, "bottom_rh", 90));
        so.variants.put("facing=west,half=lower,hinge=right,open=false", new Variant(bn, "bottom_rh", 180));
        so.variants.put("facing=north,half=lower,hinge=right,open=false", new Variant(bn, "bottom_rh", 270));
        so.variants.put("facing=east,half=lower,hinge=left,open=true", new Variant(bn, "bottom_rh", 90));
        so.variants.put("facing=south,half=lower,hinge=left,open=true", new Variant(bn, "bottom_rh", 180));
        so.variants.put("facing=west,half=lower,hinge=left,open=true", new Variant(bn, "bottom_rh", 270));
        so.variants.put("facing=north,half=lower,hinge=left,open=true", new Variant(bn, "bottom_rh"));
        so.variants.put("facing=east,half=lower,hinge=right,open=true", new Variant(bn, "bottom", 270));
        so.variants.put("facing=south,half=lower,hinge=right,open=true", new Variant(bn, "bottom"));
        so.variants.put("facing=west,half=lower,hinge=right,open=true", new Variant(bn, "bottom", 90));
        so.variants.put("facing=north,half=lower,hinge=right,open=true", new Variant(bn, "bottom", 180));
        so.variants.put("facing=east,half=upper,hinge=left,open=false", new Variant(bn, "top"));
        so.variants.put("facing=south,half=upper,hinge=left,open=false", new Variant(bn, "top", 90));
        so.variants.put("facing=west,half=upper,hinge=left,open=false", new Variant(bn, "top", 180));
        so.variants.put("facing=north,half=upper,hinge=left,open=false", new Variant(bn, "top", 270));
        so.variants.put("facing=east,half=upper,hinge=right,open=false", new Variant(bn, "top_rh"));
        so.variants.put("facing=south,half=upper,hinge=right,open=false", new Variant(bn, "top_rh", 90));
        so.variants.put("facing=west,half=upper,hinge=right,open=false", new Variant(bn, "top_rh", 180));
        so.variants.put("facing=north,half=upper,hinge=right,open=false", new Variant(bn, "top_rh", 270));
        so.variants.put("facing=east,half=upper,hinge=left,open=true", new Variant(bn, "top_rh", 90));
        so.variants.put("facing=south,half=upper,hinge=left,open=true", new Variant(bn, "top_rh", 180));
        so.variants.put("facing=west,half=upper,hinge=left,open=true", new Variant(bn, "top_rh", 270));
        so.variants.put("facing=north,half=upper,hinge=left,open=true", new Variant(bn, "top_rh"));
        so.variants.put("facing=east,half=upper,hinge=right,open=true", new Variant(bn, "top", 270));
        so.variants.put("facing=south,half=upper,hinge=right,open=true", new Variant(bn, "top"));
        so.variants.put("facing=west,half=upper,hinge=right,open=true", new Variant(bn, "top", 90));
        so.variants.put("facing=north,half=upper,hinge=right,open=true", new Variant(bn, "top", 180));
        this.writeBlockStateFile(this.def.blockName, so);
    }

    @Override
    public void doModelExports() throws IOException {
        WesterosBlockDef.Subblock sb = this.def.subBlocks.get(0);
        String downtxt = DoorBlockModelExport.getTextureID(sb.getTextureByIndex(1));
        String uptxt = DoorBlockModelExport.getTextureID(sb.getTextureByIndex(0));
        ModelObjectBottom bot = new ModelObjectBottom();
        bot.textures.bottom = downtxt;
        bot.textures.top = uptxt;
        this.writeBlockModelFile(this.def.blockName + "_bottom", bot);
        ModelObjectBottomRH brh = new ModelObjectBottomRH();
        brh.textures.bottom = downtxt;
        brh.textures.top = uptxt;
        this.writeBlockModelFile(this.def.blockName + "_bottom_rh", brh);
        ModelObjectTop top = new ModelObjectTop();
        top.textures.bottom = downtxt;
        top.textures.top = uptxt;
        this.writeBlockModelFile(this.def.blockName + "_top", top);
        ModelObjectTopRH trh = new ModelObjectTopRH();
        trh.textures.bottom = downtxt;
        trh.textures.top = uptxt;
        this.writeBlockModelFile(this.def.blockName + "_top_rh", trh);
        ModelObject mo = new ModelObject();
        mo.textures.layer0 = uptxt;
        this.writeItemModelFile(this.def.blockName, mo);
    }

    public static class ModelObject {
        public String parent = "item/generated";
        public TextureLayer0 textures = new TextureLayer0();
    }

    public static class TextureLayer0 {
        public String layer0;
    }

    public static class Texture {
        public String bottom;
        public String top;
    }

    public static class ModelObjectTopRH {
        public String parent = "block/door_top_rh";
        public Texture textures = new Texture();
    }

    public static class ModelObjectTop {
        public String parent = "block/door_top";
        public Texture textures = new Texture();
    }

    public static class ModelObjectBottomRH {
        public String parent = "block/door_bottom_rh";
        public Texture textures = new Texture();
    }

    public static class ModelObjectBottom {
        public String parent = "block/door_bottom";
        public Texture textures = new Texture();
    }

    public static class Variant {
        public String model = "";
        public Integer x;
        public Integer y;

        public Variant(String blkname, String ext) {
            this(blkname, ext, 0, 0);
        }

        public Variant(String blkname, String ext, int yrot) {
            this(blkname, ext, 0, yrot);
        }

        public Variant(String blkname, String ext, int xrot, int yrot) {
            this.model = "westerosblocks:" + blkname + "_" + ext;
            if (xrot != 0) {
                this.x = xrot;
            }
            if (yrot != 0) {
                this.y = yrot;
            }
        }
    }

    public static class StateObject {
        public Map<String, Variant> variants = new HashMap<String, Variant>();
    }
}

