/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.modelexport;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.blocks.WCCuboidBlock;
import com.westeroscraft.westerosblocks.modelexport.ModelExport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;

public class CuboidBlockModelExport
extends ModelExport {
    protected WesterosBlockDef def;
    protected WCCuboidBlock blk;
    private static final int[] STDTXTIDX = new int[]{0, 1, 2, 3, 4, 5};

    public CuboidBlockModelExport(Block blk, WesterosBlockDef def, File dest) {
        super(blk, def, dest);
        this.def = def;
        this.blk = (WCCuboidBlock)blk;
        for (WesterosBlockDef.Subblock sb : def.subBlocks) {
            CuboidBlockModelExport.addNLSString("tile." + def.blockName + "_" + sb.meta + ".name", sb.label);
        }
    }

    @Override
    public void doBlockStateExport() throws IOException {
        StateObject so = new StateObject();
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            Variant var = new Variant();
            var.model = "westerosblocks:" + this.def.blockName + "_" + sb.meta;
            so.variants.put(String.format("variant=%d", sb.meta), var);
        }
        this.writeBlockStateFile(this.def.blockName, so);
    }

    private static float getClamped(float v) {
        if ((v = 16.0f * v) < -16.0f) {
            v = -16.0f;
        }
        if (v > 32.0f) {
            v = 32.0f;
        }
        return v;
    }

    private static void processRotation(Face f) {
        if (f.rotation != null && (f.rotation == 90 || f.rotation == 270)) {
            float vt = f.uv[1];
            f.uv[1] = f.uv[0];
            f.uv[0] = vt;
            vt = f.uv[3];
            f.uv[3] = f.uv[2];
            f.uv[2] = vt;
        }
    }

    protected void doCuboidModel(WesterosBlockDef.Subblock sb, int meta, int modelmeta, String name, boolean isTinted) throws IOException {
        ModelObjectCuboid mod = new ModelObjectCuboid();
        mod.textures.put("particle", CuboidBlockModelExport.getTextureID(sb.getTextureByIndex(0)));
        int cnt = Math.max(6, sb.textures.size());
        for (int i = 0; i < cnt; ++i) {
            mod.textures.put("txt" + i, CuboidBlockModelExport.getTextureID(sb.getTextureByIndex(i)));
        }
        List<WesterosBlockDef.Cuboid> cubs = this.blk.getCuboidList(modelmeta);
        for (WesterosBlockDef.Cuboid c : cubs) {
            Face f;
            Element elem;
            int[] siderot;
            int[] sidetxt = c.sideTextures;
            if (sidetxt == null) {
                sidetxt = STDTXTIDX;
            }
            if ((siderot = c.sideRotations) == null) {
                siderot = new int[]{0, 0, 0, 0, 0, 0};
            }
            float xmin = CuboidBlockModelExport.getClamped(c.xMin);
            float ymin = CuboidBlockModelExport.getClamped(c.yMin);
            float zmin = CuboidBlockModelExport.getClamped(c.zMin);
            float xmax = CuboidBlockModelExport.getClamped(c.xMax);
            float ymax = CuboidBlockModelExport.getClamped(c.yMax);
            float zmax = CuboidBlockModelExport.getClamped(c.zMax);
            if ("crossed".equals(c.shape)) {
                mod.ambientocclusion = false;
                elem = new Element();
                elem.from[0] = xmin;
                elem.from[1] = ymin;
                elem.from[2] = 8.0f;
                elem.from[0] = xmax;
                elem.from[1] = ymax;
                elem.from[2] = 8.0f;
                elem.rotation = new Rotation();
                elem.shade = false;
                f = new Face();
                f.uv = new float[]{0.0f, 0.0f, 16.0f, 16.0f};
                f.texture = "#txt0";
                if (isTinted) {
                    f.tintindex = 0;
                }
                elem.faces.put("north", f);
                elem.faces.put("south", f);
                mod.elements.add(elem);
                elem = new Element();
                elem.from[0] = 8.0f;
                elem.from[1] = ymin;
                elem.from[2] = zmin;
                elem.from[0] = 8.0f;
                elem.from[1] = ymax;
                elem.from[2] = zmax;
                elem.rotation = new Rotation();
                elem.shade = false;
                f = new Face();
                f.uv = new float[]{0.0f, 0.0f, 16.0f, 16.0f};
                f.texture = "#txt0";
                if (isTinted) {
                    f.tintindex = 0;
                }
                elem.faces.put("west", f);
                elem.faces.put("east", f);
                mod.elements.add(elem);
                continue;
            }
            elem = new Element();
            elem.from[0] = xmin;
            elem.from[1] = ymin;
            elem.from[2] = zmin;
            elem.to[0] = xmax;
            elem.to[1] = ymax;
            elem.to[2] = zmax;
            f = new Face();
            f.uv[0] = xmin;
            f.uv[2] = xmax;
            f.uv[1] = 16.0f - zmax;
            f.uv[3] = 16.0f - zmin;
            f.texture = "#txt" + sidetxt[0];
            f.rotation = siderot[0] != 0 ? Integer.valueOf(siderot[0]) : null;
            CuboidBlockModelExport.processRotation(f);
            if (isTinted) {
                f.tintindex = 0;
            }
            if (elem.from[1] <= 0.0f) {
                f.cullface = "down";
            }
            elem.faces.put("down", f);
            f = new Face();
            f.uv[0] = xmin;
            f.uv[2] = xmax;
            f.uv[1] = zmin;
            f.uv[3] = zmax;
            f.texture = "#txt" + sidetxt[1];
            f.rotation = siderot[1] != 0 ? Integer.valueOf(siderot[1]) : null;
            CuboidBlockModelExport.processRotation(f);
            if (isTinted) {
                f.tintindex = 0;
            }
            if (elem.to[1] >= 16.0f) {
                f.cullface = "up";
            }
            elem.faces.put("up", f);
            f = new Face();
            f.uv[0] = 16.0f - xmax;
            f.uv[2] = 16.0f - xmin;
            f.uv[1] = 16.0f - ymax;
            f.uv[3] = 16.0f - ymin;
            f.texture = "#txt" + sidetxt[2];
            f.rotation = siderot[2] != 0 ? Integer.valueOf(siderot[2]) : null;
            CuboidBlockModelExport.processRotation(f);
            if (isTinted) {
                f.tintindex = 0;
            }
            if (elem.from[2] <= 0.0f) {
                f.cullface = "north";
            }
            elem.faces.put("north", f);
            f = new Face();
            f.uv[0] = xmin;
            f.uv[2] = xmax;
            f.uv[1] = 16.0f - ymax;
            f.uv[3] = 16.0f - ymin;
            f.texture = "#txt" + sidetxt[3];
            f.rotation = siderot[3] != 0 ? Integer.valueOf(siderot[3]) : null;
            CuboidBlockModelExport.processRotation(f);
            if (isTinted) {
                f.tintindex = 0;
            }
            if (elem.to[2] >= 16.0f) {
                f.cullface = "south";
            }
            elem.faces.put("south", f);
            f = new Face();
            f.uv[0] = zmin;
            f.uv[2] = zmax;
            f.uv[1] = 16.0f - ymax;
            f.uv[3] = 16.0f - ymin;
            f.texture = "#txt" + sidetxt[4];
            f.rotation = siderot[4] != 0 ? Integer.valueOf(siderot[4]) : null;
            CuboidBlockModelExport.processRotation(f);
            if (isTinted) {
                f.tintindex = 0;
            }
            if (elem.from[0] <= 0.0f) {
                f.cullface = "west";
            }
            elem.faces.put("west", f);
            f = new Face();
            f.uv[0] = 16.0f - zmax;
            f.uv[2] = 16.0f - zmin;
            f.uv[1] = 16.0f - ymax;
            f.uv[3] = 16.0f - ymin;
            f.texture = "#txt" + sidetxt[5];
            f.rotation = siderot[5] != 0 ? Integer.valueOf(siderot[5]) : null;
            CuboidBlockModelExport.processRotation(f);
            if (isTinted) {
                f.tintindex = 0;
            }
            if (elem.to[0] >= 16.0f) {
                f.cullface = "east";
            }
            elem.faces.put("east", f);
            mod.elements.add(elem);
        }
        this.writeBlockModelFile(name + "_" + meta, mod);
    }

    @Override
    public void doModelExports() throws IOException {
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            String tintres;
            boolean isTinted = sb.isTinted(this.def);
            if (!sb.isCustomModel()) {
                this.doCuboidModel(sb, sb.meta, sb.meta, this.def.blockName, isTinted);
            }
            ModelObject mo = new ModelObject();
            mo.parent = "westerosblocks:block/" + this.def.blockName + "_" + sb.meta;
            this.writeItemModelFile(this.def.blockName + "_" + sb.meta, mo);
            if (!isTinted || (tintres = this.def.getBlockColorMapResource(sb)) == null) continue;
            ModelExport.addTintingOverride(this.def.blockName, String.format("variant=%s", sb.meta), tintres);
        }
    }

    public static class ModelObject {
        public String parent;
    }

    public static class Face {
        public float[] uv = new float[]{0.0f, 0.0f, 16.0f, 16.0f};
        public String texture;
        public Integer rotation;
        public String cullface;
        public Integer tintindex;
    }

    public static class Rotation {
        public float[] origin = new float[]{8.0f, 8.0f, 8.0f};
        public String axis = "y";
        public float angle = 45.0f;
        public Boolean rescale = true;
    }

    public static class Element {
        public float[] from = new float[]{0.0f, 0.0f, 0.0f};
        public float[] to = new float[]{16.0f, 16.0f, 16.0f};
        public Rotation rotation;
        public Boolean shade;
        public Map<String, Face> faces = new HashMap<String, Face>();
    }

    public static class Display {
        public int[] rotation = new int[]{0, 90, 0};
        public int[] translation = new int[]{0, 0, 0};
        public double[] scale = new double[]{0.5, 0.5, 0.5};
    }

    public static class ModelObjectCuboid {
        public String parent = "block/block";
        public Boolean ambientocclusion;
        public Display display = new Display();
        public Map<String, String> textures = new HashMap<String, String>();
        public List<Element> elements = new ArrayList<Element>();
    }

    public static class Variant {
        public String model;
        public Integer x;
        public Integer y;
        public Boolean uvlock;
    }

    public static class StateObject {
        public Map<String, Variant> variants = new HashMap<String, Variant>();
    }
}

