/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.modelexport;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.modelexport.ModelExport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;

public class CakeBlockModelExport
extends ModelExport {
    protected WesterosBlockDef def;

    public CakeBlockModelExport(Block blk, WesterosBlockDef def, File dest) {
        super(blk, def, dest);
        this.def = def;
        CakeBlockModelExport.addNLSString("tile." + def.blockName + ".name", def.subBlocks.get((int)0).label);
    }

    @Override
    public void doBlockStateExport() throws IOException {
        StateObject so = new StateObject();
        for (int i = 0; i < 7; ++i) {
            Variant var = new Variant();
            var.model = i == 0 ? "westerosblocks:" + this.def.blockName + "_uneaten" : "westerosblocks:" + this.def.blockName + "_slice" + i;
            so.variants.put(String.format("bites=%d", i), var);
        }
        this.writeBlockStateFile(this.def.blockName, so);
    }

    @Override
    public void doModelExports() throws IOException {
        WesterosBlockDef.Subblock sb = this.def.subBlocks.get(0);
        String bottxt = CakeBlockModelExport.getTextureID(sb.getTextureByIndex(0));
        String toptxt = CakeBlockModelExport.getTextureID(sb.getTextureByIndex(1));
        String sidetxt = CakeBlockModelExport.getTextureID(sb.getTextureByIndex(2));
        String insidetxt = CakeBlockModelExport.getTextureID(sb.getTextureByIndex(3));
        for (int i = 0; i < 7; ++i) {
            ModelObjectCake mod = new ModelObjectCake();
            mod.textures.particle = sidetxt;
            mod.textures.bottom = bottxt;
            mod.textures.top = toptxt;
            mod.textures.side = sidetxt;
            mod.textures.inside = insidetxt;
            int xmin = 1 + 2 * i;
            Element elem = new Element();
            elem.from[0] = xmin;
            Face f = new Face();
            f.texture = "#bottom";
            f.cullface = "down";
            elem.faces.put("down", f);
            f = new Face();
            f.texture = "#top";
            elem.faces.put("up", f);
            f = new Face();
            f.texture = "#side";
            elem.faces.put("north", f);
            f = new Face();
            f.texture = "#side";
            elem.faces.put("south", f);
            f = new Face();
            f.texture = i == 0 ? "#side" : "#inside";
            elem.faces.put("west", f);
            f = new Face();
            f.texture = "#side";
            elem.faces.put("east", f);
            mod.elements.add(elem);
            if (i == 0) {
                this.writeBlockModelFile(this.def.blockName + "_uneaten", mod);
                continue;
            }
            this.writeBlockModelFile(this.def.blockName + "_slice" + i, mod);
        }
        ModelObject mo = new ModelObject();
        mo.parent = "westerosblocks:block/" + this.def.blockName + "_uneaten";
        this.writeItemModelFile(this.def.blockName, mo);
    }

    public static class ModelObject {
        public String parent;
    }

    public static class Face {
        public String texture;
        public String cullface;
    }

    public static class Element {
        public float[] from = new float[]{1.0f, 0.0f, 1.0f};
        public float[] to = new float[]{15.0f, 8.0f, 15.0f};
        public Map<String, Face> faces = new HashMap<String, Face>();
    }

    public static class Texture {
        public String particle;
        public String bottom;
        public String top;
        public String side;
        public String inside;
    }

    public static class ModelObjectCake {
        public String parent = "block/thin_block";
        public Texture textures = new Texture();
        public List<Element> elements = new ArrayList<Element>();
    }

    public static class Variant {
        public String model;
        public Integer x;
        public Integer y;
        public Boolean uvlock;
    }

    public static class StateObject {
        public Map<String, Variant> variants = new HashMap<String, Variant>();
    }
}

