/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockDynmapSupport;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.WesterosBlocks;
import com.westeroscraft.westerosblocks.blocks.WCSolidBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dynmap.modsupport.CopyBlockTextureRecord;
import org.dynmap.modsupport.ModModelDefinition;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.TransparencyMode;

public class WCStairBlock
extends BlockStairs
implements WesterosBlockLifecycle,
WesterosBlockDynmapSupport {
    private WesterosBlockDef def;

    protected WCStairBlock(WesterosBlockDef def, IBlockState bs) {
        super(bs);
        this.def = def;
        if (def.lightOpacity == -999) {
            def.lightOpacity = 255;
        }
        this.func_149647_a(def.getCreativeTab());
        this.func_149663_c(def.blockName);
        this.setRegistryName(def.blockName);
        this.func_149672_a(bs.func_177230_c().getSoundType(bs, null, null, null));
        this.field_149783_u = true;
    }

    @Override
    public boolean initializeBlockDefinition() {
        this.def.doStandardInitializeActions((Block)this);
        return true;
    }

    @Override
    public boolean registerBlockDefinition() {
        this.def.doStandardRegisterActions((Block)this, ItemBlock.class);
        return true;
    }

    @Override
    public WesterosBlockDef getWBDefinition() {
        return this.def;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFireSpreadSpeed(world, pos, face);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFlammability(world, pos, face);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightValue(state, world, pos);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightOpacity(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rnd) {
        this.def.randomDisplayTick(stateIn, worldIn, pos, rnd);
        super.func_180655_c(stateIn, worldIn, pos, rnd);
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.def.nonOpaque) {
            return false;
        }
        return super.doesSideBlockRendering(state, world, pos, face);
    }

    @Override
    public void registerDynmapRenderData(ModTextureDefinition mtd) {
        ModModelDefinition md = mtd.getModelDefinition();
        String blkname = this.def.getBlockName(0);
        String modblkname = this.def.modelBlockName;
        CopyBlockTextureRecord btr = mtd.addCopyBlockTextureRecord(blkname, modblkname, this.def.modelBlockMeta);
        btr.setTransparencyMode(TransparencyMode.SEMITRANSPARENT);
        md.addStairModel(blkname);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return this.def.colorMultiplier();
    }

    @Override
    public IProperty<?>[] getNonRenderingProperties() {
        return null;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, 0);
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public Material func_149688_o(IBlockState blockState) {
        Block modelBlock = WesterosBlocks.findBlockByName(this.def.modelBlockName);
        if (modelBlock instanceof WCSolidBlock) {
            WCSolidBlock modelWCSolidBlock = (WCSolidBlock)modelBlock;
            return modelWCSolidBlock.getMaterial(this.def.modelBlockMeta);
        }
        return Material.field_151576_e;
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            if (def.modelBlockName == null || def.modelBlockMeta < 0) {
                WesterosBlocks.log.error("Type 'stair' requires modelBlockName and modelBlockMeta settings");
                return null;
            }
            Block blk = WesterosBlocks.findBlockByName(def.modelBlockName);
            if (blk == null) {
                WesterosBlocks.log.error(String.format("modelBlockName '%s' not found for block '%s'", def.modelBlockName, def.blockName));
                return null;
            }
            IBlockState bs = blk.func_176203_a(def.modelBlockMeta);
            if (bs == null) {
                WesterosBlocks.log.error(String.format("modelBlockMeta '%d' not found for block '%s'", def.modelBlockMeta, def.blockName));
                return null;
            }
            def.setMetaMask(0);
            if (!def.validateMetaValues(new int[]{0}, new int[]{0})) {
                return null;
            }
            return new Block[]{new WCStairBlock(def, bs)};
        }
    }
}

