/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlocks;
import com.westeroscraft.westerosblocks.blocks.WCSolidBlock;
import com.westeroscraft.westerosblocks.properties.PropertyMeta;
import com.westeroscraft.westerosblocks.tileentity.WCTileEntitySound;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WCSoundBlock
extends WCSolidBlock
implements ITileEntityProvider {
    public int[] def_period_by_meta = new int[16];
    public int[] def_addition_by_meta = new int[16];
    public int[] def_starttime_by_meta = new int[16];
    public int[] def_endtime_by_meta = new int[16];

    protected WCSoundBlock(WesterosBlockDef def) {
        super(def);
        for (int i = 0; i < 16; ++i) {
            String[] toks;
            String type = def.getType(i);
            if (type == null) continue;
            for (String tok : toks = type.split(",")) {
                String[] flds = tok.split(":");
                if (flds.length < 2) continue;
                if (flds[0].equals("period")) {
                    this.def_period_by_meta[i] = (int)Math.round(20.0 * Double.parseDouble(flds[1]));
                    continue;
                }
                if (flds[0].equals("random-add")) {
                    this.def_addition_by_meta[i] = (int)Math.round(20.0 * Double.parseDouble(flds[1]));
                    continue;
                }
                if (flds[0].equals("start-time")) {
                    this.def_starttime_by_meta[i] = (Integer.parseInt(flds[1]) * 10 + 18000) % 24000;
                    continue;
                }
                if (flds[0].equals("end-time")) {
                    this.def_endtime_by_meta[i] = (Integer.parseInt(flds[1]) * 10 + 18000) % 24000;
                    continue;
                }
                WesterosBlocks.log.warn("Invalid type attribute '" + flds[0] + "' in " + def.blockName + "[" + i + "]");
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean flag = world.func_175640_z(pos);
        WCTileEntitySound tileentity = (WCTileEntitySound)world.func_175625_s(pos);
        if (tileentity != null && tileentity.previousRedstoneState != flag) {
            if (flag) {
                tileentity.triggerSound(this, world, pos);
            }
            tileentity.previousRedstoneState = flag;
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        WCTileEntitySound tileentity = (WCTileEntitySound)world.func_175625_s(pos);
        if (tileentity != null) {
            tileentity.changeSoundSelection(this, state.func_177230_c().func_176201_c(state));
            tileentity.triggerSound(this, world, pos);
        }
        return true;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        WCTileEntitySound tileentity;
        if (!world.field_72995_K && (tileentity = (WCTileEntitySound)world.func_175625_s(pos)) != null) {
            tileentity.triggerSound(this, world, pos);
        }
    }

    public TileEntity func_149915_a(World par1World, int xxx) {
        return new WCTileEntitySound();
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int eventID, int eventParm) {
        if (eventID != 0) {
            return true;
        }
        int soundIndex = eventParm;
        int meta = this.func_176201_c(state);
        List<String> sndids = this.getWBDefinition().getSoundIDList(meta);
        String sndid = null;
        if (sndids != null && sndids.size() > soundIndex) {
            sndid = sndids.get(soundIndex);
        }
        if (sndid != null) {
            SoundEvent se = WCSoundBlock.getSound(sndid);
            if (se == null) {
                WesterosBlocks.log.warn("Unable to find sound " + sndid);
            } else {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, se, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
            }
        }
        return true;
    }

    private static SoundEvent getSound(String sndid) {
        ResourceLocation rl;
        SoundEvent se;
        int cidx = sndid.indexOf(58);
        String modid = "westerosblocks";
        if (cidx >= 0) {
            modid = sndid.substring(0, cidx);
            sndid = sndid.substring(cidx + 1);
        }
        if ((se = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)(rl = new ResourceLocation(modid, sndid)))) == null) {
            SoundEvent.func_187502_a((String)rl.toString());
            se = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)rl);
        }
        return se;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            if (!def.validateMetaValues(null, null)) {
                return null;
            }
            WCSolidBlock.new_variant = PropertyMeta.create("variant", def.getDefinedBaseMeta());
            def.registerTileEntity(WCTileEntitySound.class, "westerosblocks:WCTileEntitySound");
            return new Block[]{new WCSoundBlock(def)};
        }
    }
}

