/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockDynmapSupport;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRail;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dynmap.modsupport.BlockTextureRecord;
import org.dynmap.modsupport.ModModelDefinition;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.PatchBlockModel;
import org.dynmap.modsupport.TextureModifier;
import org.dynmap.modsupport.TransparencyMode;
import org.dynmap.renderer.RenderPatchFactory;

public class WCRailBlock
extends BlockRail
implements WesterosBlockLifecycle,
WesterosBlockDynmapSupport {
    private WesterosBlockDef def;

    protected WCRailBlock(WesterosBlockDef def) {
        this.def = def;
        def.doStandardContructorSettings((Block)this);
    }

    @Override
    public boolean initializeBlockDefinition() {
        this.def.doStandardInitializeActions((Block)this);
        return true;
    }

    @Override
    public boolean registerBlockDefinition() {
        this.def.doStandardRegisterActions((Block)this, ItemBlock.class);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        this.def.getStandardCreativeItems((Block)this, tab, list);
    }

    @Override
    public WesterosBlockDef getWBDefinition() {
        return this.def;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFireSpreadSpeed(world, pos, face);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFlammability(world, pos, face);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightValue(state, world, pos);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightOpacity(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.def.alphaRender ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rnd) {
        this.def.randomDisplayTick(stateIn, worldIn, pos, rnd);
        super.func_180655_c(stateIn, worldIn, pos, rnd);
    }

    @Override
    public void registerDynmapRenderData(ModTextureDefinition mtd) {
        ModModelDefinition md = mtd.getModelDefinition();
        String blkname = this.def.getBlockName(0);
        this.def.defaultRegisterTextures(mtd);
        WesterosBlockDef def = this.getWBDefinition();
        WesterosBlockDef.Subblock sb = def.getByMeta(0);
        if (sb != null && sb.textures != null) {
            int meta;
            TextureModifier tmod = TextureModifier.NONE;
            if (def.nonOpaque) {
                tmod = TextureModifier.CLEARINSIDE;
            }
            BlockTextureRecord mtr = mtd.addBlockTextureRecord(blkname);
            mtr.setTransparencyMode(TransparencyMode.TRANSPARENT);
            for (meta = 0; meta < 6; ++meta) {
                mtr.setMetaValue(meta);
            }
            for (meta = 10; meta < 14; ++meta) {
                mtr.setMetaValue(meta);
            }
            int fidx = 0;
            if (fidx >= sb.textures.size()) {
                fidx = sb.textures.size() - 1;
            }
            String txtid = sb.textures.get(fidx);
            mtr.setPatchTexture(txtid.replace(':', '_'), tmod, 0);
            mtr = mtd.addBlockTextureRecord(blkname);
            mtr.setTransparencyMode(TransparencyMode.TRANSPARENT);
            for (int meta2 = 6; meta2 < 10; ++meta2) {
                mtr.setMetaValue(meta2);
            }
            fidx = 1;
            if (fidx >= sb.textures.size()) {
                fidx = sb.textures.size() - 1;
            }
            txtid = sb.textures.get(fidx);
            mtr.setPatchTexture(txtid.replace(':', '_'), tmod, 0);
            def.setBlockColorMap(mtr, sb);
        }
        PatchBlockModel mod = md.addPatchModel(blkname);
        String patchFlat = mod.addPatch(0.0, 0.01, 0.0, 1.0, 0.01, 0.0, 0.0, 0.01, 1.0, RenderPatchFactory.SideVisible.BOTH);
        mod.setMetaValue(0);
        mod.setMetaValue(9);
        PatchBlockModel mod90 = md.addPatchModel(blkname);
        mod90.addRotatedPatch(patchFlat, 0, 90, 0);
        mod90.setMetaValue(1);
        mod90.setMetaValue(6);
        PatchBlockModel mod180 = md.addPatchModel(blkname);
        mod180.addRotatedPatch(patchFlat, 0, 180, 0);
        mod180.setMetaValue(7);
        PatchBlockModel mod270 = md.addPatchModel(blkname);
        mod270.addRotatedPatch(patchFlat, 0, 270, 0);
        mod270.setMetaValue(8);
        PatchBlockModel modS0 = md.addPatchModel(blkname);
        String patchSlope = mod.addPatch(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, RenderPatchFactory.SideVisible.BOTH);
        modS0.setMetaValue(2);
        modS0.setMetaValue(10);
        PatchBlockModel modS90 = md.addPatchModel(blkname);
        modS90.addRotatedPatch(patchSlope, 0, 90, 0);
        modS90.setMetaValue(5);
        modS90.setMetaValue(13);
        PatchBlockModel modS180 = md.addPatchModel(blkname);
        modS180.addRotatedPatch(patchSlope, 0, 180, 0);
        modS180.setMetaValue(3);
        modS180.setMetaValue(11);
        PatchBlockModel modS270 = md.addPatchModel(blkname);
        modS270.addRotatedPatch(patchSlope, 0, 270, 0);
        modS270.setMetaValue(4);
        modS270.setMetaValue(12);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return this.def.colorMultiplier();
    }

    @Override
    public IProperty<?>[] getNonRenderingProperties() {
        return null;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            this.func_189541_b(state, worldIn, pos, blockIn);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, 0);
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            def.setMetaMask(0);
            if (!def.validateMetaValues(new int[]{0}, new int[]{0})) {
                return null;
            }
            return new Block[]{new WCRailBlock(def)};
        }
    }
}

