/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockDynmapSupport;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.items.MultiBlockItem;
import com.westeroscraft.westerosblocks.properties.PropertyMeta;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dynmap.modsupport.BlockSide;
import org.dynmap.modsupport.BlockTextureRecord;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.TextureModifier;

public class WCLogBlock
extends BlockLog
implements WesterosBlockLifecycle,
WesterosBlockDynmapSupport {
    private static PropertyMeta new_variant = null;
    private WesterosBlockDef def;
    private boolean isSolidOpaque = true;
    private PropertyMeta variant;
    private static BlockLog.EnumAxis[] orientation = new BlockLog.EnumAxis[]{BlockLog.EnumAxis.Y, BlockLog.EnumAxis.X, BlockLog.EnumAxis.Z, BlockLog.EnumAxis.NONE};

    protected WCLogBlock(WesterosBlockDef def) {
        this.isSolidOpaque = !def.nonOpaque;
        this.def = def;
        def.doStandardContructorSettings((Block)this);
        this.func_149672_a(def.getSoundType());
    }

    @Override
    public boolean initializeBlockDefinition() {
        this.def.doStandardInitializeActions((Block)this);
        return true;
    }

    @Override
    public boolean registerBlockDefinition() {
        this.def.doStandardRegisterActions((Block)this, MultiBlockItem.class);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        this.def.getStandardCreativeItems((Block)this, tab, list);
    }

    @Override
    public WesterosBlockDef getWBDefinition() {
        return this.def;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFireSpreadSpeed(world, pos, face);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFlammability(world, pos, face);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightValue(state, world, pos);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightOpacity(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.def.alphaRender ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.SOLID;
    }

    public boolean func_149662_c(IBlockState state) {
        return this.isSolidOpaque;
    }

    @Override
    public void registerDynmapRenderData(ModTextureDefinition mtd) {
        this.def.defaultRegisterTextures(mtd);
        String blkname = this.def.getBlockName(0);
        TextureModifier[][] tmod = new TextureModifier[][]{{TextureModifier.ROT90, TextureModifier.ROT270, TextureModifier.NONE, TextureModifier.NONE, TextureModifier.NONE, TextureModifier.NONE}, {TextureModifier.NONE, TextureModifier.NONE, TextureModifier.ROT90, TextureModifier.ROT270, TextureModifier.NONE, TextureModifier.NONE}, {TextureModifier.ROT90, TextureModifier.ROT270, TextureModifier.NONE, TextureModifier.NONE, TextureModifier.ROT90, TextureModifier.ROT270}, {TextureModifier.ROT90, TextureModifier.ROT270, TextureModifier.NONE, TextureModifier.NONE, TextureModifier.NONE, TextureModifier.NONE}};
        int[][] txtid = new int[][]{{0, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 0, 0}, {1, 1, 0, 0, 1, 1}, {1, 1, 1, 1, 1, 1}};
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            if (sb == null || sb.textures == null) continue;
            for (int i = 0; i < 4; ++i) {
                BlockTextureRecord mtr = mtd.addBlockTextureRecord(blkname);
                mtr.setMetaValue(4 * i + sb.meta);
                for (int face = 0; face < 6; ++face) {
                    int fidx = txtid[i][face];
                    if (fidx >= sb.textures.size()) {
                        fidx = sb.textures.size() - 1;
                    }
                    String txt = sb.textures.get(fidx);
                    mtr.setSideTexture(txt.replace(':', '_'), tmod[i][face], BlockSide.valueOf((String)("FACE_" + face)));
                }
                this.def.setBlockColorMap(mtr, sb);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rnd) {
        this.def.randomDisplayTick(stateIn, worldIn, pos, rnd);
        super.func_180655_c(stateIn, worldIn, pos, rnd);
    }

    protected BlockStateContainer func_180661_e() {
        if (new_variant != null) {
            this.variant = new_variant;
            new_variant = null;
        }
        return new BlockStateContainer((Block)this, new IProperty[]{field_176299_a, this.variant});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176299_a, (Comparable)orientation[meta >> 2]).func_177226_a((IProperty)this.variant, (Comparable)Integer.valueOf(meta & 3));
    }

    public int func_176201_c(IBlockState state) {
        int idx = (Integer)state.func_177229_b((IProperty)this.variant);
        BlockLog.EnumAxis o = (BlockLog.EnumAxis)state.func_177229_b((IProperty)field_176299_a);
        int ord = 0;
        for (ord = 0; ord < orientation.length; ++ord) {
            if (orientation[ord] != o) continue;
            return 4 * ord + idx;
        }
        return idx;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return this.def.colorMultiplier();
    }

    @Override
    public IProperty<?>[] getNonRenderingProperties() {
        return null;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, ((Integer)state.func_177229_b((IProperty)this.variant)).intValue());
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.variant);
    }

    public SoundType getSoundType(IBlockState blockState, World world, BlockPos blockPos, @Nullable Entity entity) {
        return this.def.getSoundType(blockState.func_177230_c().func_176201_c(blockState));
    }

    public Material func_149688_o(IBlockState blockState) {
        return this.def.getMaterial(blockState.func_177230_c().func_176201_c(blockState));
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            def.setMetaMask(3);
            if (!def.validateMetaValues(new int[]{0, 1, 2, 3}, null)) {
                return null;
            }
            new_variant = PropertyMeta.create("variant", def.getDefinedBaseMeta());
            return new Block[]{new WCLogBlock(def)};
        }
    }
}

