/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockDynmapSupport;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.items.MultiBlockItem;
import com.westeroscraft.westerosblocks.properties.PropertyMeta;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dynmap.modsupport.BlockSide;
import org.dynmap.modsupport.BlockTextureRecord;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.TransparencyMode;

public class WCLeavesBlock
extends BlockLeaves
implements IShearable,
WesterosBlockLifecycle,
WesterosBlockDynmapSupport {
    private static PropertyMeta new_variant = null;
    private WesterosBlockDef def;
    private boolean[] nodecay;
    private PropertyMeta variant;

    public WCLeavesBlock(WesterosBlockDef def) {
        this.def = def;
        if (def.lightOpacity == -999) {
            def.lightOpacity = 1;
        }
        def.doStandardContructorSettings((Block)this);
        this.func_149672_a(def.getSoundType());
        this.nodecay = new boolean[8];
        for (int i = 0; i < 8; ++i) {
            String typ = def.getType(i);
            if (typ == null || !typ.contains("no-decay")) continue;
            this.nodecay[i] = true;
        }
        int defmeta = def.getDefinedBaseMeta().get(0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.variant, (Comparable)Integer.valueOf(defmeta)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(!this.nodecay[0])).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(!this.nodecay[0])));
    }

    @Override
    public boolean initializeBlockDefinition() {
        this.def.doStandardInitializeActions((Block)this);
        return true;
    }

    @Override
    public boolean registerBlockDefinition() {
        this.def.doStandardRegisterActions((Block)this, MultiBlockItem.class);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        this.def.getStandardCreativeItems((Block)this, tab, list);
    }

    protected void func_176234_a(World worldIn, BlockPos pos, IBlockState state, int chance) {
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, ((Integer)state.func_177229_b((IProperty)this.variant)).intValue());
    }

    public IBlockState func_176203_a(int meta) {
        int off = meta & 7;
        return this.func_176223_P().func_177226_a((IProperty)this.variant, (Comparable)Integer.valueOf(off)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = (Integer)state.func_177229_b((IProperty)this.variant);
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        if (new_variant != null) {
            this.variant = new_variant;
            new_variant = null;
        }
        return new BlockStateContainer((Block)this, new IProperty[]{field_176236_b, field_176237_a, this.variant});
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (!worldIn.field_72995_K && stack.func_77973_b() == Items.field_151097_aZ) {
            player.func_71029_a(StatList.func_188055_a((Block)this));
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    public NonNullList<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return NonNullList.func_191197_a((int)1, (Object)new ItemStack((Block)this, 1, ((Integer)world.func_180495_p(pos).func_177229_b((IProperty)this.variant)).intValue()));
    }

    @Override
    public WesterosBlockDef getWBDefinition() {
        return this.def;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFireSpreadSpeed(world, pos, face);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFlammability(world, pos, face);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightValue(state, world, pos);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightOpacity(state, world, pos);
    }

    @Override
    public void registerDynmapRenderData(ModTextureDefinition mtd) {
        this.def.defaultRegisterTextures(mtd);
        String blkname = this.def.getBlockName(0);
        for (int meta = 0; meta < 8; ++meta) {
            WesterosBlockDef.Subblock sb = this.def.getByMeta(meta);
            if (sb == null) continue;
            String topbot = sb.getTextureByIndex(2);
            String sides = sb.getTextureByIndex(3);
            BlockTextureRecord btr = mtd.addBlockTextureRecord(blkname);
            btr.setTransparencyMode(TransparencyMode.TRANSPARENT);
            btr.setMetaValue(meta);
            btr.setMetaValue(meta | 8);
            btr.setSideTexture(topbot, BlockSide.TOP);
            btr.setSideTexture(topbot, BlockSide.BOTTOM);
            btr.setSideTexture(sides, BlockSide.ALLSIDES);
            this.def.setBlockColorMap(btr, sb);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return Blocks.field_150362_t.func_176225_a(state, world, pos, side);
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return this.def.colorMultiplier();
    }

    @Override
    public IProperty<?>[] getNonRenderingProperties() {
        return new IProperty[]{field_176236_b, field_176237_a};
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, ((Integer)state.func_177229_b((IProperty)this.variant)).intValue());
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.variant);
    }

    public SoundType getSoundType(IBlockState blockState, World world, BlockPos blockPos, @Nullable Entity entity) {
        return this.def.getSoundType(blockState.func_177230_c().func_176201_c(blockState));
    }

    public Material func_149688_o(IBlockState blockState) {
        return this.def.getMaterial(blockState.func_177230_c().func_176201_c(blockState));
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            def.setMetaMask(7);
            if (!def.validateMetaValues(new int[]{0, 1, 2, 3, 4, 5, 6, 7}, null)) {
                return null;
            }
            new_variant = PropertyMeta.create("variant", def.getDefinedBaseMeta());
            return new Block[]{new WCLeavesBlock(def)};
        }
    }
}

