/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockDynmapSupport;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.items.MultiBlockItem;
import com.westeroscraft.westerosblocks.properties.PropertyMeta;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dynmap.modsupport.ModModelDefinition;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.PatchBlockModel;
import org.dynmap.renderer.RenderPatchFactory;

public class WCLadderBlock
extends BlockLadder
implements WesterosBlockLifecycle,
WesterosBlockDynmapSupport {
    protected static PropertyMeta new_variant = null;
    private WesterosBlockDef def;
    private boolean[] allow_unsupported = new boolean[4];
    private boolean[] no_climb = new boolean[4];
    private PropertyMeta variant;
    private static EnumFacing[] orientation = new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST, EnumFacing.SOUTH, EnumFacing.NORTH};

    protected WCLadderBlock(WesterosBlockDef def) {
        this.def = def;
        def.doStandardContructorSettings((Block)this);
        for (int i = 0; i < 4; ++i) {
            String[] toks;
            String t = def.getType(i);
            if (t == null) continue;
            for (String tok : toks = t.split(",")) {
                if (tok.equals("allow-unsupported")) {
                    this.allow_unsupported[i] = true;
                }
                if (!tok.equals("no-climb")) continue;
                this.no_climb[i] = true;
            }
        }
    }

    @Override
    public boolean initializeBlockDefinition() {
        this.def.doStandardInitializeActions((Block)this);
        return true;
    }

    @Override
    public boolean registerBlockDefinition() {
        this.def.doStandardRegisterActions((Block)this, MultiBlockItem.class);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        this.def.getStandardCreativeItems((Block)this, tab, list);
    }

    @Override
    public WesterosBlockDef getWBDefinition() {
        return this.def;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFireSpreadSpeed(world, pos, face);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFlammability(world, pos, face);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightValue(state, world, pos);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightOpacity(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.def.alphaRender ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rnd) {
        this.def.randomDisplayTick(stateIn, worldIn, pos, rnd);
        super.func_180655_c(stateIn, worldIn, pos, rnd);
    }

    protected BlockStateContainer func_180661_e() {
        if (new_variant != null) {
            this.variant = new_variant;
            new_variant = null;
        }
        return new BlockStateContainer((Block)this, new IProperty[]{field_176382_a, this.variant});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = orientation[meta >> 2];
        return this.func_176223_P().func_177226_a((IProperty)field_176382_a, (Comparable)enumfacing).func_177226_a((IProperty)this.variant, (Comparable)Integer.valueOf(meta & 3));
    }

    public int func_176201_c(IBlockState state) {
        int idx = (Integer)state.func_177229_b((IProperty)this.variant);
        EnumFacing f = (EnumFacing)state.func_177229_b((IProperty)field_176382_a);
        for (int i = 0; i < orientation.length; ++i) {
            if (orientation[i] != f) continue;
            idx += 4 * i;
            break;
        }
        return idx;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return this.def.colorMultiplier();
    }

    @Override
    public IProperty<?>[] getNonRenderingProperties() {
        return null;
    }

    @Override
    public void registerDynmapRenderData(ModTextureDefinition mtd) {
        ModModelDefinition md = mtd.getModelDefinition();
        String blkname = this.def.getBlockName(0);
        this.def.defaultRegisterTextures(mtd);
        this.def.registerPatchTextureBlock(mtd, 1);
        PatchBlockModel mod = md.addPatchModel(blkname);
        String patch0 = mod.addPatch(0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, RenderPatchFactory.SideVisible.BOTH);
        PatchBlockModel mod90 = md.addPatchModel(blkname);
        mod90.addRotatedPatch(patch0, 0, 90, 0);
        PatchBlockModel mod180 = md.addPatchModel(blkname);
        mod180.addRotatedPatch(patch0, 0, 180, 0);
        PatchBlockModel mod270 = md.addPatchModel(blkname);
        mod270.addRotatedPatch(patch0, 0, 270, 0);
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            mod.setMetaValue(sb.meta);
            mod90.setMetaValue(sb.meta + 8);
            mod180.setMetaValue(sb.meta + 4);
            mod270.setMetaValue(sb.meta + 12);
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
        if (state != null) {
            state = state.func_177226_a((IProperty)this.variant, (Comparable)Integer.valueOf(meta & 3));
        }
        return state;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing facing) {
        IBlockState bs = worldIn.func_180495_p(pos);
        if (bs.func_177230_c() == this && this.allow_unsupported[(Integer)bs.func_177229_b((IProperty)this.variant)]) {
            return true;
        }
        return super.func_176198_a(worldIn, pos, facing);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        IBlockState bs = worldIn.func_180495_p(pos);
        if (bs.func_177230_c() == this && this.allow_unsupported[(Integer)bs.func_177229_b((IProperty)this.variant)]) {
            return;
        }
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, ((Integer)state.func_177229_b((IProperty)this.variant)).intValue());
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.variant);
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return !this.no_climb[(Integer)state.func_177229_b((IProperty)this.variant)];
    }

    public SoundType getSoundType(IBlockState blockState, World world, BlockPos blockPos, @Nullable Entity entity) {
        return this.def.getSoundType(blockState.func_177230_c().func_176201_c(blockState));
    }

    public Material func_149688_o(IBlockState blockState) {
        return this.def.getMaterial(blockState.func_177230_c().func_176201_c(blockState));
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            def.setMetaMask(3);
            if (!def.validateMetaValues(new int[]{0, 1, 2, 3}, new int[]{0})) {
                return null;
            }
            new_variant = PropertyMeta.create("variant", def.getDefinedBaseMeta());
            return new Block[]{new WCLadderBlock(def)};
        }
    }
}

