/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.asm;

import java.util.HashMap;
import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassTransformer
implements IClassTransformer,
Opcodes {
    public static HashMap<String, TransformState> patchState = new HashMap();
    public static float cloudHeight = 256.0f;

    public byte[] transform(String name, String tname, byte[] bytes) {
        TransformState ts;
        boolean match = true;
        if (name.equals("ayk")) {
            bytes = this.transformWorldProvider(name, bytes, true);
        } else if (name.equals("net.minecraft.world.WorldProvider")) {
            bytes = this.transformWorldProvider(name, bytes, false);
        } else if (name.equals("aqy")) {
            bytes = this.transformBlockGlass(name, bytes, true);
        } else if (name.equals("net.minecraft.block.BlockGlass")) {
            bytes = this.transformBlockGlass(name, bytes, false);
        } else if (name.equals("auo")) {
            bytes = this.transformBlockGlassPane(name, bytes, true);
        } else if (name.equals("net.minecraft.block.BlockPane")) {
            bytes = this.transformBlockGlassPane(name, bytes, false);
        } else if (name.equals("fd")) {
            bytes = this.transformObjectIntIdentityMap(name, bytes, true);
        } else if (name.equals("net.minecraft.util.ObjectIntIdentityMap")) {
            bytes = this.transformObjectIntIdentityMap(name, bytes, false);
        } else if (name.equals("ko")) {
            bytes = this.transformSPacketTimeUpdate(name, bytes, true);
        } else if (name.equals("net.minecraft.network.play.server.SPacketTimeUpdate")) {
            bytes = this.transformSPacketTimeUpdate(name, bytes, false);
        } else if (name.equals("jc")) {
            bytes = this.transformSPacketChangeGameState(name, bytes, true);
        } else if (name.equals("net.minecraft.network.play.server.SPacketChangeGameState")) {
            bytes = this.transformSPacketChangeGameState(name, bytes, false);
        } else if (name.equals("aqf")) {
            bytes = this.transformEnchantmentTable(name, bytes, true);
        } else if (name.equals("net.minecraft.block.BlockEnchantmentTable")) {
            bytes = this.transformEnchantmentTable(name, bytes, false);
        } else {
            match = false;
        }
        if (match && (ts = patchState.get(name)) == null) {
            patchState.put(name, TransformState.NOTMATCHED);
        }
        return bytes;
    }

    private MethodNode findMethod(ClassNode cls, String methname, String methsig) {
        for (MethodNode m : cls.methods) {
            if (!m.name.equals(methname) || !m.desc.equals(methsig)) continue;
            return m;
        }
        return null;
    }

    private void printMethod(MethodNode meth) {
        ListIterator iter = meth.instructions.iterator();
        System.out.println("printMethod(" + meth.name + ")");
        while (iter.hasNext()) {
            AbstractInsnNode n = (AbstractInsnNode)iter.next();
            System.out.println("  " + n.getOpcode() + " (" + n.getType() + " - " + n.getClass().getName() + ")");
        }
    }

    private byte[] transformWorldProvider(String name, byte[] b, boolean obfus) {
        String targetMethodName = "";
        String targetMethodSig = "";
        targetMethodName = obfus ? "f" : "getCloudHeight";
        targetMethodSig = "()F";
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(b);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode m = this.findMethod(classNode, targetMethodName, targetMethodSig);
        if (m == null) {
            patchState.put(name, TransformState.CLIENTONLY);
            return b;
        }
        MethodNode mv = m;
        m.instructions.clear();
        m.localVariables.clear();
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(188, l0);
        mv.visitFieldInsn(178, "com/westeroscraft/westerosblocks/asm/ClassTransformer", "cloudHeight", "F");
        mv.visitInsn(174);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", "Lcom/westeroscraft/westerosblocks/asm/ClassTransformer;", null, l0, l1, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        b = writer.toByteArray();
        patchState.put(name, TransformState.DONE);
        return b;
    }

    private byte[] transformBlockGlass(String name, byte[] b, boolean obfus) {
        String targetMethodName = "";
        String targetMethodSig = "";
        if (obfus) {
            targetMethodName = "f";
            targetMethodSig = "()Lamm;";
        } else {
            targetMethodName = "getBlockLayer";
            targetMethodSig = "()Lnet/minecraft/util/BlockRenderLayer;";
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(b);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode m = this.findMethod(classNode, targetMethodName, targetMethodSig);
        if (m == null) {
            patchState.put(name, TransformState.CLIENTONLY);
            return b;
        }
        MethodNode mv = m;
        m.instructions.clear();
        m.localVariables.clear();
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(27, l0);
        if (obfus) {
            mv.visitFieldInsn(178, "amm", "d", "Lamm;");
        } else {
            mv.visitFieldInsn(178, "net/minecraft/util/BlockRenderLayer", "TRANSLUCENT", "Lnet/minecraft/util/BlockRenderLayer;");
        }
        mv.visitInsn(176);
        Label l1 = new Label();
        mv.visitLabel(l1);
        if (obfus) {
            mv.visitLocalVariable("this", "Laqw;", null, l0, l1, 0);
        } else {
            mv.visitLocalVariable("this", "Lnet/minecraft/block/BlockGlass;", null, l0, l1, 0);
        }
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        b = writer.toByteArray();
        patchState.put(name, TransformState.DONE);
        return b;
    }

    private byte[] transformBlockGlassPane(String name, byte[] b, boolean obfus) {
        String targetMethodName = "";
        String targetMethodSig = "";
        if (obfus) {
            targetMethodName = "f";
            targetMethodSig = "()Lamm;";
        } else {
            targetMethodName = "getBlockLayer";
            targetMethodSig = "()Lnet/minecraft/util/BlockRenderLayer;";
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(b);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode m = this.findMethod(classNode, targetMethodName, targetMethodSig);
        if (m == null) {
            patchState.put(name, TransformState.CLIENTONLY);
            return b;
        }
        MethodNode mv = m;
        m.instructions.clear();
        m.localVariables.clear();
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(27, l0);
        if (obfus) {
            mv.visitFieldInsn(178, "amm", "d", "Lamm;");
        } else {
            mv.visitFieldInsn(178, "net/minecraft/util/BlockRenderLayer", "TRANSLUCENT", "Lnet/minecraft/util/BlockRenderLayer;");
        }
        mv.visitInsn(176);
        Label l1 = new Label();
        mv.visitLabel(l1);
        if (obfus) {
            mv.visitLocalVariable("this", "Laum;", null, l0, l1, 0);
        } else {
            mv.visitLocalVariable("this", "Lnet/minecraft/block/BlockPane;", null, l0, l1, 0);
        }
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        b = writer.toByteArray();
        patchState.put(name, TransformState.DONE);
        return b;
    }

    private byte[] transformObjectIntIdentityMap(String name, byte[] b, boolean obfus) {
        String targetMethodName = "";
        String targetMethodSig = "";
        String targetClassSig = "";
        String targetFieldID = "";
        System.out.println("Checking class " + name);
        if (obfus) {
            targetMethodName = "a";
            targetClassSig = "fd";
            targetFieldID = "b";
        } else {
            targetMethodName = "size";
            targetClassSig = "net/minecraft/util/ObjectIntIdentityMap";
            targetFieldID = "objectList";
        }
        targetMethodSig = "()I";
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(b);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode m = this.findMethod(classNode, targetMethodName, targetMethodSig);
        if (m == null) {
            System.out.println("Cannot find " + targetMethodName + "() in " + name + " for patching");
            return b;
        }
        MethodNode mv = m;
        m.instructions.clear();
        m.localVariables.clear();
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(397, l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, targetClassSig, targetFieldID, "Ljava/util/List;");
        mv.visitMethodInsn(185, "java/util/List", "size", "()I", true);
        mv.visitInsn(172);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", "L" + targetClassSig + ";", "L" + targetClassSig + "<TT;>;", l0, l1, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        b = writer.toByteArray();
        patchState.put(name, TransformState.DONE);
        return b;
    }

    private byte[] transformSPacketTimeUpdate(String name, byte[] b, boolean obfus) {
        String targetMethodName = "";
        String targetMethodSig = "";
        String targetClassSig = "";
        String targetFieldID = "";
        String targetFieldID2 = "";
        String targetClassPacketBuffer = "";
        if (obfus) {
            targetClassSig = "ko";
            targetMethodName = "a";
            targetMethodSig = "(Lgy;)V";
            targetFieldID = "b";
            targetFieldID2 = "a";
            targetClassPacketBuffer = "gy";
        } else {
            targetClassSig = "net/minecraft/network/play/server/SPacketTimeUpdate";
            targetMethodName = "readPacketData";
            targetMethodSig = "(Lnet/minecraft/network/PacketBuffer;)V";
            targetFieldID = "worldTime";
            targetFieldID2 = "totalWorldTime";
            targetClassPacketBuffer = "net/minecraft/network/PacketBuffer";
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(b);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode m = this.findMethod(classNode, targetMethodName, targetMethodSig);
        if (m == null) {
            patchState.put(name, TransformState.CLIENTONLY);
            return b;
        }
        MethodNode mv = m;
        m.instructions.clear();
        m.localVariables.clear();
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(493, l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, targetClassPacketBuffer, "readLong", "()J", false);
        mv.visitMethodInsn(184, "com/westeroscraft/westerosblocks/commands/PTimeCommand", "processTotalWorldTime", "(J)J", false);
        mv.visitFieldInsn(181, targetClassSig, targetFieldID2, "J");
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(494, l1);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, targetClassPacketBuffer, "readLong", "()J", false);
        mv.visitMethodInsn(184, "com/westeroscraft/westerosblocks/commands/PTimeCommand", "processWorldTime", "(J)J", false);
        mv.visitFieldInsn(181, targetClassSig, targetFieldID, "J");
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLineNumber(495, l2);
        mv.visitInsn(177);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLocalVariable("this", "L" + targetClassSig + ";", null, l0, l3, 0);
        mv.visitLocalVariable("buf", "L" + targetClassPacketBuffer + ";", null, l0, l3, 1);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        b = writer.toByteArray();
        patchState.put(name, TransformState.DONE);
        return b;
    }

    private byte[] transformSPacketChangeGameState(String name, byte[] b, boolean obfus) {
        String targetMethodName = "";
        String targetMethodSig = "";
        String targetClassSig = "";
        String targetParmClassSig = "";
        String targetFieldID = "";
        String targetFieldID2 = "";
        if (obfus) {
            targetClassSig = "jc";
            targetMethodName = "a";
            targetMethodSig = "(Lgy;)V";
            targetFieldID = "b";
            targetFieldID2 = "c";
            targetParmClassSig = "gy";
        } else {
            targetClassSig = "net/minecraft/network/play/server/SPacketChangeGameState";
            targetMethodName = "readPacketData";
            targetMethodSig = "(Lnet/minecraft/network/PacketBuffer;)V";
            targetFieldID = "state";
            targetFieldID2 = "value";
            targetParmClassSig = "net/minecraft/network/PacketBuffer";
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(b);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode m = this.findMethod(classNode, targetMethodName, targetMethodSig);
        if (m == null) {
            patchState.put(name, TransformState.CLIENTONLY);
            return b;
        }
        MethodNode mv = m;
        m.instructions.clear();
        m.localVariables.clear();
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(592, l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, targetParmClassSig, "readUnsignedByte", "()S", false);
        mv.visitFieldInsn(181, targetClassSig, targetFieldID, "I");
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(593, l1);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, targetParmClassSig, "readFloat", "()F", false);
        mv.visitFieldInsn(181, targetClassSig, targetFieldID2, "F");
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLineNumber(594, l2);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "com/westeroscraft/westerosblocks/commands/PWeatherCommand", "processChangeGameState", "(L" + targetClassSig + ";)V", false);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLineNumber(595, l3);
        mv.visitInsn(177);
        Label l4 = new Label();
        mv.visitLabel(l4);
        mv.visitLocalVariable("this", "L" + targetClassSig + ";", null, l0, l4, 0);
        mv.visitLocalVariable("buf", "L" + targetParmClassSig + ";", null, l0, l4, 1);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        b = writer.toByteArray();
        patchState.put(name, TransformState.DONE);
        return b;
    }

    private byte[] transformEnchantmentTable(String name, byte[] b, boolean obfus) {
        ClassReader classReader = new ClassReader(b);
        ClassWriter writer = new ClassWriter(3);
        AddEnchantMethodVisitor visitor = new AddEnchantMethodVisitor((ClassVisitor)writer, obfus);
        classReader.accept((ClassVisitor)visitor, 0);
        b = writer.toByteArray();
        patchState.put(name, TransformState.DONE);
        return b;
    }

    private class AddEnchantMethodVisitor
    extends ClassVisitor {
        String targetMethodName;
        String targetMethodSig;
        String targetClassSig;
        String targetRetClass;
        String targetRetEnum;

        public AddEnchantMethodVisitor(ClassVisitor cv, boolean obfus) {
            super(327680, cv);
            this.targetMethodName = "";
            this.targetMethodSig = "";
            this.targetClassSig = "";
            this.targetRetClass = "";
            this.targetRetEnum = "";
            if (obfus) {
                this.targetClassSig = "aqd";
                this.targetMethodName = "f";
                this.targetMethodSig = "()Lamm;";
                this.targetRetClass = "amm";
                this.targetRetEnum = "c";
            } else {
                this.targetClassSig = "net/minecraft/block/BlockEnchantmentTable";
                this.targetMethodName = "getBlockLayer";
                this.targetMethodSig = "()Lnet/minecraft/util/BlockRenderLayer;";
                this.targetRetClass = "net/minecraft/util/BlockRenderLayer";
                this.targetRetEnum = "CUTOUT";
            }
        }

        public void visitEnd() {
            MethodVisitor mv = this.cv.visitMethod(1, this.targetMethodName, this.targetMethodSig, null, null);
            AnnotationVisitor av0 = mv.visitAnnotation("Lnet/minecraftforge/fml/relauncher/SideOnly;", true);
            av0.visitEnum("value", "Lnet/minecraftforge/fml/relauncher/Side;", "CLIENT");
            av0.visitEnd();
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitFieldInsn(178, this.targetRetClass, this.targetRetEnum, "L" + this.targetRetClass + ";");
            mv.visitInsn(176);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", "L" + this.targetClassSig + ";", null, l0, l1, 0);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            super.visitEnd();
        }
    }

    public static enum TransformState {
        NONE,
        NOTMATCHED,
        CLIENTONLY,
        DONE;

    }
}

