/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks;

import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlocks;
import com.westeroscraft.westerosblocks.WesterosBlocksCreativeTab;
import com.westeroscraft.westerosblocks.blocks.WCBeaconBlock;
import com.westeroscraft.westerosblocks.blocks.WCBedBlock;
import com.westeroscraft.westerosblocks.blocks.WCCakeBlock;
import com.westeroscraft.westerosblocks.blocks.WCCropBlock;
import com.westeroscraft.westerosblocks.blocks.WCCuboidBlock;
import com.westeroscraft.westerosblocks.blocks.WCCuboidNEBlock;
import com.westeroscraft.westerosblocks.blocks.WCCuboidNEStackBlock;
import com.westeroscraft.westerosblocks.blocks.WCCuboidNSEWBlock;
import com.westeroscraft.westerosblocks.blocks.WCCuboidNSEWStackBlock;
import com.westeroscraft.westerosblocks.blocks.WCCuboidNSEWUDBlock;
import com.westeroscraft.westerosblocks.blocks.WCDoorBlock;
import com.westeroscraft.westerosblocks.blocks.WCFenceBlock;
import com.westeroscraft.westerosblocks.blocks.WCFireBlock;
import com.westeroscraft.westerosblocks.blocks.WCFurnaceBlock;
import com.westeroscraft.westerosblocks.blocks.WCHalfDoorBlock;
import com.westeroscraft.westerosblocks.blocks.WCLadderBlock;
import com.westeroscraft.westerosblocks.blocks.WCLayerBlock;
import com.westeroscraft.westerosblocks.blocks.WCLeavesBlock;
import com.westeroscraft.westerosblocks.blocks.WCLogBlock;
import com.westeroscraft.westerosblocks.blocks.WCPaneBlock;
import com.westeroscraft.westerosblocks.blocks.WCPlantBlock;
import com.westeroscraft.westerosblocks.blocks.WCRailBlock;
import com.westeroscraft.westerosblocks.blocks.WCSandBlock;
import com.westeroscraft.westerosblocks.blocks.WCSlabBlock;
import com.westeroscraft.westerosblocks.blocks.WCSolidBlock;
import com.westeroscraft.westerosblocks.blocks.WCSoulSandBlock;
import com.westeroscraft.westerosblocks.blocks.WCSoundBlock;
import com.westeroscraft.westerosblocks.blocks.WCStairBlock;
import com.westeroscraft.westerosblocks.blocks.WCTorchBlock;
import com.westeroscraft.westerosblocks.blocks.WCTrapDoorBlock;
import com.westeroscraft.westerosblocks.blocks.WCVinesBlock;
import com.westeroscraft.westerosblocks.blocks.WCWallBlock;
import com.westeroscraft.westerosblocks.blocks.WCWebBlock;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.dynmap.modsupport.BlockSide;
import org.dynmap.modsupport.BlockTextureRecord;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.TextureModifier;
import org.dynmap.modsupport.TransparencyMode;

public class WesterosBlockDef {
    private static final float DEF_FLOAT = -999.0f;
    public static final int DEF_INT = -999;
    public String blockName;
    public String blockType = "solid";
    public int blockID = -999;
    public int[] blockIDs = null;
    public float hardness = -999.0f;
    public String stepSound = null;
    public String material = null;
    public float resistance = -999.0f;
    public int lightOpacity = -999;
    public List<HarvestLevel> harvestLevel = null;
    public int harvestItemID = -999;
    public int fireSpreadSpeed = 0;
    public int flamability = 0;
    public String creativeTab = null;
    public float lightValue = 0.0f;
    public List<Subblock> subBlocks = null;
    public String modelBlockName = null;
    public int modelBlockMeta = -999;
    public BoundingBox boundingBox = null;
    public String colorMult = "#FFFFFF";
    public String type = "";
    public boolean alphaRender = false;
    public boolean nonOpaque = false;
    private int blockIDCount = 1;
    public static final String SHAPE_BOX = "box";
    public static final String SHAPE_CROSSED = "crossed";
    private transient Subblock[] subblock_by_meta;
    private transient int[] fireSpreadSpeed_by_meta = null;
    private transient int[] flamability_by_meta = null;
    private transient String[] stepSound_by_meta = null;
    private transient String[] material_by_meta = null;
    private transient int[] lightValue_by_meta = null;
    private transient int[] lightOpacity_by_meta = null;
    private transient int lightValueInt;
    private transient ColorMultHandler colorMultHandler;
    private transient ColorMultHandler[] colorMultHandlerByMeta;
    private transient BoundingBox[] boundingBoxByMeta;
    private transient List<String>[] sounds_by_meta = null;
    private transient List<Particle>[] particles_by_meta = null;
    private transient boolean hasCollisionBoxes = false;
    private static final Map<String, Material> materialTable = new HashMap<String, Material>();
    private static final Map<String, SoundType> stepSoundTable = new HashMap<String, SoundType>();
    private static final Map<String, CreativeTabs> tabTable = new HashMap<String, CreativeTabs>();
    private static final Map<String, WesterosBlockFactory> typeTable = new HashMap<String, WesterosBlockFactory>();
    private static final Map<String, ColorMultHandler> colorMultTable = new HashMap<String, ColorMultHandler>();
    private static final Map<String, EnumParticleTypes> particles = new HashMap<String, EnumParticleTypes>();
    private int metaMask = 15;
    private Method add_registry;
    private static final int[] all_meta = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static HashMap<String, TileEntityRec> te_rec = new HashMap();

    public void setMetaMask(int mask) {
        this.metaMask = mask;
    }

    public Block[] createBlocks() {
        WesterosBlockFactory bf = typeTable.get(this.blockType);
        if (bf == null) {
            WesterosBlocks.log.error(String.format("Invalid blockType '%s' in block '%s'", this.blockType, this.blockName));
            return null;
        }
        return bf.buildBlockClasses(this);
    }

    public Material getMaterial() {
        Material m = materialTable.get(this.material);
        if (m == null) {
            WesterosBlocks.log.warn(String.format("Invalid material '%s' in block '%s'", this.material, this.blockName));
            return Material.field_151576_e;
        }
        return m;
    }

    public Material getMaterial(int meta) {
        Subblock subBlock = this.subblock_by_meta[meta & this.metaMask];
        return subBlock.material == null ? this.getMaterial() : materialTable.get(subBlock.material);
    }

    public SoundType getSoundType() {
        SoundType ss = stepSoundTable.get(this.stepSound);
        if (ss == null) {
            WesterosBlocks.log.warn(String.format("Invalid step sound '%s' in block '%s'", this.stepSound, this.blockName));
            return SoundType.field_185851_d;
        }
        return ss;
    }

    public SoundType getSoundType(int meta) {
        Subblock subBlock = this.subblock_by_meta[meta & this.metaMask];
        return subBlock.stepSound == null ? this.getSoundType() : stepSoundTable.get(subBlock.stepSound);
    }

    public CreativeTabs getCreativeTab() {
        CreativeTabs ct = tabTable.get(this.creativeTab);
        if (ct == null) {
            WesterosBlocks.log.warn(String.format("Invalid tab name '%s' in block '%s'", this.creativeTab, this.blockName));
            ct = WesterosBlocksCreativeTab.tabWesterosBlocks;
        }
        return ct;
    }

    private void initMeta() {
        this.subblock_by_meta = new Subblock[this.metaMask + 1];
        this.lightValueInt = (int)(15.0f * this.lightValue);
        this.colorMultHandler = WesterosBlockDef.getColorHandler(this.colorMult, this.blockName);
        if (this.colorMultHandler == null) {
            WesterosBlocks.log.warn(String.format("Invalid colorMult '%s' in block '%s'", this.colorMult, this.blockName));
            this.colorMultHandler = WesterosBlockDef.getColorHandler("#FFFFFF", this.blockName);
        }
        this.boundingBoxByMeta = new BoundingBox[16];
        for (int i = 0; i < 16; ++i) {
            this.boundingBoxByMeta[i] = this.boundingBox;
        }
        if (this.subBlocks != null) {
            Iterator<Subblock> iterator = this.subBlocks.iterator();
            while (iterator.hasNext()) {
                Subblock sb;
                this.subblock_by_meta[sb.meta] = sb = iterator.next();
                if (sb.fireSpreadSpeed != -999) {
                    if (this.fireSpreadSpeed_by_meta == null) {
                        this.fireSpreadSpeed_by_meta = new int[this.metaMask + 1];
                        if (this.fireSpreadSpeed != -999) {
                            Arrays.fill(this.fireSpreadSpeed_by_meta, this.fireSpreadSpeed);
                        }
                    }
                    this.fireSpreadSpeed_by_meta[sb.meta] = sb.fireSpreadSpeed;
                }
                if (sb.flamability != -999) {
                    if (this.flamability_by_meta == null) {
                        this.flamability_by_meta = new int[this.metaMask + 1];
                        if (this.flamability != -999) {
                            Arrays.fill(this.flamability_by_meta, this.flamability);
                        }
                    }
                    this.flamability_by_meta[sb.meta] = sb.flamability;
                }
                if (sb.stepSound != null) {
                    if (this.stepSound_by_meta == null) {
                        this.stepSound_by_meta = new String[this.metaMask + 1];
                        if (this.stepSound != null) {
                            Arrays.fill(this.stepSound_by_meta, this.stepSound);
                        }
                    }
                    this.stepSound_by_meta[sb.meta] = sb.stepSound;
                }
                if (sb.material != null) {
                    if (this.material_by_meta == null) {
                        this.material_by_meta = new String[this.metaMask + 1];
                        if (this.material != null) {
                            Arrays.fill(this.material_by_meta, this.material);
                        }
                    }
                    this.material_by_meta[sb.meta] = sb.material;
                }
                if (sb.lightValue != -999.0f) {
                    if (this.lightValue_by_meta == null) {
                        this.lightValue_by_meta = new int[this.metaMask + 1];
                        if (this.lightValue != -999.0f) {
                            Arrays.fill(this.lightValue_by_meta, (int)(15.0f * this.lightValue));
                        }
                    }
                    this.lightValue_by_meta[sb.meta] = (int)(15.0f * sb.lightValue);
                }
                if (sb.lightOpacity != -999) {
                    if (this.lightOpacity_by_meta == null) {
                        this.lightOpacity_by_meta = new int[this.metaMask + 1];
                        if (this.lightOpacity != -999) {
                            Arrays.fill(this.lightOpacity_by_meta, this.lightOpacity);
                        }
                    }
                    this.lightOpacity_by_meta[sb.meta] = sb.lightOpacity;
                }
                if (sb.colorMult != null) {
                    if (this.colorMultHandlerByMeta == null) {
                        this.colorMultHandlerByMeta = new ColorMultHandler[this.metaMask + 1];
                        Arrays.fill(this.colorMultHandlerByMeta, this.colorMultHandler);
                    }
                    this.colorMultHandlerByMeta[sb.meta] = WesterosBlockDef.getColorHandler(sb.colorMult, this.blockName);
                    if (this.colorMultHandlerByMeta[sb.meta] == null) {
                        WesterosBlocks.log.warn(String.format("Invalid colorMult '%s' in block '%s'", sb.colorMult, this.blockName));
                        this.colorMultHandlerByMeta[sb.meta] = this.colorMultHandler;
                    }
                }
                if (sb.boundingBox != null && sb.cuboids == null) {
                    Cuboid c = new Cuboid();
                    c.xMin = sb.boundingBox.xMin;
                    c.xMax = sb.boundingBox.xMax;
                    c.yMin = sb.boundingBox.yMin;
                    c.yMax = sb.boundingBox.yMax;
                    c.zMin = sb.boundingBox.zMin;
                    c.zMax = sb.boundingBox.zMax;
                    sb.cuboids = Collections.singletonList(c);
                }
                if (sb.cuboids != null && sb.boundingBox == null) {
                    sb.boundingBox = new BoundingBox();
                    sb.boundingBox.zMin = 1.0f;
                    sb.boundingBox.yMin = 1.0f;
                    sb.boundingBox.xMin = 1.0f;
                    sb.boundingBox.zMax = 0.0f;
                    sb.boundingBox.yMax = 0.0f;
                    sb.boundingBox.xMax = 0.0f;
                    for (BoundingBox boundingBox : sb.cuboids) {
                        if (boundingBox.xMin < sb.boundingBox.xMin) {
                            sb.boundingBox.xMin = boundingBox.xMin;
                        }
                        if (boundingBox.yMin < sb.boundingBox.yMin) {
                            sb.boundingBox.yMin = boundingBox.yMin;
                        }
                        if (boundingBox.zMin < sb.boundingBox.zMin) {
                            sb.boundingBox.zMin = boundingBox.zMin;
                        }
                        if (boundingBox.xMax > sb.boundingBox.xMax) {
                            sb.boundingBox.xMax = boundingBox.xMax;
                        }
                        if (boundingBox.yMax > sb.boundingBox.yMax) {
                            sb.boundingBox.yMax = boundingBox.yMax;
                        }
                        if (!(boundingBox.zMax > sb.boundingBox.zMax)) continue;
                        sb.boundingBox.zMax = boundingBox.zMax;
                    }
                }
                if (sb.boundingBox != null) {
                    for (int i = 0; i < 16; ++i) {
                        if ((i & this.metaMask) != sb.meta) continue;
                        this.boundingBoxByMeta[i] = sb.boundingBox;
                    }
                }
                if (sb.soundList != null) {
                    if (this.sounds_by_meta == null) {
                        this.sounds_by_meta = new List[this.metaMask + 1];
                    }
                    this.sounds_by_meta[sb.meta] = sb.soundList;
                }
                if (sb.particles != null && sb.particles.size() > 0) {
                    if (this.particles_by_meta == null) {
                        this.particles_by_meta = new List[this.metaMask + 1];
                    }
                    this.particles_by_meta[sb.meta] = sb.particles;
                    for (Particle particle : sb.particles) {
                        if (particles.containsKey(particle.particle)) continue;
                        WesterosBlocks.log.warn(String.format("Invalid particle '%s' in block '%s'", particle.particle, this.blockName));
                        particle.particle = "smoke";
                    }
                }
                if (sb.collisionBoxes == null) continue;
                this.hasCollisionBoxes = true;
            }
        }
    }

    public boolean hasCollisionBoxes() {
        return this.hasCollisionBoxes;
    }

    public Subblock getByMeta(int meta) {
        if (this.subblock_by_meta == null) {
            this.initMeta();
        }
        return this.subblock_by_meta[meta & this.metaMask];
    }

    public List<Integer> getDefinedBaseMeta() {
        if (this.subblock_by_meta == null) {
            this.initMeta();
        }
        ArrayList<Integer> lst = new ArrayList<Integer>();
        for (int i = 0; i <= this.metaMask; ++i) {
            if (this.subblock_by_meta[i] == null) continue;
            lst.add(i);
        }
        return lst;
    }

    public void doStandardContructorSettings(Block blk) {
        this.doStandardContructorSettings(blk, 0);
    }

    public void doStandardContructorSettings(Block blk, int idx) {
        if (this.hardness != -999.0f) {
            blk.func_149711_c(this.hardness);
        }
        if (this.lightOpacity == -999) {
            this.lightOpacity = blk.func_149662_c(blk.func_176223_P()) ? 255 : 0;
        }
        blk.func_149713_g(this.lightOpacity);
        if (this.resistance != -999.0f) {
            blk.func_149752_b(this.resistance);
        }
        if (this.lightValue == -999.0f) {
            this.lightValue = 0.0f;
        }
        blk.func_149715_a(this.lightValue);
        blk.func_149663_c(this.getBlockName(idx));
        blk.setRegistryName(this.getBlockName(idx));
        if (this.fireSpreadSpeed > 0 || this.flamability > 0) {
            Blocks.field_150480_ab.func_180686_a(blk, this.fireSpreadSpeed, this.flamability);
        }
        if (this.creativeTab != null) {
            blk.func_149647_a(this.getCreativeTab());
        }
        if (this.boundingBox != null) {
            // empty if block
        }
        if (this.particles_by_meta != null) {
            blk.func_149675_a(true);
        }
    }

    public void doStandardInitializeActions(Block blk) {
        if (this.harvestLevel != null) {
            for (HarvestLevel hl : this.harvestLevel) {
                blk.setHarvestLevel(hl.tool, hl.level);
            }
        }
        if (this.subBlocks != null) {
            for (Subblock sb : this.subBlocks) {
                if (sb.harvestLevel == null) continue;
                for (HarvestLevel hl : sb.harvestLevel) {
                    blk.setHarvestLevel(hl.tool, hl.level);
                }
            }
        }
    }

    public String getBlockName(int blknum) {
        if (blknum == 0) {
            return this.blockName;
        }
        return this.blockName + "_" + (blknum + 1);
    }

    public void doStandardRegisterActions(Block blk, Class<? extends ItemBlock> itmclass) {
        this.doStandardRegisterActions(blk, itmclass, 0);
    }

    public void doStandardRegisterActions(Block blk, Class<? extends ItemBlock> itmclass, int idx) {
        int reqID;
        int n = reqID = this.blockIDs[idx] >= 0 ? this.blockIDs[idx] : -1;
        if (this.subBlocks != null && this.subBlocks.size() > 0) {
            for (Subblock sb : this.subBlocks) {
                if (sb.noInventoryItem || sb.label != null) continue;
                sb.label = this.blockName + " " + sb.meta;
            }
        }
        if (this.subblock_by_meta == null) {
            this.initMeta();
        }
        this.registerBlock(blk, itmclass, this.getBlockName(idx), reqID);
    }

    private Block registerBlock(Block block, Class<? extends ItemBlock> itemclass, String name, int id) {
        try {
            if (this.add_registry == null) {
                this.add_registry = ForgeRegistry.class.getDeclaredMethod("add", Integer.TYPE, IForgeRegistryEntry.class);
                this.add_registry.setAccessible(true);
            }
            Item itm = null;
            if (itemclass != null) {
                itm = (Item)itemclass.getConstructor(Block.class).newInstance(block);
            }
            ResourceLocation rl = new ResourceLocation("westerosblocks", name);
            this.add_registry.invoke((Object)ForgeRegistries.BLOCKS, id, block);
            if (itm != null) {
                itm.setRegistryName(rl);
                this.add_registry.invoke((Object)ForgeRegistries.ITEMS, id, itm);
                if (this.subBlocks != null) {
                    for (Subblock sb : this.subBlocks) {
                        if (sb.noInventoryItem) continue;
                        ItemStack is = new ItemStack(itm, 1, sb.meta);
                        WesterosBlocks.proxy.registerItemRenderer(is.func_77973_b(), sb.meta, is.func_77977_a().substring(5));
                    }
                }
            }
            return block;
        }
        catch (Exception e) {
            WesterosBlocks.crash(e, "Caught an exception during block registration");
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void getStandardSubBlocks(Block blk, int id, CreativeTabs tab, List<ItemStack> list) {
        if (this.subBlocks != null) {
            for (Subblock sb : this.subBlocks) {
                if (sb.noInventoryItem) continue;
                list.add(new ItemStack(blk, 1, sb.meta));
            }
        }
    }

    public String getFirstTexture() {
        if (this.subBlocks != null) {
            for (Subblock sb : this.subBlocks) {
                if (sb.textures == null || sb.textures.size() <= 0) continue;
                return sb.textures.get(0);
            }
        }
        return "INVALID_" + this.blockName;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.flamability_by_meta != null) {
            IBlockState bs = world.func_180495_p(pos);
            return this.flamability_by_meta[bs.func_177230_c().func_176201_c(bs) & this.metaMask];
        }
        return this.flamability;
    }

    public List<String> getSoundIDList(int metadata) {
        metadata &= this.metaMask;
        if (this.sounds_by_meta != null) {
            return this.sounds_by_meta[metadata];
        }
        return null;
    }

    public List<Particle> getParticleList(int metadata) {
        metadata &= this.metaMask;
        if (this.particles_by_meta != null) {
            return this.particles_by_meta[metadata];
        }
        return null;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.fireSpreadSpeed_by_meta != null) {
            IBlockState bs = world.func_180495_p(pos);
            return this.fireSpreadSpeed_by_meta[bs.func_177230_c().func_176201_c(bs) & this.metaMask];
        }
        return this.fireSpreadSpeed;
    }

    public int getLightValue(IBlockState bs, IBlockAccess world, BlockPos pos) {
        if (this.lightValue_by_meta != null) {
            return this.lightValue_by_meta[bs.func_177230_c().func_176201_c(bs) & this.metaMask];
        }
        return this.lightValueInt;
    }

    public int getLightOpacity(IBlockState bs, IBlockAccess world, BlockPos pos) {
        if (this.lightOpacity_by_meta != null) {
            return this.lightOpacity_by_meta[bs.func_177230_c().func_176201_c(bs) & this.metaMask];
        }
        return bs.func_185891_c();
    }

    public int getRenderColor(int meta) {
        if (this.subblock_by_meta == null) {
            this.initMeta();
        }
        meta &= this.metaMask;
        if (this.colorMultHandlerByMeta != null) {
            return this.colorMultHandlerByMeta[meta].getBlockColor();
        }
        return this.colorMultHandler.getBlockColor();
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockColor colorMultiplier() {
        if (this.subblock_by_meta == null) {
            this.initMeta();
        }
        if (this.colorMult.equals("#FFFFFF")) {
            boolean found = false;
            for (Subblock sb : this.subBlocks) {
                if (sb.colorMult == null || sb.colorMult.equals("#FFFFFF")) continue;
                found = true;
            }
            if (!found) {
                return null;
            }
        }
        return new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
                if (WesterosBlockDef.this.colorMultHandlerByMeta != null) {
                    int meta = state.func_177230_c().func_176201_c(state) & WesterosBlockDef.this.metaMask;
                    if (world == null) {
                        return WesterosBlockDef.this.colorMultHandlerByMeta[meta].getBlockColor();
                    }
                    return WesterosBlockDef.this.colorMultHandlerByMeta[meta].colorMultiplier(world, pos);
                }
                if (world == null) {
                    return WesterosBlockDef.this.colorMultHandler.getBlockColor();
                }
                return WesterosBlockDef.this.colorMultHandler.colorMultiplier(world, pos);
            }
        };
    }

    public void getStandardCreativeItems(Block blk, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.subBlocks != null) {
            for (Subblock sb : this.subBlocks) {
                if (sb.noInventoryItem) continue;
                subItems.add((Object)new ItemStack(blk, 1, sb.meta));
            }
        }
    }

    public void setBoundingBox(int meta, float xmin, float ymin, float zmin, float xmax, float ymax, float zmax) {
        BoundingBox bb;
        if (this.boundingBoxByMeta == null) {
            this.initMeta();
        }
        this.boundingBoxByMeta[meta] = bb = new BoundingBox();
        bb.xMin = xmin;
        bb.xMax = xmax;
        bb.yMin = ymin;
        bb.yMax = ymax;
        bb.zMin = zmin;
        bb.zMax = zmax;
    }

    public BoundingBox getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.getBoundingBox(state.func_177230_c().func_176201_c(state));
    }

    public BoundingBox getBoundingBox(int meta) {
        return this.boundingBoxByMeta[meta];
    }

    public List<Cuboid> getCuboidList(int meta) {
        Subblock sb = this.getByMeta(meta &= this.metaMask);
        if (sb != null && sb.cuboids != null) {
            return sb.cuboids;
        }
        return Collections.emptyList();
    }

    public List<BoundingBox> getCollisionBoxList(int meta) {
        Subblock sb = this.getByMeta(meta &= this.metaMask);
        if (sb != null && sb.collisionBoxes != null) {
            return sb.collisionBoxes;
        }
        return Collections.emptyList();
    }

    public boolean shouldSideBeRendered(IBlockState state, IBlockAccess access, BlockPos pos, EnumFacing side) {
        int meta = state.func_177230_c().func_176201_c(state);
        BoundingBox bb = this.getBoundingBox(meta);
        if (bb == null) {
            return true;
        }
        switch (side) {
            case DOWN: {
                return bb.yMin > 0.0f;
            }
            case UP: {
                return bb.yMax < 1.0f;
            }
            case NORTH: {
                return bb.zMin > 0.0f;
            }
            case SOUTH: {
                return bb.zMax < 1.0f;
            }
            case WEST: {
                return bb.xMin > 0.0f;
            }
            case EAST: {
                return bb.xMax < 1.0f;
            }
        }
        return true;
    }

    public static void addCreativeTab(String name, CreativeTabs tab) {
        tabTable.put(name, tab);
    }

    public String getType(int meta) {
        Subblock sb = this.getByMeta(meta &= this.metaMask);
        if (sb != null && sb.type != null) {
            return sb.type;
        }
        return this.type;
    }

    public EnumPlantType getPlantType(int meta) {
        EnumPlantType pt = EnumPlantType.Plains;
        String t = this.getType(meta &= this.metaMask);
        if (t != null && t.length() > 0) {
            try {
                pt = EnumPlantType.valueOf((String)t);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (pt == null) {
                WesterosBlocks.log.error(String.format("Invalid plant type '%s' at meta %d of block '%s'", t, meta, this.blockName));
                pt = EnumPlantType.Plains;
                Subblock sb = this.getByMeta(meta);
                sb.type = pt.name();
            }
        }
        return pt;
    }

    public boolean validateMetaValues(int[] valid_meta, int[] req_meta) {
        if (valid_meta == null) {
            valid_meta = all_meta;
        }
        if (req_meta == null) {
            req_meta = new int[]{};
        }
        if (this.subBlocks != null) {
            Object object = this.subBlocks.iterator();
            while (object.hasNext()) {
                Subblock sb = (Subblock)object.next();
                if (sb == null) continue;
                int m = sb.meta;
                boolean match = false;
                for (int vmeta : valid_meta) {
                    if (m != vmeta) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    WesterosBlocks.log.error(String.format("meta value %d for block '%s' is not valid for block type '%s'", sb.meta, this.blockName, this.blockType));
                    return false;
                }
                if ((m & this.metaMask) == m) continue;
                WesterosBlocks.log.error(String.format("meta value %d for block '%s' is not valid for block type '%s' - metaMask=%x", sb.meta, this.blockName, this.blockType, this.metaMask));
                return false;
            }
        }
        for (int req : req_meta) {
            boolean match = false;
            if (this.subBlocks != null) {
                for (Subblock sb : this.subBlocks) {
                    if (sb == null || sb.meta != req) continue;
                    match = true;
                    break;
                }
            }
            if (match) continue;
            WesterosBlocks.log.error(String.format("Block '%s' is missing required meta value %d for block type '%s'", this.blockName, req, this.blockType));
            return false;
        }
        return true;
    }

    public static boolean sanityCheck(WesterosBlockDef[] defs) {
        HashSet<String> names = new HashSet<String>();
        BitSet metas = new BitSet();
        BitSet ids = new BitSet();
        for (WesterosBlockDef def : defs) {
            if (def == null) continue;
            if (def.blockName == null) {
                WesterosBlocks.log.error("Block definition is missing blockName");
                return false;
            }
            if (!names.add(def.blockName)) {
                WesterosBlocks.log.error(String.format("Block '%s' - blockName duplicated", def.blockName));
                return false;
            }
            if (def.blockIDs != null) {
                for (int i = 0; i < def.blockIDs.length; ++i) {
                    if (def.blockIDs[i] < 0) continue;
                    if (def.blockIDs[i] > 4095) {
                        WesterosBlocks.log.error(String.format("Block '%s' - blockIDs[%d] invalid", def.blockName, i));
                        return false;
                    }
                    if (ids.get(def.blockIDs[i])) {
                        WesterosBlocks.log.error(String.format("Block '%s' - blockIDs[%d] duplicated", def.blockName, i));
                        return false;
                    }
                    ids.set(def.blockIDs[i]);
                }
                def.blockID = def.blockIDs[0];
            } else {
                if (def.blockID >= 0) {
                    if (def.blockID > 4095) {
                        WesterosBlocks.log.error(String.format("Block '%s' - blockID invalid", def.blockName));
                        return false;
                    }
                    if (ids.get(def.blockID)) {
                        WesterosBlocks.log.error(String.format("Block '%s' - blockID duplicated", def.blockName));
                        return false;
                    }
                    ids.set(def.blockID);
                }
                def.blockIDs = new int[]{def.blockID};
            }
            metas.clear();
            if (def.subBlocks == null) continue;
            for (Subblock sb : def.subBlocks) {
                if (sb == null) continue;
                if (metas.get(sb.meta)) {
                    WesterosBlocks.log.error(String.format("Block '%s' - duplicate meta value %d", def.blockName, sb.meta));
                    return false;
                }
                metas.set(sb.meta);
            }
        }
        WesterosBlocks.log.info("WesterosBlocks.json passed sanity check");
        return true;
    }

    public static void initialize() {
        materialTable.put("air", Material.field_151579_a);
        materialTable.put("grass", Material.field_151577_b);
        materialTable.put("ground", Material.field_151578_c);
        materialTable.put("wood", Material.field_151575_d);
        materialTable.put("rock", Material.field_151576_e);
        materialTable.put("iron", Material.field_151573_f);
        materialTable.put("anvil", Material.field_151574_g);
        materialTable.put("water", Material.field_151586_h);
        materialTable.put("lava", Material.field_151587_i);
        materialTable.put("leaves", Material.field_151584_j);
        materialTable.put("plants", Material.field_151585_k);
        materialTable.put("vine", Material.field_151582_l);
        materialTable.put("sponge", Material.field_151583_m);
        materialTable.put("cloth", Material.field_151580_n);
        materialTable.put("fire", Material.field_151581_o);
        materialTable.put("sand", Material.field_151595_p);
        materialTable.put("circuits", Material.field_151594_q);
        materialTable.put("glass", Material.field_151592_s);
        materialTable.put("redstoneLight", Material.field_151591_t);
        materialTable.put("tnt", Material.field_151590_u);
        materialTable.put("coral", Material.field_151589_v);
        materialTable.put("ice", Material.field_151588_w);
        materialTable.put("snow", Material.field_151597_y);
        materialTable.put("craftedSnow", Material.field_151596_z);
        materialTable.put("cactus", Material.field_151570_A);
        materialTable.put("clay", Material.field_151571_B);
        materialTable.put("pumpkin", Material.field_151572_C);
        materialTable.put("dragonEgg", Material.field_151566_D);
        materialTable.put("portal", Material.field_151567_E);
        materialTable.put("cake", Material.field_151568_F);
        materialTable.put("web", Material.field_151569_G);
        materialTable.put("piston", Material.field_76233_E);
        stepSoundTable.put("powder", SoundType.field_185855_h);
        stepSoundTable.put("wood", SoundType.field_185848_a);
        stepSoundTable.put("gravel", SoundType.field_185849_b);
        stepSoundTable.put("grass", SoundType.field_185849_b);
        stepSoundTable.put("stone", SoundType.field_185851_d);
        stepSoundTable.put("metal", SoundType.field_185852_e);
        stepSoundTable.put("glass", SoundType.field_185853_f);
        stepSoundTable.put("cloth", SoundType.field_185854_g);
        stepSoundTable.put("sand", SoundType.field_185855_h);
        stepSoundTable.put("snow", SoundType.field_185856_i);
        stepSoundTable.put("ladder", SoundType.field_185857_j);
        stepSoundTable.put("anvil", SoundType.field_185858_k);
        stepSoundTable.put("plant", SoundType.field_185850_c);
        stepSoundTable.put("slime", SoundType.field_185859_l);
        tabTable.put("buildingBlocks", CreativeTabs.field_78030_b);
        tabTable.put("decorations", CreativeTabs.field_78031_c);
        tabTable.put("redstone", CreativeTabs.field_78028_d);
        tabTable.put("transportation", CreativeTabs.field_78029_e);
        tabTable.put("misc", CreativeTabs.field_78026_f);
        tabTable.put("food", CreativeTabs.field_78039_h);
        tabTable.put("tools", CreativeTabs.field_78040_i);
        tabTable.put("combat", CreativeTabs.field_78037_j);
        tabTable.put("brewing", CreativeTabs.field_78038_k);
        tabTable.put("materials", CreativeTabs.field_78035_l);
        typeTable.put("solid", new WCSolidBlock.Factory());
        typeTable.put("stair", new WCStairBlock.Factory());
        typeTable.put("log", new WCLogBlock.Factory());
        typeTable.put("plant", new WCPlantBlock.Factory());
        typeTable.put("crop", new WCCropBlock.Factory());
        typeTable.put("slab", new WCSlabBlock.Factory());
        typeTable.put("wall", new WCWallBlock.Factory());
        typeTable.put("fence", new WCFenceBlock.Factory());
        typeTable.put("web", new WCWebBlock.Factory());
        typeTable.put("torch", new WCTorchBlock.Factory());
        typeTable.put("ladder", new WCLadderBlock.Factory());
        typeTable.put("cuboid", new WCCuboidBlock.Factory());
        typeTable.put("cuboid-nsew", new WCCuboidNSEWBlock.Factory());
        typeTable.put("cuboid-ne", new WCCuboidNEBlock.Factory());
        typeTable.put("cuboid-nsewud", new WCCuboidNSEWUDBlock.Factory());
        typeTable.put("cuboid-nsew-stack", new WCCuboidNSEWStackBlock.Factory());
        typeTable.put("cuboid-ne-stack", new WCCuboidNEStackBlock.Factory());
        typeTable.put("door", new WCDoorBlock.Factory());
        typeTable.put("fire", new WCFireBlock.Factory());
        typeTable.put("leaves", new WCLeavesBlock.Factory());
        typeTable.put("pane", new WCPaneBlock.Factory());
        typeTable.put("layer", new WCLayerBlock.Factory());
        typeTable.put("soulsand", new WCSoulSandBlock.Factory());
        typeTable.put("rail", new WCRailBlock.Factory());
        typeTable.put("cake", new WCCakeBlock.Factory());
        typeTable.put("bed", new WCBedBlock.Factory());
        typeTable.put("sand", new WCSandBlock.Factory());
        typeTable.put("halfdoor", new WCHalfDoorBlock.Factory());
        typeTable.put("furnace", new WCFurnaceBlock.Factory());
        typeTable.put("sound", new WCSoundBlock.Factory());
        typeTable.put("trapdoor", new WCTrapDoorBlock.Factory());
        typeTable.put("beacon", new WCBeaconBlock.Factory());
        typeTable.put("vines", new WCVinesBlock.Factory());
        colorMultTable.put("#FFFFFF", new FixedColorMultHandler(0xFFFFFF));
        colorMultTable.put("water", new WaterColorMultHandler());
        colorMultTable.put("foliage", new FoliageColorMultHandler());
        colorMultTable.put("grass", new GrassColorMultHandler());
        colorMultTable.put("pine", new PineColorMultHandler());
        colorMultTable.put("birch", new BirchColorMultHandler());
        colorMultTable.put("basic", new BasicColorMultHandler());
        colorMultTable.put("lily", new FixedColorMultHandler(2129968));
        particles.put("hugeexplosion", EnumParticleTypes.EXPLOSION_HUGE);
        particles.put("largeexplode", EnumParticleTypes.EXPLOSION_LARGE);
        particles.put("fireworksSpark", EnumParticleTypes.FIREWORKS_SPARK);
        particles.put("bubble", EnumParticleTypes.WATER_BUBBLE);
        particles.put("suspended", EnumParticleTypes.SUSPENDED);
        particles.put("depthsuspend", EnumParticleTypes.SUSPENDED_DEPTH);
        particles.put("townaura", EnumParticleTypes.TOWN_AURA);
        particles.put("crit", EnumParticleTypes.CRIT);
        particles.put("magicCrit", EnumParticleTypes.CRIT_MAGIC);
        particles.put("smoke", EnumParticleTypes.SMOKE_NORMAL);
        particles.put("mobSpell", EnumParticleTypes.SPELL_MOB);
        particles.put("mobSpellAmbient", EnumParticleTypes.SPELL_MOB_AMBIENT);
        particles.put("spell", EnumParticleTypes.SPELL);
        particles.put("instantSpell", EnumParticleTypes.SPELL_INSTANT);
        particles.put("witchMagic", EnumParticleTypes.SPELL_WITCH);
        particles.put("note", EnumParticleTypes.NOTE);
        particles.put("portal", EnumParticleTypes.PORTAL);
        particles.put("enchantmenttable", EnumParticleTypes.ENCHANTMENT_TABLE);
        particles.put("explode", EnumParticleTypes.EXPLOSION_NORMAL);
        particles.put("flame", EnumParticleTypes.FLAME);
        particles.put("lava", EnumParticleTypes.LAVA);
        particles.put("footstep", EnumParticleTypes.FOOTSTEP);
        particles.put("splash", EnumParticleTypes.WATER_SPLASH);
        particles.put("largesmoke", EnumParticleTypes.SMOKE_LARGE);
        particles.put("cloud", EnumParticleTypes.CLOUD);
        particles.put("reddust", EnumParticleTypes.REDSTONE);
        particles.put("snowballpoof", EnumParticleTypes.SNOWBALL);
        particles.put("dripWater", EnumParticleTypes.DRIP_WATER);
        particles.put("dripLava", EnumParticleTypes.DRIP_LAVA);
        particles.put("snowshovel", EnumParticleTypes.SNOW_SHOVEL);
        particles.put("slime", EnumParticleTypes.SLIME);
        particles.put("heart", EnumParticleTypes.HEART);
        particles.put("angryVillager", EnumParticleTypes.VILLAGER_ANGRY);
        particles.put("happyVillager", EnumParticleTypes.VILLAGER_HAPPY);
    }

    public static void reloadColorHandler() {
        HashSet<String> hndids = new HashSet<String>(colorMultTable.keySet());
        for (String hndid : hndids) {
            ColorMultHandler prev = colorMultTable.get(hndid);
            if (!(prev instanceof CustomColorMultHandler)) continue;
            ((CustomColorMultHandler)prev).loadRes(hndid, "<reload>");
        }
    }

    public static ColorMultHandler getColorHandler(String hnd, String blockname) {
        String hndid = hnd.toLowerCase();
        ColorMultHandler cmh = colorMultTable.get(hndid);
        if (cmh == null) {
            if (hndid.length() == 7 && hndid.charAt(0) == '#') {
                try {
                    cmh = new FixedColorMultHandler(Integer.parseInt(hndid.substring(1), 16));
                    colorMultTable.put(hndid, cmh);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                int idx = hnd.indexOf(58);
                if (idx < 0) {
                    hnd = "westerosblocks:" + hnd;
                    hndid = hnd.toLowerCase();
                }
                if ((cmh = colorMultTable.get(hndid)) == null) {
                    cmh = new CustomColorMultHandler(hnd, blockname);
                    colorMultTable.put(hndid, cmh);
                }
            }
        }
        return cmh;
    }

    public void defaultRegisterTextures(ModTextureDefinition mtd) {
        int colon;
        mtd.setTexturePath("assets/westerosblocks/textures/blocks/");
        HashSet<String> txtids = new HashSet<String>();
        HashSet<String> maptxtids = new HashSet<String>();
        if (this.colorMult != null && !this.colorMult.startsWith("#")) {
            maptxtids.add(this.colorMult);
        }
        if (this.subblock_by_meta != null) {
            for (int i = 0; i < this.subblock_by_meta.length; ++i) {
                Subblock sb = this.subblock_by_meta[i];
                if (sb == null) continue;
                if (sb.textures != null) {
                    txtids.addAll(sb.textures);
                }
                if (sb.colorMult == null || sb.colorMult.startsWith("#")) continue;
                maptxtids.add(sb.colorMult);
            }
        }
        for (String txtid : txtids) {
            colon = txtid.indexOf(58);
            if (colon < 0) {
                mtd.registerTextureFile(txtid);
                continue;
            }
            mtd.registerTextureFile(txtid.replace(':', '_'), "assets/" + txtid.substring(0, colon).toLowerCase() + "/textures/blocks/" + txtid.substring(colon + 1) + ".png");
        }
        for (String txtid : maptxtids) {
            colon = txtid.indexOf(58);
            if (colon < 0) {
                mtd.registerBiomeTextureFile(txtid, "assets/westerosblocks/" + txtid + ".png");
                continue;
            }
            mtd.registerBiomeTextureFile(txtid.replace(':', '_'), "assets/" + txtid.substring(0, colon).toLowerCase() + "/" + txtid.substring(colon + 1) + ".png");
        }
    }

    public void registerPatchTextureBlock(ModTextureDefinition mtd, int minPatchCount) {
        this.registerPatchTextureBlock(mtd, minPatchCount, TransparencyMode.TRANSPARENT, 16);
    }

    public void registerPatchTextureBlock(ModTextureDefinition mtd, int minPatchCount, TransparencyMode tm) {
        this.registerPatchTextureBlock(mtd, minPatchCount, tm, 16);
    }

    public void registerPatchTextureBlock(ModTextureDefinition mtd, int minPatchCount, TransparencyMode tm, int meta_per_sub) {
        if (this.subblock_by_meta != null) {
            TextureModifier tmod = TextureModifier.NONE;
            if (this.nonOpaque) {
                tmod = TextureModifier.CLEARINSIDE;
            }
            for (int idx = 0; idx < this.blockIDCount; ++idx) {
                String blkname = this.getBlockName(idx);
                for (int i = 0; i < this.subblock_by_meta.length; ++i) {
                    Subblock sb = this.subblock_by_meta[i];
                    if (sb == null || sb.textures == null) continue;
                    BlockTextureRecord mtr = mtd.addBlockTextureRecord(blkname);
                    if (tm != null) {
                        mtr.setTransparencyMode(tm);
                    }
                    int cnt = 0;
                    for (int meta = i; meta < 16; ++meta) {
                        if ((meta & this.metaMask) != (i & this.metaMask) || cnt >= meta_per_sub) continue;
                        mtr.setMetaValue(meta);
                        ++cnt;
                    }
                    int cnt2 = sb.textures.size();
                    if (cnt2 < minPatchCount) {
                        cnt2 = minPatchCount;
                    }
                    for (int patch = 0; patch < cnt2; ++patch) {
                        int fidx = patch;
                        if (fidx >= sb.textures.size()) {
                            fidx = sb.textures.size() - 1;
                        }
                        String txtid = sb.textures.get(fidx);
                        mtr.setPatchTexture(txtid.replace(':', '_'), tmod, patch);
                    }
                    this.setBlockColorMap(mtr, sb);
                }
            }
        }
    }

    public void defaultRegisterTextureBlock(ModTextureDefinition mtd) {
        this.defaultRegisterTextureBlock(mtd, 0, null, 16);
    }

    public void defaultRegisterTextureBlock(ModTextureDefinition mtd, int idx, TransparencyMode tm) {
        this.defaultRegisterTextureBlock(mtd, idx, tm, 16);
    }

    public void defaultRegisterTextureBlock(ModTextureDefinition mtd, int idx, TransparencyMode tm, int meta_per_sub) {
        if (this.subblock_by_meta != null) {
            TextureModifier tmod = TextureModifier.NONE;
            if (this.nonOpaque) {
                tmod = TextureModifier.CLEARINSIDE;
            }
            String blkname = this.getBlockName(idx);
            for (int i = 0; i < this.subblock_by_meta.length; ++i) {
                Subblock sb = this.subblock_by_meta[i];
                if (sb == null || sb.textures == null) continue;
                BlockTextureRecord mtr = mtd.addBlockTextureRecord(blkname);
                if (tm != null) {
                    mtr.setTransparencyMode(tm);
                }
                int cnt = 0;
                for (int meta = i; meta < 16; ++meta) {
                    if ((meta & this.metaMask) != (i & this.metaMask) || cnt >= meta_per_sub) continue;
                    mtr.setMetaValue(meta);
                    ++cnt;
                }
                for (int face = 0; face < 6; ++face) {
                    int fidx = face;
                    if (fidx >= sb.textures.size()) {
                        fidx = sb.textures.size() - 1;
                    }
                    String txtid = sb.textures.get(fidx);
                    mtr.setSideTexture(txtid.replace(':', '_'), tmod, BlockSide.valueOf((String)("FACE_" + face)));
                }
                this.setBlockColorMap(mtr, sb);
            }
        }
    }

    public void setBlockColorMap(BlockTextureRecord mtr, Subblock sb) {
        String blockColor = sb.colorMult;
        if (blockColor == null) {
            blockColor = this.colorMult;
        }
        if (blockColor != null && !blockColor.startsWith("#")) {
            mtr.setBlockColorMapTexture(blockColor.replace(':', '_'));
        }
    }

    public String getBlockColorMapResource(Subblock sb) {
        String res = null;
        String blockColor = sb.colorMult;
        if (blockColor == null) {
            blockColor = this.colorMult;
        }
        if (blockColor != null && !blockColor.startsWith("#")) {
            String[] tok = blockColor.split(":");
            if (tok.length == 1) {
                if (tok[0].startsWith("textures/")) {
                    tok[0] = tok[0].substring(9);
                }
                res = "westerosblocks:" + tok[0];
            } else {
                if (tok[1].startsWith("textures/")) {
                    tok[1] = tok[1].substring(9);
                }
                res = tok[0] + ":" + tok[1];
            }
        }
        return res;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState state, World world, BlockPos pos, Random rnd) {
        this.doRandomDisplayTick(state, world, pos, rnd, null);
    }

    public void doRandomDisplayTick(IBlockState state, World world, BlockPos pos, Random rnd, CuboidRotation[] rot) {
        if (this.particles_by_meta == null) {
            return;
        }
        int meta = state.func_177230_c().func_176201_c(state);
        List<Particle> lst = this.particles_by_meta[meta & this.metaMask];
        if (lst == null) {
            return;
        }
        CuboidRotation cr = CuboidRotation.NONE;
        if (rot != null) {
            int mmult = meta / (this.metaMask + 1);
            if (mmult >= rot.length) {
                mmult = 0;
            }
            cr = rot[mmult];
        }
        block5: for (Particle p : lst) {
            if (p.particle == null || p.chance < 1.0f && p.chance >= rnd.nextFloat()) continue;
            double dx = p.x;
            double dy = p.y;
            double dz = p.z;
            double dvx = p.vx;
            double dvy = p.vy;
            double dvz = p.vz;
            if (p.xrand > 0.0f) {
                dx += (double)(p.xrand * (rnd.nextFloat() - 0.5f)) * 2.0;
            }
            if (p.yrand > 0.0f) {
                dy += (double)(p.yrand * (rnd.nextFloat() - 0.5f)) * 2.0;
            }
            if (p.zrand > 0.0f) {
                dz += (double)(p.zrand * (rnd.nextFloat() - 0.5f)) * 2.0;
            }
            if (p.vxrand > 0.0f) {
                dvx += (double)(p.vxrand * (rnd.nextFloat() - 0.5f)) * 2.0;
            }
            if (p.vyrand > 0.0f) {
                dvy += (double)(p.vyrand * (rnd.nextFloat() - 0.5f)) * 2.0;
            }
            if (p.vzrand > 0.0f) {
                dvz += (double)(p.vzrand * (rnd.nextFloat() - 0.5f)) * 2.0;
            }
            double x = pos.func_177958_n();
            double y = pos.func_177956_o();
            double z = pos.func_177952_p();
            switch (cr) {
                default: {
                    world.func_175688_a(particles.get(p.particle), x + dx, y + dy, z + dz, dvx, dvy, dvz, new int[0]);
                    continue block5;
                }
                case ROTY90: {
                    world.func_175688_a(particles.get(p.particle), x + dz, y + dy, z + 1.0 - dx, -dvz, dvy, dvx, new int[0]);
                    continue block5;
                }
                case ROTY180: {
                    world.func_175688_a(particles.get(p.particle), x + 1.0 - dx, y + dy, z + 1.0 - dz, -dvx, dvy, -dvz, new int[0]);
                    continue block5;
                }
                case ROTY270: 
            }
            world.func_175688_a(particles.get(p.particle), x + 1.0 - dz, y + dy, z + dx, dvz, dvy, -dvx, new int[0]);
        }
    }

    public void setBlockIDCount(int cnt) {
        this.blockIDCount = cnt;
    }

    public void registerTileEntity(Class<? extends TileEntity> teclass, String std_id) {
        TileEntityRec ter = te_rec.get(std_id);
        if (ter == null) {
            ter = new TileEntityRec();
            ter.te_class = teclass;
            te_rec.put(std_id, ter);
        }
        ter.legacy_ids.add(this.blockName);
    }

    public static void processRegisterTileEntities() {
        for (String std_id : te_rec.keySet()) {
            TileEntityRec ter = te_rec.get(std_id);
            GameRegistry.registerTileEntity(ter.te_class, (String)std_id);
        }
    }

    public void registerSoundEvents() {
        for (Subblock sb : this.subBlocks) {
            if (sb.soundList == null) continue;
            for (String snd : sb.soundList) {
                WesterosBlocks.registerSound(snd);
            }
        }
    }

    private static class TileEntityRec {
        Class<? extends TileEntity> te_class;
        List<String> legacy_ids = new ArrayList<String>();

        private TileEntityRec() {
        }
    }

    public static class CustomColorMultHandler
    extends ColorMultHandler {
        private int[] colorBuffer = new int[65536];

        CustomColorMultHandler(String rname, String blockName) {
            this.loadRes(rname, blockName);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public int getBlockColor() {
            return this.getColor(0.5f, 1.0f);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void loadRes(String rname, String blkname) {
            if (rname.indexOf(58) < 0) {
                rname = "westerosblocks:" + rname;
            }
            if (!rname.endsWith(".png")) {
                rname = rname + ".png";
            }
            try {
                this.colorBuffer = TextureUtil.func_110986_a((IResourceManager)Minecraft.func_71410_x().func_110442_L(), (ResourceLocation)new ResourceLocation(rname));
            }
            catch (Exception e) {
                WesterosBlocks.log.error(String.format("Invalid color resource '%s' in block '%s'", rname, blkname));
                Arrays.fill(this.colorBuffer, 0xFFFFFF);
            }
        }

        private int getColor(float tmp, float hum) {
            tmp = MathHelper.func_76131_a((float)tmp, (float)0.0f, (float)1.0f);
            hum = MathHelper.func_76131_a((float)hum, (float)0.0f, (float)1.0f);
            int i = (int)((1.0 - (double)tmp) * 255.0);
            int j = (int)((1.0 - (double)(hum *= tmp)) * 255.0);
            return this.colorBuffer[j << 8 | i];
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public int colorMultiplier(IBlockAccess access, BlockPos pos) {
            int red = 0;
            int green = 0;
            int blue = 0;
            for (int xx = -1; xx <= 1; ++xx) {
                for (int zz = -1; zz <= 1; ++zz) {
                    BlockPos bp = pos.func_177982_a(xx, 0, zz);
                    Biome biome = access.func_180494_b(bp);
                    int mult = this.getColor(biome.func_180626_a(bp), biome.func_76727_i());
                    red += (mult & 0xFF0000) >> 16;
                    green += (mult & 0xFF00) >> 8;
                    blue += mult & 0xFF;
                }
            }
            return (red / 9 & 0xFF) << 16 | (green / 9 & 0xFF) << 8 | blue / 9 & 0xFF;
        }
    }

    public static class BasicColorMultHandler
    extends ColorMultHandler {
        @Override
        @SideOnly(value=Side.CLIENT)
        public int getBlockColor() {
            return ColorizerFoliage.func_77468_c();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public int colorMultiplier(IBlockAccess access, BlockPos pos) {
            return ColorizerFoliage.func_77468_c();
        }
    }

    public static class BirchColorMultHandler
    extends ColorMultHandler {
        @Override
        @SideOnly(value=Side.CLIENT)
        public int getBlockColor() {
            return ColorizerFoliage.func_77469_b();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public int colorMultiplier(IBlockAccess access, BlockPos pos) {
            return ColorizerFoliage.func_77469_b();
        }
    }

    public static class PineColorMultHandler
    extends ColorMultHandler {
        @Override
        @SideOnly(value=Side.CLIENT)
        public int getBlockColor() {
            return ColorizerFoliage.func_77466_a();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public int colorMultiplier(IBlockAccess access, BlockPos pos) {
            return ColorizerFoliage.func_77466_a();
        }
    }

    public static class WaterColorMultHandler
    extends ColorMultHandler {
        WaterColorMultHandler() {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public int colorMultiplier(IBlockAccess access, BlockPos pos) {
            int red = 0;
            int green = 0;
            int blue = 0;
            for (int xx = -1; xx <= 1; ++xx) {
                for (int zz = -1; zz <= 1; ++zz) {
                    BlockPos bp = pos.func_177982_a(xx, 0, zz);
                    int mult = access.func_180494_b(bp).getWaterColorMultiplier();
                    red += (mult & 0xFF0000) >> 16;
                    green += (mult & 0xFF00) >> 8;
                    blue += mult & 0xFF;
                }
            }
            return (red / 9 & 0xFF) << 16 | (green / 9 & 0xFF) << 8 | blue / 9 & 0xFF;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public int getBlockColor() {
            return 0xFFFFFF;
        }
    }

    public static class GrassColorMultHandler
    extends ColorMultHandler {
        GrassColorMultHandler() {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public int getBlockColor() {
            return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public int colorMultiplier(IBlockAccess access, BlockPos pos) {
            int red = 0;
            int green = 0;
            int blue = 0;
            for (int xx = -1; xx <= 1; ++xx) {
                for (int zz = -1; zz <= 1; ++zz) {
                    BlockPos bp = pos.func_177982_a(xx, 0, zz);
                    int mult = access.func_180494_b(bp).func_180627_b(bp);
                    red += (mult & 0xFF0000) >> 16;
                    green += (mult & 0xFF00) >> 8;
                    blue += mult & 0xFF;
                }
            }
            return (red / 9 & 0xFF) << 16 | (green / 9 & 0xFF) << 8 | blue / 9 & 0xFF;
        }
    }

    public static class FoliageColorMultHandler
    extends ColorMultHandler {
        FoliageColorMultHandler() {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public int getBlockColor() {
            return ColorizerFoliage.func_77470_a((double)0.5, (double)1.0);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public int colorMultiplier(IBlockAccess access, BlockPos pos) {
            int red = 0;
            int green = 0;
            int blue = 0;
            for (int xx = -1; xx <= 1; ++xx) {
                for (int zz = -1; zz <= 1; ++zz) {
                    BlockPos bp = pos.func_177982_a(xx, 0, zz);
                    int mult = access.func_180494_b(bp).func_180625_c(bp);
                    red += (mult & 0xFF0000) >> 16;
                    green += (mult & 0xFF00) >> 8;
                    blue += mult & 0xFF;
                }
            }
            return (red / 9 & 0xFF) << 16 | (green / 9 & 0xFF) << 8 | blue / 9 & 0xFF;
        }
    }

    public static class FixedColorMultHandler
    extends ColorMultHandler {
        protected int fixedMult;

        FixedColorMultHandler(int mult) {
            this.fixedMult = mult;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public int getBlockColor() {
            return this.fixedMult;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public int colorMultiplier(IBlockAccess access, BlockPos pos) {
            return this.fixedMult;
        }

        @Override
        protected void setBaseColor() {
        }

        @Override
        protected void loadRes(String rname, String blkname) {
        }
    }

    public static abstract class ColorMultHandler {
        ColorMultHandler() {
        }

        @SideOnly(value=Side.CLIENT)
        public abstract int getBlockColor();

        @SideOnly(value=Side.CLIENT)
        public abstract int colorMultiplier(IBlockAccess var1, BlockPos var2);

        protected void setBaseColor() {
        }

        protected void loadRes(String rname, String blkname) {
        }
    }

    public static class Subblock {
        public int meta;
        public String label;
        public List<HarvestLevel> harvestLevel = null;
        public int harvestItemID = -999;
        public int fireSpreadSpeed = -999;
        public int flamability = -999;
        public String stepSound = null;
        public String material = null;
        public float lightValue = -999.0f;
        public int lightOpacity = -999;
        public List<String> textures = null;
        public String itemTexture = null;
        public BoundingBox boundingBox = null;
        public String type = null;
        public int itemTextureIndex = 0;
        public String colorMult = null;
        public List<Cuboid> cuboids = null;
        public List<BoundingBox> collisionBoxes = null;
        public List<String> soundList = null;
        public boolean noInventoryItem = false;
        public List<Particle> particles = null;
        public Boolean ambientOcclusion = null;
        public Boolean isCustomModel = null;

        public String getTextureByIndex(int idx) {
            if (this.textures != null && this.textures.size() > 0) {
                if (idx >= this.textures.size()) {
                    idx = this.textures.size() - 1;
                }
                return this.textures.get(idx);
            }
            return null;
        }

        public boolean isCustomModel() {
            return this.isCustomModel != null && this.isCustomModel == true;
        }

        public boolean isTinted(WesterosBlockDef def) {
            return this.colorMult != null && !this.colorMult.equals("#FFFFFF") || !def.colorMult.equals("#FFFFFF");
        }
    }

    public static class Particle {
        public float x = 0.5f;
        public float y = 0.5f;
        public float z = 0.5f;
        public float vx = 0.0f;
        public float vy = 0.0f;
        public float vz = 0.0f;
        public float xrand = 0.0f;
        public float yrand = 0.0f;
        public float zrand = 0.0f;
        public float vxrand = 0.0f;
        public float vyrand = 0.0f;
        public float vzrand = 0.0f;
        public float chance = 1.0f;
        public String particle;
    }

    public static class Cuboid
    extends BoundingBox {
        public int[] sideTextures = null;
        public int[] sideRotations = new int[]{0, 0, 0, 0, 0, 0};
        public String shape = "box";

        public Cuboid rotateCuboid(CuboidRotation rot) {
            Cuboid c = new Cuboid();
            Vector v0 = new Vector();
            Vector v1 = new Vector();
            v0.x = this.xMin;
            v0.y = this.yMin;
            v0.z = this.zMin;
            v1.x = this.xMax;
            v1.y = this.yMax;
            v1.z = this.zMax;
            v0.rotate(rot.xrot, rot.yrot, rot.zrot);
            v1.rotate(rot.xrot, rot.yrot, rot.zrot);
            c.xMin = Math.min(v0.x, v1.x);
            c.xMax = Math.max(v0.x, v1.x);
            c.yMin = Math.min(v0.y, v1.y);
            c.yMax = Math.max(v0.y, v1.y);
            c.zMin = Math.min(v0.z, v1.z);
            c.zMax = Math.max(v0.z, v1.z);
            if (this.sideTextures != null) {
                c.sideTextures = new int[rot.txtidx.length];
                int cnt = this.sideTextures.length;
                for (int i = 0; i < c.sideTextures.length; ++i) {
                    int newidx = rot.txtidx[i];
                    c.sideTextures[i] = newidx < cnt ? this.sideTextures[newidx] : this.sideTextures[cnt - 1];
                }
            } else {
                c.sideTextures = rot.txtidx;
            }
            c.sideRotations = rot.txtrot;
            c.shape = this.shape;
            return c;
        }

        public Cuboid() {
        }

        public Cuboid(float x0, float y0, float z0, float x1, float y1, float z1) {
            this(x0, y0, z0, x1, y1, z1, null);
        }

        public Cuboid(float x0, float y0, float z0, float x1, float y1, float z1, int[] sidetextures) {
            this.xMin = x0;
            this.xMax = x1;
            this.yMin = y0;
            this.yMax = y1;
            this.zMin = z0;
            this.zMax = z1;
            this.sideTextures = sidetextures;
        }
    }

    public static enum CuboidRotation {
        NONE(0, 0, 0, new int[]{0, 1, 2, 3, 4, 5}, new int[]{0, 0, 0, 0, 0, 0}),
        ROTY90(0, 90, 0, new int[]{0, 1, 4, 5, 3, 2}, new int[]{270, 90, 0, 0, 0, 0}),
        ROTY180(0, 180, 0, new int[]{0, 1, 3, 2, 5, 4}, new int[]{180, 180, 0, 0, 0, 0}),
        ROTY270(0, 270, 0, new int[]{0, 1, 5, 4, 2, 3}, new int[]{90, 270, 0, 0, 0, 0}),
        ROTZ90(0, 0, 90, new int[]{5, 4, 2, 3, 0, 1}, new int[]{270, 90, 270, 90, 90, 90}),
        ROTZ270(0, 0, 270, new int[]{4, 5, 2, 3, 1, 0}, new int[]{90, 270, 90, 270, 270, 270});

        final int xrot;
        final int yrot;
        final int zrot;
        final int[] txtidx;
        final int[] txtrot;

        private CuboidRotation(int xr, int yr, int zr, int[] txt_idx, int[] txt_rot) {
            this.xrot = xr;
            this.yrot = yr;
            this.zrot = zr;
            this.txtidx = txt_idx;
            this.txtrot = txt_rot;
        }
    }

    public static class Vector {
        float x;
        float y;
        float z;

        private void rotate(int xcnt, int ycnt, int zcnt) {
            double xx = this.x - 0.5f;
            double yy = this.y - 0.5f;
            double zz = this.z - 0.5f;
            double rot = Math.toRadians(xcnt);
            double nval = zz * Math.sin(rot) + yy * Math.cos(rot);
            zz = zz * Math.cos(rot) - yy * Math.sin(rot);
            yy = nval;
            rot = Math.toRadians(ycnt);
            nval = xx * Math.cos(rot) - zz * Math.sin(rot);
            zz = xx * Math.sin(rot) + zz * Math.cos(rot);
            xx = nval;
            rot = Math.toRadians(zcnt);
            nval = yy * Math.sin(rot) + xx * Math.cos(rot);
            yy = yy * Math.cos(rot) - xx * Math.sin(rot);
            xx = nval;
            this.x = (float)xx + 0.5f;
            this.y = (float)yy + 0.5f;
            this.z = (float)zz + 0.5f;
            if (this.x > 1.0f) {
                this.x = 1.0f;
            }
            if (this.y > 1.0f) {
                this.y = 1.0f;
            }
            if (this.z > 1.0f) {
                this.z = 1.0f;
            }
            if (this.x < 0.0f) {
                this.x = 0.0f;
            }
            if (this.y < 0.0f) {
                this.y = 0.0f;
            }
            if (this.z < 0.0f) {
                this.z = 0.0f;
            }
        }
    }

    public static class BoundingBox {
        public float xMin = 0.0f;
        public float xMax = 1.0f;
        public float yMin = 0.0f;
        public float yMax = 1.0f;
        public float zMin = 0.0f;
        public float zMax = 1.0f;
        private transient AxisAlignedBB aabb = null;

        public AxisAlignedBB getAABB() {
            if (this.aabb == null) {
                this.aabb = new AxisAlignedBB((double)this.xMin, (double)this.yMin, (double)this.zMin, (double)this.xMax, (double)this.yMax, (double)this.zMax);
            }
            return this.aabb;
        }
    }

    public static class HarvestLevel {
        public String tool;
        public int level;
    }
}

